/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio.model;

import com.google.common.base.Preconditions;
import com.timestored.kdb.KdbConnection;
import com.timestored.qstudio.kdb.KdbHelper;
import java.awt.Component;
import java.io.IOException;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import kx.c;
import net.jcip.annotations.Immutable;

@Immutable
public class ServerReport {
    private Component diskTab;
    private Component memTab;
    private final int ip;
    private final String hostname;
    private final int pid;
    private final String kdbReleaseDate;
    private final double kdbMajorVersion;
    private final String licenseInfo;
    private final String os;
    private final String userId;
    private final String commandLineArguments;
    private final int slaveThreads;
    private static final String INFO_K = ".:'[$`.z.a`.z.h`.z.i`.z.k`.z.K`.z.l`.z.o`.z.u`.z.x,`$\"\\\\s\"]";
    private static final String SEGMENTS_PARTITIONS_TAB_K = "{$[min `PV`PD`D`pf in !: `.Q; ([] desc:! b; val:. b:(`Segments`Partitions`PartitionType)!(#.Q.D;#.Q.PD;.Q.pf)); ([] Data:,\"Not partitioned or segmented\")]}[]";
    private static final String MEMORY_REPORT_TAB_K = "+:{,x}'.Q.w[]";

    ServerReport(KdbConnection kdbConn) throws IOException, c.KException {
        Preconditions.checkNotNull(kdbConn);
        Preconditions.checkArgument(kdbConn.isConnected());
        Object k = kdbConn.query("k)({$[min `PV`PD`D`pf in !: `.Q; ([] desc:! b; val:. b:(`Segments`Partitions`PartitionType)!(#.Q.D;#.Q.PD;.Q.pf)); ([] Data:,\"Not partitioned or segmented\")]}[];+:{,x}'.Q.w[];.:'[$`.z.a`.z.h`.z.i`.z.k`.z.K`.z.l`.z.o`.z.u`.z.x,`$\"\\\\s\"])");
        Object[] resArray = (Object[])k;
        this.diskTab = KdbHelper.getJXTable(resArray[0]);
        this.memTab = KdbHelper.getJXTable(resArray[1]);
        Object[] obj = (Object[])resArray[2];
        this.ip = (Integer)obj[0];
        this.hostname = (String)obj[1];
        this.pid = (Integer)obj[2];
        this.kdbReleaseDate = KdbHelper.asLine(obj[3]);
        this.kdbMajorVersion = (Double)obj[4];
        this.licenseInfo = KdbHelper.asLine(obj[5]);
        this.os = (String)obj[6];
        this.userId = (String)obj[7];
        this.commandLineArguments = KdbHelper.asLine(obj[8]);
        this.slaveThreads = (Integer)obj[9];
    }

    public String getIp() {
        return (this.ip >> 24 & 0xFF) + "." + (this.ip >> 16 & 0xFF) + "." + (this.ip >> 8 & 0xFF) + "." + (this.ip & 0xFF);
    }

    public TableModel getGeneralInfoTable() {
        return new DefaultTableModel(new String[][]{{"IP Address", this.getIp()}, {"Hostname", this.hostname}, {"PID", "" + this.pid}, {"KDB Release Date", this.kdbReleaseDate != null ? this.kdbReleaseDate.toString() : ""}, {"KDB Version", "" + this.kdbMajorVersion}, {"License", this.licenseInfo}, {"OS", this.os}, {"User ID", this.userId}, {"Command Line Args", this.commandLineArguments}, {"Slave Threads", "" + this.slaveThreads}}, new String[]{"Property", "Value"});
    }

    public Component getDiskTab() {
        return this.diskTab;
    }

    public Component getMemTab() {
        return this.memTab;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPid() {
        return this.pid;
    }

    public String getKdbReleaseDate() {
        return this.kdbReleaseDate;
    }

    public double getKdbMajorVersion() {
        return this.kdbMajorVersion;
    }

    public String getLicenseInfo() {
        return this.licenseInfo;
    }

    public String getOs() {
        return this.os;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getCommandLineArguments() {
        return this.commandLineArguments;
    }

    public int getSlaveThreads() {
        return this.slaveThreads;
    }

    public void setDiskTab(Component diskTab) {
        this.diskTab = diskTab;
    }

    public void setMemTab(Component memTab) {
        this.memTab = memTab;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerReport)) {
            return false;
        }
        ServerReport other = (ServerReport)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        if (this.getPid() != other.getPid()) {
            return false;
        }
        if (Double.compare(this.getKdbMajorVersion(), other.getKdbMajorVersion()) != 0) {
            return false;
        }
        if (this.getSlaveThreads() != other.getSlaveThreads()) {
            return false;
        }
        Component this$diskTab = this.getDiskTab();
        Component other$diskTab = other.getDiskTab();
        if (this$diskTab == null ? other$diskTab != null : !this$diskTab.equals(other$diskTab)) {
            return false;
        }
        Component this$memTab = this.getMemTab();
        Component other$memTab = other.getMemTab();
        if (this$memTab == null ? other$memTab != null : !this$memTab.equals(other$memTab)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$kdbReleaseDate = this.getKdbReleaseDate();
        String other$kdbReleaseDate = other.getKdbReleaseDate();
        if (this$kdbReleaseDate == null ? other$kdbReleaseDate != null : !this$kdbReleaseDate.equals(other$kdbReleaseDate)) {
            return false;
        }
        String this$licenseInfo = this.getLicenseInfo();
        String other$licenseInfo = other.getLicenseInfo();
        if (this$licenseInfo == null ? other$licenseInfo != null : !this$licenseInfo.equals(other$licenseInfo)) {
            return false;
        }
        String this$os = this.getOs();
        String other$os = other.getOs();
        if (this$os == null ? other$os != null : !this$os.equals(other$os)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$commandLineArguments = this.getCommandLineArguments();
        String other$commandLineArguments = other.getCommandLineArguments();
        return !(this$commandLineArguments == null ? other$commandLineArguments != null : !this$commandLineArguments.equals(other$commandLineArguments));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerReport;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        result = result * 59 + this.getPid();
        long $kdbMajorVersion = Double.doubleToLongBits(this.getKdbMajorVersion());
        result = result * 59 + (int)($kdbMajorVersion >>> 32 ^ $kdbMajorVersion);
        result = result * 59 + this.getSlaveThreads();
        Component $diskTab = this.getDiskTab();
        result = result * 59 + ($diskTab == null ? 43 : $diskTab.hashCode());
        Component $memTab = this.getMemTab();
        result = result * 59 + ($memTab == null ? 43 : $memTab.hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $kdbReleaseDate = this.getKdbReleaseDate();
        result = result * 59 + ($kdbReleaseDate == null ? 43 : $kdbReleaseDate.hashCode());
        String $licenseInfo = this.getLicenseInfo();
        result = result * 59 + ($licenseInfo == null ? 43 : $licenseInfo.hashCode());
        String $os = this.getOs();
        result = result * 59 + ($os == null ? 43 : $os.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $commandLineArguments = this.getCommandLineArguments();
        result = result * 59 + ($commandLineArguments == null ? 43 : $commandLineArguments.hashCode());
        return result;
    }

    public String toString() {
        return "ServerReport(diskTab=" + this.getDiskTab() + ", memTab=" + this.getMemTab() + ", ip=" + this.getIp() + ", hostname=" + this.getHostname() + ", pid=" + this.getPid() + ", kdbReleaseDate=" + this.getKdbReleaseDate() + ", kdbMajorVersion=" + this.getKdbMajorVersion() + ", licenseInfo=" + this.getLicenseInfo() + ", os=" + this.getOs() + ", userId=" + this.getUserId() + ", commandLineArguments=" + this.getCommandLineArguments() + ", slaveThreads=" + this.getSlaveThreads() + ")";
    }
}

