/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio.model;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.timestored.connections.JdbcTypes;
import com.timestored.misc.HtmlUtils;
import com.timestored.qstudio.kdb.CAtomTypes;
import com.timestored.qstudio.model.BaseSQE;
import com.timestored.qstudio.model.ServerQEntity;
import com.timestored.qstudio.model.TableSQE;
import com.timestored.theme.Theme;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class ServerQEntityFactory {
    ServerQEntityFactory() {
    }

    static ServerQEntity get(String serverName, String namespace, String name, Short typeNum, long count, boolean isTable, boolean partitioned, boolean isView, String[] colArgNames, JdbcTypes jdbcTypes) {
        CAtomTypes t = CAtomTypes.getType(typeNum.shortValue());
        if (t == null) {
            return null;
        }
        if (isView) {
            return ServerQEntityFactory.getView(serverName, namespace, name);
        }
        if (isTable) {
            return ServerQEntityFactory.getTable(serverName, namespace, name, typeNum.shortValue(), count, partitioned, colArgNames, jdbcTypes);
        }
        if (t.isList()) {
            return new ListSQE(serverName, namespace, name, t, count, jdbcTypes);
        }
        if (t.equals((Object)CAtomTypes.DICTIONARY)) {
            return new DictSQE(serverName, namespace, name, count);
        }
        if (t.equals((Object)CAtomTypes.LAMBDA)) {
            return new LambdaSQE(serverName, namespace, name, colArgNames);
        }
        return new AtomSQE(serverName, namespace, name, t, jdbcTypes);
    }

    static ServerQEntity getTable(String serverName, String namespace, String name, int typeNum, long count, boolean isPartitioned, String[] colNames, JdbcTypes jdbcTypes) {
        return new TableSQE(serverName, namespace, name, CAtomTypes.getType(typeNum), count, isPartitioned, colNames, jdbcTypes);
    }

    static ServerQEntity getTable(String serverName, String namespace, String name, int typeNum, long count, boolean isPartitioned, String[] colNames) {
        return new TableSQE(serverName, namespace, name, CAtomTypes.getType(typeNum), count, isPartitioned, colNames, null);
    }

    static ServerQEntity getAtom(String serverName, String namespace, String name, int typeNum, JdbcTypes jdbcTypes) {
        return new AtomSQE(serverName, namespace, name, CAtomTypes.getType(typeNum), jdbcTypes);
    }

    static ServerQEntity getDict(String serverName, String namespace, String name, int count) {
        return new DictSQE(serverName, namespace, name, count);
    }

    static ServerQEntity getLambda(String serverName, String namespace, String name, String[] argNames) {
        return new LambdaSQE(serverName, namespace, name, argNames);
    }

    static ServerQEntity getView(String serverName, String namespace, String name) {
        return new ViewSQE(serverName, namespace, name);
    }

    private static class LambdaSQE
    extends BaseSQE {
        final List<String> argNames;

        public LambdaSQE(String serverName, String namespace, String name, String[] argNames) {
            super(serverName, namespace, name, CAtomTypes.LAMBDA, null);
            this.argNames = Arrays.asList(argNames);
        }

        @Override
        public long getCount() {
            return 1L;
        }

        @Override
        public boolean isTable() {
            return false;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof LambdaSQE) {
                LambdaSQE that = (LambdaSQE)o;
                return super.equals(o) && Objects.equal(this.argNames, that.argNames);
            }
            return false;
        }

        @Override
        public String toString() {
            return "LambdaSQE[" + this.getName() + " args=" + Joiner.on(",").join(this.argNames) + "]";
        }

        @Override
        public String getDocName() {
            if (this.argNames.size() > 2 || !this.argNames.contains("x")) {
                return this.getFullName() + "[" + Joiner.on(";").join(this.argNames) + "]";
            }
            return this.getFullName();
        }

        @Override
        public String getHtmlDoc(boolean shortFormat) {
            return LambdaSQE.toHtml(ImmutableMap.of("Name: ", this.getDocName(), "Arguments: ", HtmlUtils.toList(this.argNames)));
        }
    }

    private static class ViewSQE
    extends BaseSQE {
        public ViewSQE(String serverName, String namespace, String name) {
            super(serverName, namespace, name, CAtomTypes.VIEW, null);
        }

        @Override
        public long getCount() {
            return 1L;
        }

        @Override
        public boolean isTable() {
            return false;
        }

        @Override
        public String getHtmlDoc(boolean shortFormat) {
            return ViewSQE.toHtml(ImmutableMap.of("Name: ", this.getDocName(), "Type: ", this.getType().toString().toLowerCase()));
        }
    }

    private static class AtomSQE
    extends BaseSQE {
        public AtomSQE(String serverName, String namespace, String name, CAtomTypes type, JdbcTypes jdbcTypes) {
            super(serverName, namespace, name, type, jdbcTypes);
            Preconditions.checkArgument(type.isAtom());
        }

        @Override
        public long getCount() {
            return 1L;
        }

        @Override
        public boolean isTable() {
            return false;
        }

        @Override
        public String getHtmlDoc(boolean shortFormat) {
            if (shortFormat) {
                return "<html><body>Type: " + this.getType().toString().toLowerCase() + "</body></html>";
            }
            return AtomSQE.toHtml(ImmutableMap.of("Name: ", this.getDocName(), "Type: ", this.getType().toString().toLowerCase()));
        }

        @Override
        public List<ServerQEntity.QQuery> getQQueries() {
            String fn = this.getFullName();
            if (this.jdbcTypes != null && !this.jdbcTypes.isKDB()) {
                ArrayList<ServerQEntity.QQuery> r = new ArrayList<ServerQEntity.QQuery>();
                r.add(new ServerQEntity.QQuery(fn, Theme.CIcon.TABLE_ELEMENT, fn));
                r.addAll(super.getQQueries());
                return r;
            }
            return super.getQQueries();
        }
    }

    private static class DictSQE
    extends BaseSQE {
        private final long count;

        public DictSQE(String serverName, String namespace, String name, long count) {
            super(serverName, namespace, name, CAtomTypes.DICTIONARY, null);
            Preconditions.checkArgument(count >= 0L);
            this.count = count;
        }

        @Override
        public boolean isTable() {
            return false;
        }

        @Override
        public long getCount() {
            return this.count;
        }
    }

    private static class ListSQE
    extends BaseSQE {
        private final long count;

        public ListSQE(String serverName, String namespace, String name, CAtomTypes type, long count, JdbcTypes jdbcTypes) {
            super(serverName, namespace, name, type, jdbcTypes);
            Preconditions.checkArgument(count >= 0L);
            Preconditions.checkArgument(type.isList());
            this.count = count;
        }

        @Override
        public boolean isTable() {
            return false;
        }

        @Override
        public List<ServerQEntity.QQuery> getQQueries() {
            String fn = this.getFullName();
            if (this.jdbcTypes != null && !this.jdbcTypes.isKDB()) {
                ArrayList<ServerQEntity.QQuery> r = new ArrayList<ServerQEntity.QQuery>();
                r.add(new ServerQEntity.QQuery(fn, Theme.CIcon.TABLE_ELEMENT, fn));
                r.addAll(super.getQQueries());
                return r;
            }
            return super.getQQueries();
        }

        @Override
        public long getCount() {
            return this.count;
        }
    }
}

