/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio.model;

import com.google.common.base.Objects;
import com.timestored.qdoc.DocumentedEntity;
import com.timestored.qstudio.kdb.CAtomTypes;
import com.timestored.qstudio.model.QEntity;
import com.timestored.theme.Icon;
import com.timestored.theme.Theme;
import java.util.List;
import javax.swing.ImageIcon;

public interface ServerQEntity
extends QEntity {
    public String getName();

    public CAtomTypes getType();

    public long getCount();

    public boolean isTable();

    public List<QQuery> getQQueries();

    public static class QQuery {
        private final String query;
        private final String title;
        private final Icon icon;

        public QQuery(String title, Icon icon, String query) {
            this.query = query;
            this.title = title;
            this.icon = icon;
        }

        public String getTitle() {
            return this.title;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public String getQuery() {
            return this.query;
        }

        public String toString() {
            return "QQuery [query=" + this.query + ", title=" + this.title + "]";
        }

        public boolean equals(Object obj) {
            if (obj instanceof QQuery) {
                QQuery that = (QQuery)obj;
                return Objects.equal(this.query, that.query) && Objects.equal(this.icon, that.icon) && Objects.equal(this.title, that.title);
            }
            return false;
        }

        public DocumentedEntity toDocumentedEntity() {
            return new DocumentedEntity(){

                @Override
                public String getDocName() {
                    return query;
                }

                @Override
                public String getHtmlDoc(boolean shortFormat) {
                    return query;
                }

                @Override
                public DocumentedEntity.SourceType getSourceType() {
                    return DocumentedEntity.SourceType.SERVER;
                }

                @Override
                public String getFullName() {
                    return query;
                }

                @Override
                public String getSource() {
                    return "sql";
                }

                @Override
                public ImageIcon getIcon() {
                    return Theme.CIcon.SCRIPT_GO.get16();
                }
            };
        }
    }
}

