/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio.model;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.timestored.connections.ConnectionManager;
import com.timestored.connections.JdbcTypes;
import com.timestored.connections.MetaInfo;
import com.timestored.connections.ServerConfig;
import com.timestored.kdb.KdbConnection;
import com.timestored.qdoc.DocumentedEntity;
import com.timestored.qstudio.QStudioLauncher;
import com.timestored.qstudio.kdb.CAtomTypes;
import com.timestored.qstudio.model.NamespaceListing;
import com.timestored.qstudio.model.QEntity;
import com.timestored.qstudio.model.ServerQEntity;
import com.timestored.qstudio.model.ServerQEntityFactory;
import com.timestored.qstudio.model.TableSQE;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.activation.UnsupportedDataTypeException;
import javax.sql.rowset.CachedRowSet;
import kx.c;

public class ServerObjectTree {
    private static final Logger LOG = Logger.getLogger(ServerObjectTree.class.getName());
    public static final Set<String> BUILTIN_NS = ImmutableSet.of(".Q", ".j", ".q", ".h", ".o");
    private static String GET_TREE_QUERY = null;
    private static final String DEFAULT_NAMESPACE = ".";
    private static final List<ServerQEntity> EMPTY_LIST = Collections.emptyList();
    private RefreshResult refreshResult;
    private final ServerConfig serverConfig;
    private final ConnectionManager connectionManager;
    private boolean errorRetrievingTree = false;

    ServerObjectTree(ConnectionManager connectionManager, ServerConfig serverConfig) {
        this.serverConfig = Preconditions.checkNotNull(serverConfig);
        this.connectionManager = Preconditions.checkNotNull(connectionManager);
        this.refreshResult = new RefreshResult();
        this.refreshFromServer();
    }

    private void refreshFromServer() {
        this.refreshResult = ServerObjectTree.refreshTree(this.serverConfig, this.connectionManager);
    }

    private static RefreshResult refreshTree(ServerConfig serverConfig, ConnectionManager connectionManager) {
        Preconditions.checkNotNull(serverConfig);
        Preconditions.checkNotNull(connectionManager);
        Exception e = null;
        String errMsg = "";
        Map<Object, Object> namespaceListingMap = Collections.emptyMap();
        try {
            namespaceListingMap = serverConfig.isKDB() ? ServerObjectTree.getNSListing(serverConfig, connectionManager) : (serverConfig.getJdbcType().equals((Object)JdbcTypes.DOLPHINDB) ? ServerObjectTree.getNSListingForDolphin(serverConfig, connectionManager) : ServerObjectTree.getNSqlListing(serverConfig, connectionManager));
        }
        catch (c.KException ke) {
            e = ke;
            errMsg = "Kdb Exception when querying server. Ensure server security settings ok.";
        }
        catch (IOException ioe) {
            e = ioe;
            errMsg = "IO Error communicating with Server: " + ioe.getMessage();
        }
        catch (Exception ex) {
            e = ex;
            errMsg = "Exception when querying server. Ensure server security settings ok.";
        }
        if (e != null) {
            LOG.log(Level.WARNING, errMsg, e);
        }
        return new RefreshResult(namespaceListingMap, errMsg);
    }

    private static Map<String, NamespaceListing> getNSqlListing(ServerConfig serverConfig, ConnectionManager connectionManager) throws Exception {
        ArrayList<ServerQEntity> allElements = new ArrayList<ServerQEntity>();
        MetaInfo mi = MetaInfo.getMetaInfo(connectionManager, serverConfig);
        Map<String, List<MetaInfo.ColumnInfo>> tnToCi = mi.getColumnInfo().stream().collect(Collectors.groupingBy(ci -> ci.getFullTableName()));
        for (Map.Entry<String, List<MetaInfo.ColumnInfo>> e : tnToCi.entrySet()) {
            String serverName = serverConfig.getName();
            boolean isView = false;
            String[] colNames = e.getValue().stream().map(ci -> ci.getColumnName()).collect(Collectors.toList()).toArray(new String[0]);
            short typNum = (short)CAtomTypes.TABLE.getTypeNum();
            String ns2 = e.getValue().get(0).getNamespace();
            ns2 = ns2.isEmpty() ? DEFAULT_NAMESPACE : ns2;
            String shortTblName = e.getValue().get(0).getTableName();
            ServerQEntity sqe2 = ServerQEntityFactory.get(serverName, ns2, shortTblName, typNum, 0L, true, false, isView, colNames, serverConfig.getJdbcType());
            allElements.add(sqe2);
        }
        HashMap<String, NamespaceListing> r = new HashMap<String, NamespaceListing>();
        allElements.stream().collect(Collectors.groupingBy(sqe -> sqe.getNamespace())).forEach((ns, sqel) -> r.put((String)ns, new NamespaceListing((List<ServerQEntity>)sqel)));
        return r;
    }

    private static Map<String, NamespaceListing> getNSListingForDolphin(ServerConfig serverConfig, ConnectionManager connectionManager) throws IOException, SQLException {
        if (!serverConfig.getJdbcType().equals((Object)JdbcTypes.DOLPHINDB)) {
            throw new IOException("Wrong server type");
        }
        ArrayList<ServerQEntity> allElements = new ArrayList<ServerQEntity>();
        String serverName = serverConfig.getName();
        try {
            CachedRowSet namespaceRS = connectionManager.executeQuery(serverConfig, "getDFSDatabases()");
            short tableTypNum = (short)CAtomTypes.TABLE.getTypeNum();
            while (namespaceRS.next()) {
                String path = namespaceRS.getString(1);
                CachedRowSet tablesRS = connectionManager.executeQuery(serverConfig, "listTables('" + path + "')");
                while (tablesRS.next()) {
                    String tblName = tablesRS.getString("tableName");
                    String tblLoad = "loadTable('" + path + "', '" + tblName + "')";
                    String[] colNames = ServerObjectTree.getDolphinColNames(connectionManager, serverConfig, tblLoad, new String[]{"unknown"});
                    ServerQEntity sqe2 = ServerQEntityFactory.get(serverName, path, tblName, tableTypNum, 0L, true, false, false, colNames, serverConfig.getJdbcType());
                    allElements.add(sqe2);
                }
            }
        }
        catch (Exception e) {
            LOG.warning("Error getting getDFSDatabases " + e);
        }
        CachedRowSet vRS = connectionManager.executeQuery(serverConfig, "objs(true)");
        while (vRS.next()) {
            String name = vRS.getString("name");
            String form = vRS.getString("form");
            short typeNum = ServerObjectTree.toTypeNum(vRS.getString("type"), form);
            boolean isTbl = form.equals("TABLE");
            String[] colNames = new String[]{"unknown"};
            try {
                if (isTbl) {
                    colNames = ServerObjectTree.getDolphinColNames(connectionManager, serverConfig, name, colNames);
                }
                ServerQEntity sqe3 = ServerQEntityFactory.get(serverName, DEFAULT_NAMESPACE, name, typeNum, vRS.getLong("rows"), isTbl, false, false, colNames, serverConfig.getJdbcType());
                allElements.add(sqe3);
            }
            catch (IllegalArgumentException iae) {
                LOG.warning("Error parsing " + name + " in tree:" + iae);
            }
        }
        try {
            CachedRowSet functionRS = connectionManager.executeQuery(serverConfig, "SELECT * FROM defs() WHERE userDefined=1b");
            while (functionRS.next()) {
                String name = functionRS.getString("name");
                String[] colNames = new String[]{"unknown"};
                short typeNum = (short)CAtomTypes.LAMBDA.getTypeNum();
                ServerQEntity sqe4 = ServerQEntityFactory.get(serverName, DEFAULT_NAMESPACE, name, typeNum, 0L, false, false, false, colNames, serverConfig.getJdbcType());
                allElements.add(sqe4);
            }
        }
        catch (Exception e) {
            LOG.warning("Error getting getDFSDatabases " + e);
        }
        HashMap<String, NamespaceListing> r = new HashMap<String, NamespaceListing>();
        allElements.stream().collect(Collectors.groupingBy(sqe -> sqe.getNamespace())).forEach((ns, sqel) -> r.put((String)ns, new NamespaceListing((List<ServerQEntity>)sqel)));
        return r;
    }

    private static String[] getDolphinColNames(ConnectionManager connectionManager, ServerConfig serverConfig, String name, String[] fallbackIfError) {
        try {
            ArrayList<String> l = new ArrayList<String>();
            CachedRowSet schemaRS = connectionManager.executeQuery(serverConfig, "select name from schema(" + name + ")['colDefs']");
            while (schemaRS.next()) {
                l.add(schemaRS.getString("name"));
            }
            return l.toArray(new String[0]);
        }
        catch (Exception e) {
            LOG.warning("Problem fetching columns for " + name + " : " + e);
            return fallbackIfError;
        }
    }

    private static Short toTypeNum(String typeString, String form) {
        if (form.equals("TABLE")) {
            return (short)CAtomTypes.TABLE.getTypeNum();
        }
        short mul = (short)(form.equals("SCALAR") ? -1 : (form.equals("VECTOR") ? 1 : 1));
        switch (typeString) {
            case "BOOL": {
                return (short)(CAtomTypes.BOOLEAN.getTypeNum() * mul);
            }
            case "STRING": {
                return (short)(CAtomTypes.SYMBOL.getTypeNum() * mul);
            }
            case "DOUBLE": {
                return (short)(CAtomTypes.FLOAT.getTypeNum() * mul);
            }
            case "INT": {
                return (short)(CAtomTypes.INT.getTypeNum() * mul);
            }
            case "DATE": {
                return (short)(CAtomTypes.DATE.getTypeNum() * mul);
            }
            case "MONTH": {
                return (short)(CAtomTypes.MONTH.getTypeNum() * mul);
            }
            case "MINUTE": {
                return (short)(CAtomTypes.MINUTE.getTypeNum() * mul);
            }
            case "SECOND": {
                return (short)(CAtomTypes.SECOND.getTypeNum() * mul);
            }
            case "DATETIME": {
                return (short)(CAtomTypes.DATETIME.getTypeNum() * mul);
            }
            case "TIMESTAMP": 
            case "NANOTIME": 
            case "NANOTIMESTAMP": {
                return (short)(CAtomTypes.TIMESTAMP.getTypeNum() * mul);
            }
            case "TIME": {
                return (short)(CAtomTypes.TIME.getTypeNum() * mul);
            }
        }
        return (short)CAtomTypes.MIXED_LIST.getTypeNum();
    }

    private static Map<String, NamespaceListing> getNSListing(ServerConfig serverConfig, ConnectionManager connectionManager) throws IOException, c.KException, UnsupportedDataTypeException {
        if (GET_TREE_QUERY == null) {
            return Collections.emptyMap();
        }
        KdbConnection kdbConn = connectionManager.getKdbConnection(serverConfig);
        if (kdbConn == null) {
            throw new IOException("Could not connect to kdb server");
        }
        Object o = kdbConn.query(GET_TREE_QUERY);
        String errMsg = "";
        if (!(o instanceof c.Dict)) {
            errMsg = "Never received proper format reply from server.";
            throw new UnsupportedDataTypeException(errMsg);
        }
        c.Dict tree = (c.Dict)o;
        String[] namespaces = (String[])tree.x;
        Object[] nsList = (Object[])tree.y;
        HashMap<String, NamespaceListing> ns2e = new HashMap<String, NamespaceListing>(namespaces.length);
        ArrayList<String> problemNSs = new ArrayList<String>();
        for (int i = 0; i < nsList.length; ++i) {
            String ns = namespaces[i];
            if (nsList[i] instanceof c.Dict) {
                c.Dict nsTree = (c.Dict)nsList[i];
                List<ServerQEntity> allElements = ServerObjectTree.toElementListing(serverConfig, ns, nsTree);
                ns2e.put(ns, new NamespaceListing(allElements));
                continue;
            }
            problemNSs.add(ns);
        }
        if (!problemNSs.isEmpty()) {
            String msg = "Could not refresh the server tree namespaces:" + Joiner.on(',').join(problemNSs);
            LOG.log(Level.SEVERE, msg);
            QStudioLauncher.ERR_REPORTER.showReportErrorDialog(msg);
        }
        try {
            kdbConn.close();
        }
        catch (IOException ioe) {
            LOG.log(Level.SEVERE, "Error closing kdbConn for server tree");
        }
        return ns2e;
    }

    public Set<String> getNamespaces() {
        return this.refreshResult.namespaceListingMap.keySet();
    }

    private static List<ServerQEntity> toElementListing(ServerConfig sc, String namespace, c.Dict tree) {
        String[] elementNames = (String[])tree.x;
        Object[] detailsArray = (Object[])tree.y;
        if (elementNames.length > 0) {
            ArrayList<ServerQEntity> r = new ArrayList<ServerQEntity>(elementNames.length);
            for (int i = 0; i < elementNames.length; ++i) {
                String msg;
                try {
                    Object[] d = (Object[])detailsArray[i];
                    Short type = d[0] instanceof Short ? (Short)d[0] : (short)0;
                    boolean isTable = d[2] instanceof Boolean ? (Boolean)d[2] : false;
                    boolean partitioned = d[3] instanceof Boolean ? (Boolean)d[3] : false;
                    String[] colNames = d[4] instanceof String[] ? (String[])d[4] : null;
                    boolean isView = d[5] instanceof Boolean ? (Boolean)d[5] : false;
                    long count = d[1] instanceof Number ? ((Number)d[1]).longValue() : -1L;
                    ServerQEntity sqe = ServerQEntityFactory.get(sc.getName(), namespace, elementNames[i], type, count, isTable, partitioned, isView, colNames, sc.getJdbcType());
                    if (sqe == null) {
                        LOG.warning("unrecognised ServerQEntity: " + namespace + DEFAULT_NAMESPACE + elementNames[i]);
                        continue;
                    }
                    r.add(sqe);
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    msg = "unrecognised ServerQEntity: " + namespace + DEFAULT_NAMESPACE + elementNames[i];
                    LOG.log(Level.WARNING, msg, iae);
                    continue;
                }
                catch (ClassCastException cce) {
                    msg = "unrecognised ServerQEntity: " + namespace + DEFAULT_NAMESPACE + elementNames[i];
                    LOG.log(Level.WARNING, msg, cce);
                }
            }
            return r;
        }
        return Collections.emptyList();
    }

    public List<ServerQEntity> getAll() {
        ArrayList<ServerQEntity> entities = Lists.newArrayList();
        for (Map.Entry e : this.refreshResult.namespaceListingMap.entrySet()) {
            NamespaceListing nsl = (NamespaceListing)e.getValue();
            entities.addAll(nsl.getAllElements());
            if (nsl.getAllElements().size() <= 0) continue;
            ServerQEntity firstItem = nsl.getAllElements().get(0);
            entities.add(ServerQEntityFactory.getDict(firstItem.getSource(), firstItem.getNamespace(), "", 1));
        }
        return entities;
    }

    public List<? extends DocumentedEntity> getAllDocumentationEntities(Predicate<DocumentedEntity> filter) {
        ArrayList<DocumentedEntity> docs = new ArrayList<DocumentedEntity>();
        List<ServerQEntity> entities = filter == null ? this.getAll() : Iterables.filter(this.getAll(), filter);
        entities.forEach(docs::add);
        for (ServerQEntity se : entities) {
            for (ServerQEntity.QQuery qq : se.getQQueries()) {
                docs.add(qq.toDocumentedEntity());
            }
        }
        return docs;
    }

    List<ServerQEntity> getAll(String namespace) {
        NamespaceListing nsl = (NamespaceListing)this.refreshResult.namespaceListingMap.get(namespace);
        return nsl == null ? EMPTY_LIST : nsl.getAllElements();
    }

    public List<ServerQEntity> getAll(Collection<String> namespaces) {
        ArrayList<ServerQEntity> r = new ArrayList<ServerQEntity>();
        for (String ns : namespaces) {
            NamespaceListing nsl = (NamespaceListing)this.refreshResult.namespaceListingMap.get(ns);
            if (nsl == null) continue;
            r.addAll(nsl.getAllElements());
        }
        return r;
    }

    public List<TableSQE> getTables(String namespace) {
        NamespaceListing nsl = (NamespaceListing)this.refreshResult.namespaceListingMap.get(namespace);
        List r = Collections.emptyList();
        return nsl == null ? r : nsl.getTables();
    }

    public List<ServerQEntity> getViews(String namespace) {
        NamespaceListing nsl = (NamespaceListing)this.refreshResult.namespaceListingMap.get(namespace);
        return nsl == null ? EMPTY_LIST : nsl.getViews();
    }

    public List<ServerQEntity> getVariables(String namespace) {
        NamespaceListing nsl = (NamespaceListing)this.refreshResult.namespaceListingMap.get(namespace);
        return nsl == null ? EMPTY_LIST : nsl.getVariables();
    }

    public List<ServerQEntity> getFunctions(String ... namespaces) {
        return this.getFunctions(Arrays.asList(namespaces));
    }

    public List<ServerQEntity> getFunctions(Collection<String> namespaces) {
        ArrayList<ServerQEntity> r = new ArrayList<ServerQEntity>();
        for (String ns : namespaces) {
            NamespaceListing nsl = (NamespaceListing)this.refreshResult.namespaceListingMap.get(ns);
            if (nsl == null) continue;
            r.addAll(nsl.getFunctions());
        }
        return r;
    }

    List<TableSQE> getTables() {
        return this.getTables(DEFAULT_NAMESPACE);
    }

    List<ServerQEntity> getViews() {
        return this.getViews(DEFAULT_NAMESPACE);
    }

    List<ServerQEntity> getVariables() {
        return this.getVariables(DEFAULT_NAMESPACE);
    }

    List<ServerQEntity> getFunctions() {
        return this.getFunctions(DEFAULT_NAMESPACE);
    }

    public String getErrMsg() {
        return this.refreshResult.errMsg;
    }

    public boolean isErrorRetrievingTree() {
        return this.errorRetrievingTree;
    }

    boolean namespaceExists(String namespace) {
        return this.refreshResult.namespaceListingMap.get(namespace) != null;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("namespaceListingMap", this.refreshResult.namespaceListingMap).toString();
    }

    public boolean elementExists(String namespace, QEntity element) {
        NamespaceListing nsListing = (NamespaceListing)this.refreshResult.namespaceListingMap.get(namespace);
        if (nsListing != null) {
            return nsListing.contains(element);
        }
        return false;
    }

    public static void setGET_TREE_QUERY(String GET_TREE_QUERY) {
        ServerObjectTree.GET_TREE_QUERY = GET_TREE_QUERY;
    }

    private static class RefreshResult {
        private final Map<String, NamespaceListing> namespaceListingMap;
        private final String errMsg;

        public RefreshResult() {
            this(new HashMap<String, NamespaceListing>(), "");
        }

        public Map<String, NamespaceListing> getNamespaceListingMap() {
            return this.namespaceListingMap;
        }

        public String getErrMsg() {
            return this.errMsg;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RefreshResult)) {
                return false;
            }
            RefreshResult other = (RefreshResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, NamespaceListing> this$namespaceListingMap = this.getNamespaceListingMap();
            Map<String, NamespaceListing> other$namespaceListingMap = other.getNamespaceListingMap();
            if (this$namespaceListingMap == null ? other$namespaceListingMap != null : !((Object)this$namespaceListingMap).equals(other$namespaceListingMap)) {
                return false;
            }
            String this$errMsg = this.getErrMsg();
            String other$errMsg = other.getErrMsg();
            return !(this$errMsg == null ? other$errMsg != null : !this$errMsg.equals(other$errMsg));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RefreshResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, NamespaceListing> $namespaceListingMap = this.getNamespaceListingMap();
            result = result * 59 + ($namespaceListingMap == null ? 43 : ((Object)$namespaceListingMap).hashCode());
            String $errMsg = this.getErrMsg();
            result = result * 59 + ($errMsg == null ? 43 : $errMsg.hashCode());
            return result;
        }

        public String toString() {
            return "ServerObjectTree.RefreshResult(namespaceListingMap=" + this.getNamespaceListingMap() + ", errMsg=" + this.getErrMsg() + ")";
        }

        public RefreshResult(Map<String, NamespaceListing> namespaceListingMap, String errMsg) {
            this.namespaceListingMap = namespaceListingMap;
            this.errMsg = errMsg;
        }
    }
}

