/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio.model;

import com.google.common.base.MoreObjects;
import com.timestored.connections.ConnectionManager;
import com.timestored.connections.ServerConfig;
import com.timestored.kdb.KdbConnection;
import com.timestored.qstudio.model.ServerObjectTree;
import com.timestored.qstudio.model.ServerReport;
import com.timestored.qstudio.model.ServerSlashConfig;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerModel {
    private static final Logger LOG = Logger.getLogger(ServerModel.class.getName());
    private final ServerConfig serverConfig;
    private ServerObjectTree serverObjectTree;
    private ServerReport serverReport;
    private ServerSlashConfig serverSlashConfig;
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private final ConnectionManager connectionManager;

    public ServerModel(ConnectionManager connectionManager, ServerConfig serverConfig) {
        this.connectionManager = connectionManager;
        this.serverConfig = serverConfig;
    }

    void refresh() {
        this.serverObjectTree = new ServerObjectTree(this.connectionManager, this.serverConfig);
        KdbConnection kdbConnection = this.connectionManager.getKdbConnection(this.serverConfig);
        if (kdbConnection != null) {
            try {
                try {
                    this.serverReport = new ServerReport(kdbConnection);
                    this.serverSlashConfig = new ServerSlashConfig(kdbConnection);
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Error retrieving Server Properties.", e);
                }
            }
            finally {
                try {
                    kdbConnection.close();
                }
                catch (IOException e) {
                    LOG.log(Level.WARNING, "problem closing kdb connection", e);
                }
            }
            for (Listener l : this.listeners) {
                l.changeOccurred();
            }
        }
    }

    public KdbConnection getConnection() {
        return this.connectionManager.getKdbConnection(this.serverConfig);
    }

    public ServerObjectTree getServerObjectTree() {
        return this.serverObjectTree;
    }

    public ServerReport getServerReport() {
        return this.serverReport;
    }

    public ServerSlashConfig getSlashConfig() {
        return this.serverSlashConfig;
    }

    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public boolean isConnected() {
        return this.connectionManager.isConnected(this.serverConfig);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public String getName() {
        return this.serverConfig.getName();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("serverConfig", this.serverConfig).toString();
    }

    public static interface Listener {
        public void changeOccurred();
    }
}

