/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.timestored.babeldb.DBHelper;
import com.timestored.connections.ServerConfig;
import com.timestored.kdb.QueryResultI;
import com.timestored.qstudio.PivotFormConfig;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.RowSet;
import kx.c;

public class QueryResult
implements QueryResultI {
    private final PivotFormConfig pivotConfig;
    private final ServerConfig serverConfig;
    public final String query;
    public final Object k;
    public final ResultSet rs;
    public RowSet rowSet = null;
    public final Exception e;
    private final String consoleView;
    private final Type type;

    public static QueryResult exceptionResult(ServerConfig serverConfig, String query, PivotFormConfig pivotConfig, Exception e) {
        String cView = e != null ? e.getMessage() : "exception";
        return new QueryResult(serverConfig, query, pivotConfig, null, null, cView, e, false);
    }

    public static QueryResult cancelledResult(ServerConfig serverConfig, String query, PivotFormConfig pivotConfig) {
        String cView = "Query Cancelled";
        return new QueryResult(serverConfig, query, pivotConfig, null, null, cView, null, true);
    }

    public static QueryResult successfulResult(ServerConfig serverConfig, String query, PivotFormConfig pivotConfig, Object k, ResultSet rs2, String consoleView) {
        return new QueryResult(serverConfig, query, pivotConfig, k, rs2, consoleView, null, false);
    }

    @Override
    public boolean isCancelled() {
        return this.type.equals((Object)Type.Cancel);
    }

    public boolean isException() {
        return this.type.equals((Object)Type.Exception);
    }

    private QueryResult(ServerConfig serverConfig, String query, PivotFormConfig pivotConfig, Object k, ResultSet rs2, String consoleView, Exception e, boolean cancelled) {
        this.type = cancelled ? Type.Cancel : (e != null ? Type.Exception : Type.Success);
        this.serverConfig = Preconditions.checkNotNull(serverConfig);
        this.query = Preconditions.checkNotNull(query);
        this.pivotConfig = pivotConfig;
        this.k = k;
        this.rs = rs2;
        this.e = e;
        this.consoleView = e instanceof c.KException ? "'" + e.getMessage() : consoleView;
    }

    Type getType() {
        return this.type;
    }

    public String getResultType() {
        return this.type.toString();
    }

    public boolean isKResultTooLarge() {
        return this.k == null && this.consoleView != null && this.consoleView.length() > 0;
    }

    @Override
    public String getConsoleView() {
        if (this.isCancelled()) {
            return "'stop - query cancelled";
        }
        if (this.k == null && this.consoleView == null || this.consoleView.isEmpty()) {
            return "::";
        }
        return this.consoleView;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("query", this.query).add("wasResult", this.k != null).add("wasException", this.e != null).toString();
    }

    @Override
    public void close() throws Exception {
        if (this.rowSet != null) {
            this.rowSet.close();
            this.rowSet = null;
        }
    }

    @Override
    public RowSet getRs() {
        try {
            if (this.rowSet == null) {
                this.rowSet = DBHelper.toCRS(this.rs);
            }
            return this.rowSet;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean isExceededMax() {
        return false;
    }

    public PivotFormConfig getPivotConfig() {
        return this.pivotConfig;
    }

    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }

    @Override
    public Object getK() {
        return this.k;
    }

    @Override
    public Exception getE() {
        return this.e;
    }

    static enum Type {
        Exception,
        Cancel,
        Success;

    }
}

