/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio.model;

import com.google.common.base.Preconditions;
import com.timestored.babeldb.PivotProvider;
import com.timestored.command.Command;
import com.timestored.command.CommandProvider;
import com.timestored.connections.ConnectionManager;
import com.timestored.connections.JdbcTypes;
import com.timestored.connections.ServerConfig;
import com.timestored.kdb.KdbConnection;
import com.timestored.qstudio.BackgroundExecutor;
import com.timestored.qstudio.PivotFormConfig;
import com.timestored.qstudio.kdb.KdbHelper;
import com.timestored.qstudio.model.QueryListener;
import com.timestored.qstudio.model.QueryResult;
import com.timestored.theme.Theme;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import kx.c;
import kx.jdbc;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class QueryManager
implements CommandProvider,
AutoCloseable {
    private static final Logger LOG = Logger.getLogger(QueryManager.class.getName());
    private final List<QueryListener> listeners = new CopyOnWriteArrayList<QueryListener>();
    private List<String> serverNames = Collections.emptyList();
    private final ConnectionManager connectionManager;
    private String previousQuery = "";
    private String previousQueryTitle = null;
    private PivotFormConfig previousPivotConfig = null;
    private String selectedServerName;
    private boolean queryWrapped = true;
    private boolean connectionPersisted = false;
    private boolean querying = false;
    private volatile boolean cancelQuery = false;
    private int commercialDBqueries = 0;
    private String queryWrapPrefix = "";
    private String queryWrapPostfix = "";
    private long maxReturnedObjectSize;
    private KdbConnection conn;

    public QueryManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        connectionManager.addListener(new ConnectionManager.Listener(){

            @Override
            public void serverAdded(ServerConfig sc) {
            }

            @Override
            public void prefChange() {
                QueryManager.this.refreshServerList();
                KdbConnection c2 = QueryManager.this.conn;
                if (c2 != null) {
                    try {
                        c2.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }

            @Override
            public void statusChange(ServerConfig serverConfig, boolean connected) {
            }
        });
        this.refreshServerList();
    }

    public void addQueryListener(QueryListener queryListener) {
        this.listeners.add(Preconditions.checkNotNull(queryListener));
    }

    public void removeQueryListener(QueryListener queryListener) {
        this.listeners.remove(Preconditions.checkNotNull(queryListener));
    }

    public void resendLastQuery() {
        this.sendQuery(this.previousPivotConfig, this.previousQuery, this.previousQueryTitle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelQuery() {
        QueryManager queryManager = this;
        synchronized (queryManager) {
            block9: {
                if (this.querying) {
                    try {
                        KdbConnection c2 = this.conn;
                        if (c2 == null) break block9;
                        LOG.warning("Cancelling query");
                        this.cancelQuery = true;
                        try {
                            c2.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        LOG.warning("conn closed");
                    }
                    finally {
                        this.querying = false;
                    }
                }
            }
        }
    }

    public void sendQuery(String query) {
        this.sendQuery(query, null);
    }

    public void sendQuery(PivotFormConfig pivotConfig, String query, String queryTitle) {
        this.sendQuery(pivotConfig, query, this.selectedServerName, queryTitle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendQuery(final String query, final String queryTitle) {
        final String sName = this.selectedServerName;
        if (sName == null) {
            throw new IllegalStateException("Select server to send queries to.");
        }
        if (query != null && query.trim().length() > 0 && this.selectedServerName != null) {
            QueryManager queryManager = this;
            synchronized (queryManager) {
                if (this.querying) {
                    throw new IllegalStateException("Only one query at a time");
                }
                this.querying = true;
            }
            BackgroundExecutor.EXECUTOR.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        QueryManager.this.sendQuery(null, query, sName, queryTitle);
                    }
                    finally {
                        2 var1_1 = this;
                        synchronized (var1_1) {
                            QueryManager.this.querying = false;
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendQuery(PivotFormConfig pivotConfig, String query, String serverName, String queryTitle) {
        QueryManager queryManager = this;
        synchronized (queryManager) {
            this.cancelQuery = false;
        }
        QueryResult qr = null;
        String sqlSent = query;
        ServerConfig sc = this.connectionManager.getServer(serverName);
        JdbcTypes jtype = sc.getJdbcType();
        if (jtype.equals((Object)JdbcTypes.BABELDB) && sc.getUrl().startsWith("jdbc:babeldb:duckdb:")) {
            jtype = JdbcTypes.DUCKDB;
        }
        if (pivotConfig != null) {
            sqlSent = PivotProvider.pivotSQL(jtype, pivotConfig.getByColsSelected(), pivotConfig.getPivotColsSelected(), pivotConfig.getAggSel(), pivotConfig.getSqlQuery());
        }
        String title = queryTitle == null ? sqlSent : queryTitle;
        LOG.info("run() sendingQuery: " + query);
        for (QueryListener l : this.listeners) {
            l.sendingQuery(sc, title);
        }
        this.previousQuery = query;
        this.previousQueryTitle = queryTitle;
        this.previousPivotConfig = pivotConfig;
        if (this.conn == null || !this.conn.isConnected()) {
            try {
                if (!sc.isKDB()) {
                    ResultSet crs = this.connectionManager.executeQuery(sc, sqlSent);
                    if (pivotConfig != null) {
                        crs = PivotProvider.postProcess(jtype, crs, pivotConfig.getByColsSelected(), pivotConfig.getPivotColsSelected());
                    }
                    qr = QueryResult.successfulResult(sc, title, pivotConfig, null, crs, "");
                    this.sendQRtoListeners(sc, qr);
                    return;
                }
                this.conn = this.connectionManager.tryKdbConnection(serverName);
            }
            catch (Throwable e) {
                Exception ee = e instanceof Exception ? (Exception)e : new IOException(e);
                qr = QueryResult.exceptionResult(sc, title, pivotConfig, ee);
                this.sendQRtoListeners(sc, qr);
                return;
            }
        }
        Object o = null;
        try {
            String qry = this.queryWrapPrefix + sqlSent + this.queryWrapPostfix;
            if (this.queryWrapped) {
                String maxSizeString = this.maxReturnedObjectSize == 0L ? "0Wj" : this.maxReturnedObjectSize + "j";
                String callWrapper = "{v:$[`trp in key .Q; .Q.trp[{( (1b;`) ;value x)};x;{((0b;`);x;$[4<count y; .Q.sbt -4 _ y; \"\"])}]; ((1b;`);value x)]; a:" + maxSizeString + ">@[-22!;v;{0}]; (a;$[a;v;0b];.Q.s v 1)} \"";
                qry = callWrapper + KdbHelper.escape(qry) + "\"";
            }
            if (sc.isKDB()) {
                ++this.commercialDBqueries;
            }
            o = this.conn.query(qry);
            Object k = null;
            String consoleView = null;
            if (this.queryWrapped) {
                if (!(o instanceof Object[])) {
                    throw new c.KException("replyformat");
                }
                Object[] ret = (Object[])o;
                boolean sizeOK = (Boolean)ret[0];
                consoleView = new String((char[])ret[2]);
                if (sizeOK && ret[1] instanceof Object[]) {
                    Object[] resObject = (Object[])ret[1];
                    boolean runOk = (Boolean)((Object[])resObject[0])[0];
                    if (!runOk) {
                        String errorTitle = new String((char[])resObject[1]);
                        String stackMessage = "";
                        if (!(resObject[2] instanceof char[])) throw new c.KException(errorTitle, stackMessage);
                        stackMessage = new String((char[])resObject[2]);
                        String magicString = "{(1b;value x)}";
                        if (!stackMessage.contains(magicString)) throw new c.KException(errorTitle, stackMessage);
                        int p = stackMessage.indexOf(magicString);
                        if (p <= 0) throw new c.KException(errorTitle, stackMessage);
                        int q = stackMessage.substring(0, p).lastIndexOf("\n");
                        if (q <= 0) throw new c.KException(errorTitle, stackMessage);
                        stackMessage = stackMessage.substring(0, q);
                        throw new c.KException(errorTitle, stackMessage);
                    }
                    k = resObject[1];
                }
            } else {
                k = o;
                consoleView = k == null ? "" : KdbHelper.asLine(k);
            }
            jdbc.ExtendedResultSet rs2 = null;
            try {
                if (k != null) {
                    rs2 = jdbc.getRS(k, queryTitle);
                }
            }
            catch (Exception e) {
                LOG.log(Level.INFO, "No RS possible", e);
            }
            qr = QueryResult.successfulResult(sc, title, pivotConfig, k, rs2, consoleView);
        }
        catch (c.KException ex) {
            qr = QueryResult.exceptionResult(sc, title, pivotConfig, ex);
        }
        catch (Exception ex) {
            QueryManager queryManager2 = this;
            synchronized (queryManager2) {
                if (this.cancelQuery) {
                    qr = QueryResult.cancelledResult(sc, title, pivotConfig);
                } else {
                    LOG.log(Level.SEVERE, "Server sent some unwrapped unknown result", ex);
                    String s = o != null ? KdbHelper.asLine(o) : ex.getMessage();
                    qr = QueryResult.exceptionResult(sc, title, pivotConfig, new IOException(s));
                }
            }
        }
        this.sendQRtoListeners(sc, qr);
        try {
            if (this.connectionPersisted) return;
            this.conn.close();
            this.conn = null;
            return;
        }
        catch (IOException ioe) {
            if (this.cancelQuery) return;
            LOG.warning("error refrshing watches /  closing connection");
        }
    }

    @Override
    public void close() throws Exception {
        if (this.conn != null) {
            this.conn.close();
            this.conn = null;
        }
    }

    public void sendQRtoListeners(ServerConfig sc, QueryResult qr) {
        LOG.info("queryResultReturned: " + qr);
        for (QueryListener l : this.listeners) {
            try {
                l.queryResultReturned(sc, qr);
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "query listener: " + l + " exceptioned: ", ex);
            }
        }
    }

    public boolean isQueryWrapped() {
        return this.queryWrapped;
    }

    public void setQueryWrapped(boolean queryWrapped) {
        this.queryWrapped = queryWrapped;
    }

    public boolean isConnectionPersisted() {
        return this.connectionPersisted;
    }

    public boolean isQuerying() {
        return this.querying;
    }

    public void setConnectionPersisted(boolean connectionPersisted) {
        this.connectionPersisted = connectionPersisted;
    }

    public void setMaxReturnSize(long maxSize) {
        Preconditions.checkArgument(maxSize >= 0L);
        this.maxReturnedObjectSize = maxSize;
    }

    public synchronized void setSelectedServerName(String serverName) {
        boolean actualChange;
        boolean changeToNull = serverName == null && this.selectedServerName != null;
        boolean bl = actualChange = serverName != null && !serverName.equals(this.selectedServerName);
        if (changeToNull || actualChange) {
            this.conn = null;
            this.selectedServerName = null;
            if (actualChange) {
                ServerConfig sc = this.connectionManager.getServer(serverName);
                this.selectedServerName = sc == null ? null : serverName;
            }
            for (QueryListener l : this.listeners) {
                try {
                    l.selectedServerChanged(serverName);
                }
                catch (Exception e) {
                    LOG.severe("Error notifying listener:" + l);
                }
            }
        } else {
            LOG.fine("Ignoring setSelectedServerName: " + serverName + "as already set");
        }
    }

    public String getSelectedServerName() {
        return this.selectedServerName;
    }

    private void refreshServerList() {
        this.serverNames = this.connectionManager.getServerNames();
        for (QueryListener l : this.listeners) {
            l.serverListingChanged(this.serverNames);
        }
        if (!this.serverNames.contains(this.selectedServerName)) {
            if (this.serverNames.size() > 0) {
                String sname = this.serverNames.get(this.serverNames.size() - 1);
                for (String s : this.serverNames) {
                    if (!this.connectionManager.isConnected(s)) continue;
                    sname = s;
                    break;
                }
                this.setSelectedServerName(sname);
            } else {
                this.setSelectedServerName(null);
            }
        }
    }

    public List<String> getServerNames() {
        return this.serverNames;
    }

    public void setQueryWrapPrefix(String queryWrapPre) {
        this.queryWrapPrefix = queryWrapPre == null ? "" : queryWrapPre;
    }

    public void setQueryWrapPostfix(String queryWrapPost) {
        this.queryWrapPostfix = queryWrapPost == null ? "" : queryWrapPost;
    }

    @Override
    public Collection<Command> getCommands() {
        return this.getChangeServerCommands(false);
    }

    public List<Command> getChangeServerCommands(boolean serverNameOnly) {
        ArrayList<Command> commands = new ArrayList<Command>();
        for (ServerConfig sc : this.connectionManager.getServerConnections()) {
            commands.add(new ChangeServerCommand(sc, serverNameOnly));
        }
        return commands;
    }

    public int getCommercialDBqueries() {
        return this.commercialDBqueries;
    }

    public boolean hasAnyServers() {
        return !this.getServerNames().isEmpty();
    }

    private class ChangeServerCommand
    implements Command {
        private final ServerConfig sc;
        private final boolean serverNameOnly;

        public ChangeServerCommand(ServerConfig serverConfig, boolean serverNameOnly) {
            this.sc = serverConfig;
            this.serverNameOnly = serverNameOnly;
        }

        @Override
        public Icon getIcon() {
            return Theme.CIcon.SERVER.get();
        }

        @Override
        public KeyStroke getKeyStroke() {
            return null;
        }

        public String toString() {
            return this.getTitle();
        }

        @Override
        public void perform() {
            QueryManager.this.setSelectedServerName(this.sc.getName());
        }

        @Override
        public String getTitle() {
            if (this.serverNameOnly) {
                return this.sc.getName();
            }
            return "Connect To Server: " + this.sc.getName();
        }

        @Override
        public String getTitleAdditional() {
            String t = this.sc.getHost() + ":" + this.sc.getPort();
            if (!t.equals(this.sc.getName())) {
                return t;
            }
            return "";
        }

        @Override
        public String getDetailHtml() {
            return "<html>host: " + this.sc.getHost() + "<br/>post:" + this.sc.getPort() + "</html>";
        }
    }
}

