/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio.model;

import com.google.common.base.Preconditions;
import com.timestored.qstudio.kdb.CAtomTypes;
import com.timestored.qstudio.model.QEntity;
import com.timestored.qstudio.model.ServerQEntity;
import com.timestored.qstudio.model.TableSQE;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

class NamespaceListing {
    private final List<TableSQE> tables;
    private final List<ServerQEntity> functions;
    private final List<ServerQEntity> variables;
    private final List<ServerQEntity> views;
    private final List<ServerQEntity> allElements;

    NamespaceListing(List<ServerQEntity> allElements) {
        this.allElements = new ArrayList<ServerQEntity>((Collection)Preconditions.checkNotNull(allElements));
        ArrayList<TableSQE> tables = new ArrayList<TableSQE>();
        ArrayList<ServerQEntity> functions = new ArrayList<ServerQEntity>();
        ArrayList<ServerQEntity> variables = new ArrayList<ServerQEntity>();
        ArrayList<ServerQEntity> views = new ArrayList<ServerQEntity>();
        for (ServerQEntity ed : allElements) {
            if (ed.isTable() && ed instanceof TableSQE) {
                tables.add((TableSQE)ed);
                continue;
            }
            if (ed.getType().equals((Object)CAtomTypes.VIEW)) {
                views.add(ed);
                continue;
            }
            if (ed.getType().isFunction()) {
                functions.add(ed);
                continue;
            }
            variables.add(ed);
        }
        this.tables = Collections.unmodifiableList(tables);
        this.functions = Collections.unmodifiableList(functions);
        this.variables = Collections.unmodifiableList(variables);
        this.views = Collections.unmodifiableList(views);
    }

    public String toString() {
        return "tables = " + this.tables.toString() + "views = " + this.views.toString() + "functions = " + this.functions.toString() + "variables = " + this.variables.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.allElements == null ? 0 : this.allElements.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NamespaceListing other = (NamespaceListing)obj;
        return !(this.allElements == null ? other.allElements != null : !this.allElements.equals(other.allElements));
    }

    public List<ServerQEntity> getAllElements() {
        return this.allElements;
    }

    public List<TableSQE> getTables() {
        return this.tables;
    }

    public List<ServerQEntity> getFunctions() {
        return this.functions;
    }

    public List<ServerQEntity> getVariables() {
        return this.variables;
    }

    public List<ServerQEntity> getViews() {
        return this.views;
    }

    public boolean contains(QEntity element) {
        return this.allElements.contains(element);
    }
}

