/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio.model;

import com.google.common.base.Preconditions;
import com.timestored.connections.JdbcTypes;
import com.timestored.qstudio.model.AdminModel;
import com.timestored.qstudio.model.QueryManager;
import com.timestored.qstudio.model.ServerModel;
import com.timestored.qstudio.model.TableSQE;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPopupMenu;

public class DatabaseDirector {
    private static Map<JdbcTypes, ActionsGeneratorSupplier> dbtypeToSuppliers = new HashMap<JdbcTypes, ActionsGeneratorSupplier>();
    private static final ActionsGenerator EMPTY = new EmptyActionsGenerator();

    public static void registerActionsGenerator(JdbcTypes jdbcType, ActionsGeneratorSupplier actionsGeneratorSupplier) {
        Preconditions.checkNotNull(jdbcType);
        dbtypeToSuppliers.put(jdbcType, actionsGeneratorSupplier);
    }

    public static ActionsGenerator getActionsGenerator(QueryManager queryManager, AdminModel adminModel, ServerModel sm) {
        ActionsGeneratorSupplier supp = dbtypeToSuppliers.get((Object)sm.getServerConfig().getJdbcType());
        if (supp != null) {
            return supp.getActionsGenerator(queryManager, adminModel, sm);
        }
        return EMPTY;
    }

    private static class EmptyActionsGenerator
    implements ActionsGenerator {
        private EmptyActionsGenerator() {
        }

        @Override
        public void addColumnMenuItems(JPopupMenu menu, TableSQE table, String column, boolean partitionColumn) {
        }
    }

    public static interface ActionsGenerator {
        public void addColumnMenuItems(JPopupMenu var1, TableSQE var2, String var3, boolean var4);
    }

    public static interface ActionsGeneratorSupplier {
        public ActionsGenerator getActionsGenerator(QueryManager var1, AdminModel var2, ServerModel var3);
    }
}

