/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.timestored.connections.JdbcTypes;
import com.timestored.misc.HtmlUtils;
import com.timestored.qdoc.DocumentedEntity;
import com.timestored.qstudio.kdb.CAtomTypes;
import com.timestored.qstudio.model.ServerQEntity;
import com.timestored.theme.Theme;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;

abstract class BaseSQE
implements ServerQEntity {
    private final String namespace;
    private final String name;
    private final CAtomTypes type;
    private final String serverName;
    protected final JdbcTypes jdbcTypes;

    protected BaseSQE(String serverName, String namespace, String name, CAtomTypes type, JdbcTypes jdbcTypes) {
        this.namespace = Preconditions.checkNotNull(namespace);
        this.name = Preconditions.checkNotNull(name);
        this.type = type;
        this.serverName = serverName;
        this.jdbcTypes = jdbcTypes;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public CAtomTypes getType() {
        return this.type;
    }

    @Override
    public String getFullName() {
        return this.jdbcTypes != null && this.jdbcTypes.equals((Object)JdbcTypes.DOLPHINDB) ? (this.namespace.equals(".") ? this.name : "loadTable('" + this.namespace + "', '" + this.name + "')") : (this.namespace.equals(".") ? "" : this.namespace + ".") + this.name;
    }

    @Override
    public String getDocName() {
        return this.getFullName();
    }

    @Override
    public String getHtmlDoc(boolean shortFormat) {
        if (shortFormat) {
            return "<html><body>Type: " + this.getType().toString().toLowerCase() + " Count: " + this.getCount() + "</body></html>";
        }
        return BaseSQE.toHtml(ImmutableMap.of("Name: ", this.getDocName(), "Type: ", this.getType().toString().toLowerCase(), "Count: ", this.getCount() == -1L ? "unknown" : "" + this.getCount()));
    }

    static String toHtml(Map<String, String> namesToDescs) {
        return "<html><body>" + HtmlUtils.toTable(namesToDescs, true) + "</body></html>";
    }

    @Override
    public ImageIcon getIcon() {
        return this.type.getIcon().get16();
    }

    @Override
    public List<ServerQEntity.QQuery> getQQueries() {
        if (this.jdbcTypes != null && !this.jdbcTypes.equals((Object)JdbcTypes.KDB)) {
            return Collections.emptyList();
        }
        ArrayList<ServerQEntity.QQuery> r = Lists.newArrayList();
        r.add(new ServerQEntity.QQuery("Delete", Theme.CIcon.DELETE, "delete " + this.getName() + " from `" + this.getNamespace()));
        return r;
    }

    public String toString() {
        long c2 = this.getCount();
        return "Element[" + this.getName() + " type=" + (Object)((Object)this.type) + (c2 != 1L ? " count=" + c2 : "") + (this.isTable() ? " isTable" : " ") + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ServerQEntity) {
            ServerQEntity that = (ServerQEntity)obj;
            return Objects.equal(this.name, that.getName()) && Objects.equal(this.namespace, that.getNamespace()) && Objects.equal((Object)this.type, (Object)that.getType()) && Objects.equal(this.getCount(), that.getCount()) && Objects.equal(this.getDocName(), that.getDocName()) && Objects.equal(this.isTable(), that.isTable()) && Objects.equal(this.getFullName(), that.getFullName()) && Objects.equal(this.getQQueries(), that.getQQueries());
        }
        return false;
    }

    @Override
    public DocumentedEntity.SourceType getSourceType() {
        return DocumentedEntity.SourceType.SERVER;
    }

    @Override
    public String getSource() {
        return this.serverName;
    }
}

