/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.timestored.connections.ConnectionManager;
import com.timestored.connections.ServerConfig;
import com.timestored.kdb.KdbConnection;
import com.timestored.qdoc.DocSource;
import com.timestored.qdoc.DocumentedEntity;
import com.timestored.qstudio.BackgroundExecutor;
import com.timestored.qstudio.model.QEntity;
import com.timestored.qstudio.model.QueryAdapter;
import com.timestored.qstudio.model.QueryManager;
import com.timestored.qstudio.model.ServerModel;
import com.timestored.qstudio.model.ServerObjectTree;
import com.timestored.qstudio.model.ServerQEntity;
import com.timestored.qstudio.model.TableSQE;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;

public class AdminModel
implements ConnectionManager.Listener,
DocSource {
    private static final Logger LOG = Logger.getLogger(AdminModel.class.getName());
    private final ConnectionManager connectionManager;
    private final QueryManager queryManager;
    private final CopyOnWriteArrayList<Listener> listeners;
    private Map<String, ServerModel> serverContainer = new HashMap<String, ServerModel>();
    private List<ServerModel> serverModels = new CopyOnWriteArrayList<ServerModel>();
    private String selectedNamespace;
    private Category selectedCategory = Category.UNSELECTED;
    private ServerQEntity selectedElement;
    private String selectedServerName;
    protected boolean refreshing;

    public AdminModel(final ConnectionManager connectionManager, final QueryManager queryManager) {
        this.connectionManager = connectionManager;
        this.queryManager = queryManager;
        connectionManager.addListener(this);
        queryManager.addQueryListener(new QueryAdapter(){

            @Override
            public void selectedServerChanged(String server) {
                String aname;
                String qname = queryManager.getSelectedServerName();
                if (qname != (aname = AdminModel.this.getSelectedServerName())) {
                    AdminModel.this.setSelection(qname, null, Category.UNSELECTED, null);
                }
            }

            @Override
            public void serverListingChanged(List<String> serverNames) {
                serverNames.forEach(sn -> AdminModel.this.serverContainer.put(sn, new ServerModel(connectionManager, connectionManager.getServer((String)sn))));
                BackgroundExecutor.EXECUTOR.execute(new Runnable(){

                    @Override
                    public void run() {
                        AdminModel.this.refresh();
                    }
                });
            }
        });
        this.selectedServerName = queryManager.getSelectedServerName();
        this.listeners = new CopyOnWriteArrayList();
    }

    public List<ServerModel> getServerModels() {
        return Collections.unmodifiableList(this.serverModels);
    }

    public void setSelectedServerName(String serverName) {
        this.queryManager.setSelectedServerName(serverName);
    }

    public ServerObjectTree getServerTree(String serverName) {
        ServerModel sm;
        if (serverName != null && (sm = this.serverContainer.get(serverName)) != null) {
            return sm.getServerObjectTree();
        }
        return null;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public synchronized void refresh() {
        this.refresh(true);
    }

    public void refresh(final ServerConfig sconf) {
        if (!this.refreshing) {
            BackgroundExecutor.EXECUTOR.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    AdminModel adminModel = AdminModel.this;
                    synchronized (adminModel) {
                        AdminModel.this.refreshing = true;
                        LOG.info("refreshing " + sconf.getName());
                        ServerModel sm = null;
                        for (int i = 0; i < AdminModel.this.serverModels.size(); ++i) {
                            if (!sconf.equals(((ServerModel)AdminModel.this.serverModels.get(i)).getServerConfig())) continue;
                            sm = new ServerModel(AdminModel.this.connectionManager, sconf);
                            sm.refresh();
                            AdminModel.this.serverContainer.put(sconf.getName(), sm);
                            AdminModel.this.serverModels.set(i, sm);
                            for (Listener l : AdminModel.this.listeners) {
                                l.modelChanged(sm);
                            }
                            break;
                        }
                        AdminModel.this.refreshing = false;
                    }
                }
            });
        }
    }

    private synchronized void refresh(boolean hardRefresh) {
        ServerModel sm;
        LOG.info("AdminModel " + (hardRefresh ? "hard " : "") + "Refresh");
        this.connectionManager.refreshFromPreferences();
        ArrayList<ServerModel> modelsNeedingRefreshed = new ArrayList<ServerModel>();
        HashMap<String, ServerModel> sContainer = new HashMap<String, ServerModel>();
        CopyOnWriteArrayList<ServerModel> sTrees = new CopyOnWriteArrayList<ServerModel>();
        for (ServerConfig sconf : this.connectionManager.getServerConnections()) {
            ServerModel sm2 = null;
            ServerModel cacheSM = this.serverContainer.get(sconf.getName());
            sm2 = !hardRefresh && cacheSM != null && cacheSM.getServerConfig().equals(sconf) ? cacheSM : new ServerModel(this.connectionManager, sconf);
            sContainer.put(sconf.getName(), sm2);
            sTrees.add(sm2);
        }
        this.serverModels = sTrees;
        this.serverContainer = sContainer;
        String sn = this.queryManager.getSelectedServerName();
        if ((hardRefresh || sn != null && !sn.equals(this.selectedServerName)) && (sm = this.getServerModel(sn)) != null) {
            modelsNeedingRefreshed.add(sm);
        }
        this.selectedServerName = sn;
        for (Listener l : this.listeners) {
            l.modelChanged();
        }
        for (ServerModel sm2 : modelsNeedingRefreshed) {
            sm2.refresh();
        }
        for (Listener l : this.listeners) {
            l.modelChanged();
        }
    }

    private void setSelection(String servername, String namespace, Category category, ServerQEntity element) {
        TableSQE te;
        Object sc;
        ServerModel serverModel = null;
        if (servername != null) {
            serverModel = this.serverContainer.get(servername);
            if (serverModel == null) {
                throw new IllegalArgumentException("server:" + servername + " not found, try refresh");
            }
            ServerObjectTree sTree = serverModel.getServerObjectTree();
            if (namespace != null) {
                if (sTree == null) {
                    serverModel.refresh();
                    sTree = serverModel.getServerObjectTree();
                }
                if (!sTree.namespaceExists(namespace)) {
                    throw new IllegalArgumentException("server:" + servername + " namespace not found:" + namespace);
                }
                if (category != null && category.equals((Object)Category.ELEMENT) && !sTree.elementExists(namespace, element)) {
                    throw new IllegalArgumentException("server:" + servername + " element not found:" + namespace);
                }
            }
        }
        if (servername != null && !servername.equals(this.selectedServerName) && (sc = this.connectionManager.getServer(servername)) != null) {
            this.refresh((ServerConfig)sc);
        }
        this.selectedServerName = servername;
        this.selectedNamespace = namespace;
        this.selectedElement = element;
        this.selectedCategory = category;
        for (Listener l : this.listeners) {
            l.selectionChanged(serverModel, this.selectedCategory, this.selectedNamespace, this.selectedElement);
        }
        if (this.selectedElement instanceof TableSQE && (te = (TableSQE)this.selectedElement).getQQueries().size() > 0 && te.getCount() <= 1000L && te.getCount() > 0L) {
            this.queryManager.sendQuery(te.getQQueries().get(0).getQuery());
        }
        LOG.info("selectedServerNsCatElem " + this.selectedServerName + "-> " + this.selectedNamespace + "-> " + (Object)((Object)this.selectedCategory) + "-> " + this.selectedElement);
    }

    public void clearSelections() {
        this.selectedServerName = null;
        this.selectedNamespace = null;
        this.selectedCategory = Category.UNSELECTED;
        this.selectedElement = null;
        for (Listener l : this.listeners) {
            l.selectionChanged(null, this.selectedCategory, this.selectedNamespace, this.selectedElement);
        }
        LOG.info("clearSelections");
    }

    public void setSelectedCategory(String servername, String namespace, Category category) {
        this.setSelection(servername, namespace, category, null);
    }

    public KdbConnection getKdbConnection() {
        KdbConnection conn = null;
        if (this.selectedServerName != null) {
            conn = this.connectionManager.getKdbConnection(this.selectedServerName);
        }
        return conn;
    }

    public void setSelectedElement(String servername, String namespace, ServerQEntity elementName) {
        this.setSelection(servername, namespace, Category.ELEMENT, elementName);
    }

    public ServerQEntity getSelectedElement() {
        return this.selectedElement;
    }

    public Category getSelectedCategory() {
        return this.selectedCategory;
    }

    public String getSelectedNamespace() {
        return this.selectedNamespace;
    }

    public String getSelectedServerName() {
        return this.selectedServerName;
    }

    public Set<String> getFolders() {
        return this.connectionManager.getFolders();
    }

    public void setSelectedNamespace(String servername, String namespace) {
        this.setSelection(servername, namespace, Category.NAMESPACE, null);
    }

    public ServerModel getServerModel() {
        return this.serverContainer.get(this.selectedServerName);
    }

    public ServerModel getServerModel(String serverName) {
        return this.serverContainer.get(serverName);
    }

    @Override
    public void prefChange() {
        BackgroundExecutor.EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                AdminModel.this.refresh(false);
            }
        });
    }

    @Override
    public void serverAdded(ServerConfig sc) {
    }

    @Override
    public void statusChange(ServerConfig serverConfig, boolean connected) {
        this.refresh(serverConfig);
    }

    public List<ServerQEntity> getAllVariables() {
        ArrayList<ServerQEntity> vars = Lists.newArrayList();
        for (ServerModel sm : this.serverModels) {
            ServerObjectTree stree = sm.getServerObjectTree();
            if (stree == null) continue;
            vars.addAll(stree.getAll());
        }
        return vars;
    }

    @Override
    public List<? extends DocumentedEntity> getDocs() {
        return this.getAllVariables();
    }

    public void moveServer(ServerModel serverModel, String folderName) {
        Preconditions.checkNotNull(serverModel);
        String f = folderName == null ? "" : folderName;
        this.connectionManager.moveServer(serverModel.getServerConfig(), f);
    }

    public int removeFolder(String folder) {
        return this.connectionManager.removeFolder(Preconditions.checkNotNull(folder));
    }

    public int renameFolder(String from, String to) {
        return this.connectionManager.renameFolder(from, to);
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public static interface Listener {
        public void modelChanged();

        public void modelChanged(ServerModel var1);

        public void selectionChanged(ServerModel var1, Category var2, String var3, QEntity var4);
    }

    public static enum Category {
        TABLES,
        VIEWS,
        FUNCTIONS,
        VARIABLES,
        ELEMENT,
        NAMESPACE,
        UNSELECTED;

    }
}

