/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio.kdb;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.UUID;
import kx.c;

public enum KdbType {
    BOOLEAN(-1, Boolean.class, 'b'),
    GUID(-2, UUID.class, 'g', new UUID(0L, 0L)),
    BYTE(-4, Byte.class, 'x', new Byte(0)),
    SHORT(-5, Short.class, 'h', new Short(Short.MIN_VALUE), new Short(Short.MAX_VALUE), new Short(-32767)),
    INT(-6, Integer.class, 'i', c.NULL[6], new Integer(Integer.MAX_VALUE), new Integer(-2147483647)),
    LONG(-7, Long.class, 'j', c.NULL[7], new Long(Long.MAX_VALUE), new Long(-9223372036854775807L)),
    REAL(-8, Float.class, 'e', c.NULL[8], new Float(Float.POSITIVE_INFINITY), new Float(Float.NEGATIVE_INFINITY)),
    FLOAT(-9, Double.class, 'f', c.NULL[9], new Double(Double.POSITIVE_INFINITY), new Double(Double.NEGATIVE_INFINITY)),
    CHAR(-10, Character.class, 'c', new Character(' ')),
    SYMBOL(-11, String.class, 's', ""),
    TIMESTAMP(-12, Instant.class, 'p', c.NULL[12]),
    MONTH(-13, c.Month.class, 'm', c.NULL[13], new c.Month(Integer.MAX_VALUE), new c.Month(-2147483647)),
    DATE(-14, LocalDate.class, 'd', c.NULL[14]),
    DATETIME(-15, LocalDateTime.class, 'z', c.NULL[15]),
    TIMESPAN(-16, c.Timespan.class, 'n', c.NULL[16], new c.Timespan(Long.MAX_VALUE), new c.Timespan(-9223372036854775807L)),
    MINUTE(-17, c.Minute.class, 'u', c.NULL[17], new c.Minute(Integer.MAX_VALUE), new c.Minute(-2147483647)),
    SECOND(-18, c.Second.class, 'v', c.NULL[18], new c.Second(Integer.MAX_VALUE), new c.Second(-2147483647)),
    TIME(-19, LocalTime.class, 't', c.NULL[19]);

    private final Class<?> clas;
    private final char characterCode;
    private final int typeNum;
    private final Object nullValue;
    private final Object posInfinity;
    private final Object negInfinity;
    private static final Map<Class<?>, KdbType> classLookup;
    private static final long INF_TIME_LONG = 2143883647L;
    private static final int INF_TIMESTAMP_NANOS = 854775807;
    private static final long INF_TIMESTAMP_TIME = 10170053236854L;
    private static final long INF_DATE_LONG = 185543533782000000L;
    private static final long NEG_DATE_LONG = -185541640416000000L;
    private static final long INF_DATE = -9223371090169975809L;
    private static final long NEG_TIMESTAMP_TIME = -8276687236855L;
    private static final long NEG_TIMESTAMP_NANOS = 145224193L;
    private static final long NEG_TIME_LONG = -2151083647L;
    private static final long NEG_DATE = -9223371090169975808L;
    private static final long DT_EPOCH = -9223371090169976L;

    private KdbType(int typeNum, Class clas, char ch) {
        this(typeNum, clas, ch, null, null, null);
    }

    private KdbType(int typeNum, Class clas, char ch, Object nullVal) {
        this(typeNum, clas, ch, nullVal, null, null);
    }

    private KdbType(int typeNum, Class clas, char ch, Object nullVal, Object posInfinity, Object negInfinity) {
        this.typeNum = typeNum;
        this.clas = clas;
        this.characterCode = ch;
        this.nullValue = nullVal;
        this.posInfinity = posInfinity;
        this.negInfinity = negInfinity;
    }

    public boolean hasInfinity() {
        return this.posInfinity != null;
    }

    public char getCharacterCode() {
        return this.characterCode;
    }

    public Class<?> getClas() {
        return this.clas;
    }

    public Object getNullValue() {
        return this.nullValue;
    }

    public Object getNegInfinity() {
        return this.negInfinity;
    }

    public Object getPosInfinity() {
        return this.posInfinity;
    }

    public int getTypeNum() {
        return this.typeNum;
    }

    public static KdbType getType(Class<?> clas) {
        return classLookup.get(clas);
    }

    public static boolean isNull(Object o) {
        if (o != null) {
            for (KdbType kt : KdbType.values()) {
                if (!o.equals(kt.nullValue)) continue;
                return true;
            }
        }
        return c.qn(o);
    }

    public static boolean isPositiveInfinity(Object o) {
        if (o.getClass() == Instant.class) {
            Instant in = (Instant)o;
            return in.getEpochSecond() == 10170056836L && (long)in.getNano() == 854775807L;
        }
        if (o.getClass() == LocalDate.class) {
            return ((LocalDate)o).toEpochDay() == 2147494604L;
        }
        if (o.getClass() == LocalDateTime.class) {
            return ((LocalDateTime)o).toEpochSecond(ZoneOffset.UTC) == -9223371090169976L && ((LocalDateTime)o).getNano() == 191000000;
        }
        if (o.getClass() == LocalTime.class) {
            return ((LocalTime)o).toNanoOfDay() == 73883647000000L;
        }
        if (o instanceof Date) {
            return ((Date)o).getTime() == 185543533782000000L;
        }
        if (o instanceof Timestamp) {
            Timestamp ts = (Timestamp)o;
            return ts.getTime() == 10170053236854L && ts.getNanos() == 854775807;
        }
        if (o instanceof Time) {
            return ((Time)o).getTime() == 2143883647L;
        }
        if (o instanceof java.util.Date) {
            return ((java.util.Date)o).getTime() == -9223371090169975809L;
        }
        if (o != null) {
            for (KdbType kt : KdbType.values()) {
                if (!o.equals(kt.posInfinity)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isNegativeInfinity(Object o) {
        if (o.getClass() == Instant.class) {
            Instant in = (Instant)o;
            return in.getEpochSecond() == -8276687237L && in.getNano() == 145224193;
        }
        if (o.getClass() == LocalDate.class) {
            return ((LocalDate)o).toEpochDay() == -2147472690L;
        }
        if (o.getClass() == LocalDateTime.class) {
            return ((LocalDateTime)o).toEpochSecond(ZoneOffset.UTC) == -9223371090169976L && ((LocalDateTime)o).getNano() == 192000000;
        }
        if (o.getClass() == LocalTime.class) {
            return ((LocalTime)o).toNanoOfDay() == 12516353000000L;
        }
        if (o.getClass() == Date.class) {
            return ((Date)o).getTime() == -185541640416000000L;
        }
        if (o.getClass() == Timestamp.class) {
            Timestamp ts = (Timestamp)o;
            return ts.getTime() == -8276687236855L && (long)ts.getNanos() == 145224193L;
        }
        if (o instanceof Time) {
            return ((Time)o).getTime() == -2151083647L;
        }
        if (o instanceof java.util.Date) {
            return ((java.util.Date)o).getTime() == -9223371090169975808L;
        }
        if (o != null) {
            for (KdbType kt : KdbType.values()) {
                if (!o.equals(kt.negInfinity)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        classLookup = Maps.uniqueIndex(ImmutableList.copyOf(KdbType.values()), new Function<KdbType, Class<?>>(){

            @Override
            public Class<?> apply(KdbType kt) {
                return kt.getClas();
            }
        });
    }
}

