/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio.kdb;

import com.timestored.qstudio.kdb.CAtomTypes;
import com.timestored.qstudio.kdb.KdbType;
import com.timestored.sqldash.chart.TableFactory;
import com.timestored.sqldash.chart.TimeStringValuer;
import com.timestored.swingxx.JTreeHelper;
import com.timestored.theme.Theme;
import java.awt.Component;
import java.awt.Font;
import java.lang.reflect.Array;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import jsyntaxpane.DefaultSyntaxKit;
import kx.c;
import kx.jdbc;

public class KdbHelper {
    private static final Logger LOG = Logger.getLogger(KdbHelper.class.getName());
    private static final NumberFormat NUM_FORMAT;
    public static final int DEFAULT_MAX_FRACTION_DIGITS = 7;
    public static final int DEFAULT_GROUPING_SIZE = 0;
    private static int decimalPlaces;
    private static String formatString;
    private static final TimeStringValuer TABLE_STRINGER;
    private static final TimeStringValuer VAL_STRINGER;

    public static void setGroupingSize(int groupingSize) {
        NUM_FORMAT.setGroupingUsed(groupingSize > 0);
        if (NUM_FORMAT instanceof DecimalFormat) {
            ((DecimalFormat)NUM_FORMAT).setGroupingSize(groupingSize);
        }
    }

    public static void setMaximumFractionDigits(int decimalPlaces) {
        if (decimalPlaces < 0) {
            decimalPlaces = 0;
        }
        if (NUM_FORMAT instanceof DecimalFormat) {
            NUM_FORMAT.setMaximumFractionDigits(decimalPlaces);
        }
        KdbHelper.decimalPlaces = decimalPlaces;
        formatString = "%." + decimalPlaces + "f";
    }

    public static String asLine(Object k) {
        return KdbHelper.asText(k, false, true);
    }

    public static String asText(Object k) {
        return KdbHelper.asText(k, false, false);
    }

    public static String asText(Object k, boolean forTable, boolean singleLine) {
        String s = null;
        try {
            s = k != null ? (k instanceof c.Flip || k instanceof c.Dict ? k.toString() : KdbHelper.vs(k, forTable, singleLine)) : (forTable ? "" : "::");
        }
        catch (ClassCastException | IllegalArgumentException runtimeException) {
            // empty catch block
        }
        if (s == null) {
            return s;
        }
        return s + (singleLine ? "" : "\r\n");
    }

    public static String asLine(Object k, boolean forTable) {
        return KdbHelper.asText(k, forTable, true);
    }

    private static String flatten(Object[] a, String emptySt, String postfix) {
        if (a.length == 0) {
            return emptySt;
        }
        if (a.length == 1) {
            return "," + KdbHelper.vs(a[0]);
        }
        StringBuilder s = new StringBuilder(a.length * 3);
        s.append("(" + KdbHelper.vs(a[0]));
        int i = 1;
        while ((long)i < Math.min((long)a.length, 50000L)) {
            s.append(";").append(KdbHelper.vs(a[i]));
            ++i;
        }
        if ((long)a.length > 50000L) {
            s.append("...");
        }
        return s.append(")").toString();
    }

    private static String vs(Object k) {
        return KdbHelper.vs(k, false, true);
    }

    private static String vs(Object k, boolean forTable, boolean singleLine) {
        TimeStringValuer conv;
        String li = "";
        TimeStringValuer timeStringValuer = conv = forTable ? TABLE_STRINGER : VAL_STRINGER;
        if (k == null && !forTable) {
            li = "::";
        } else if (k instanceof String[]) {
            li = conv.flatten((String[])k, "`symbol$()", "", "`");
        } else if (k instanceof Object[]) {
            li = KdbHelper.flatten((Object[])k, "", "");
        } else if (k instanceof int[]) {
            li = conv.flatten((int[])k, "`int$()", "i");
        } else if (k instanceof long[]) {
            li = conv.flatten((long[])k, "`long$()", "");
        } else if (k instanceof double[]) {
            li = conv.flatten((double[])k, "`float$()", "");
        } else if (k instanceof float[]) {
            li = conv.flatten((float[])k, "`real$()", "e");
        } else if (k instanceof short[]) {
            li = conv.flatten((short[])k, "`short$()", "h");
        } else if (k instanceof boolean[]) {
            li = conv.flatten((boolean[])k, "`boolean$()", "b");
        } else if (k instanceof Boolean) {
            li = (Boolean)k != false ? "1b" : "0b";
        } else if (k instanceof byte[]) {
            li = conv.flatten((byte[])k, "`byte$()", "", "0x");
        } else if (k instanceof Character) {
            li = forTable ? k.toString() : "\"" + k.toString() + "\"";
        } else if (k instanceof char[]) {
            li = new String((char[])k);
            if (singleLine) {
                li = li.replace("\r", "\\r").replace("\n", "\\n");
            }
            if (!forTable) {
                li = "\"" + li + "\"";
            }
        } else if (k instanceof String) {
            li = forTable ? k.toString() : "`" + k;
        } else if (k instanceof c.Dict || k instanceof c.Flip) {
            li = k.toString();
        } else if (k != null) {
            KdbType kt = KdbType.getType(k.getClass());
            if (kt != null) {
                char cc = kt.getCharacterCode();
                li = conv.getString(k);
                boolean hideTypeChar = forTable || cc == 'j' || cc == 'x' || cc == 'f' && (li.contains(".") || li.contains("n") || li.contains("w"));
                li = li + (hideTypeChar ? "" : Character.valueOf(kt.getCharacterCode()));
            } else if (k != null) {
                li = conv.getString(k);
            }
        }
        return li;
    }

    public static int count(Object k) {
        if (k == null) {
            return 0;
        }
        try {
            if (k.getClass().isArray()) {
                return Array.getLength(k);
            }
            if (k instanceof c.Flip) {
                Object vals = ((c.Flip)k).y[0];
                if (vals.getClass().isArray()) {
                    return Array.getLength(vals);
                }
                return ((c.Flip)k).x.length;
            }
            if (k instanceof c.Dict) {
                c.Dict d = (c.Dict)k;
                if (d.x instanceof c.Flip) {
                    Object vals = ((c.Flip)d.x).y[0];
                    if (vals.getClass().isArray()) {
                        return Array.getLength(vals);
                    }
                    return ((c.Flip)k).x.length;
                }
                if (d.x.getClass().isArray()) {
                    return Array.getLength(d.x);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public static char getTypeChar(int type) {
        String typec = " b gxhijefcspmdznuvt";
        int t = Math.abs(type);
        if (t < " b gxhijefcspmdznuvt".length()) {
            return " b gxhijefcspmdznuvt".charAt(t);
        }
        return '?';
    }

    public static String escape(String qCode) {
        return qCode.replace("\\", "\\\\").replace("\t", "\\t").replace("\r", "\\r").replace("\n", "\\n").replace("\"", "\\\"");
    }

    private static String format(Object o, boolean forTable) {
        boolean isFloat;
        if (o == null || o instanceof String && o.equals("")) {
            return "";
        }
        boolean bl = isFloat = o instanceof Float || o instanceof Double;
        if (KdbType.isNull(o)) {
            if (forTable) {
                return "";
            }
            return isFloat ? "0n" : "0N";
        }
        if (KdbType.isPositiveInfinity(o)) {
            return isFloat ? "0w" : "0W";
        }
        if (KdbType.isNegativeInfinity(o)) {
            return isFloat ? "-0w" : "-0W";
        }
        if (o instanceof Double) {
            return KdbHelper.formatFloatingPt((Double)o, forTable);
        }
        if (o instanceof Float) {
            return KdbHelper.formatFloatingPt(((Float)o).floatValue(), forTable);
        }
        if (o instanceof Byte) {
            return "0x" + String.format("%02x", (Byte)o).toLowerCase();
        }
        return null;
    }

    public static String formatFloatingPt(double d) {
        return KdbHelper.formatFloatingPt(d, false);
    }

    private static String formatFloatingPt(double d, boolean forTable) {
        if (forTable) {
            return NUM_FORMAT.format(d);
        }
        String tmp = String.format(formatString, d);
        return TimeStringValuer.trimTrailingPointZeroes(tmp);
    }

    public static Component getComponent(Object k) {
        return KdbHelper.getComponent(k, Integer.MAX_VALUE);
    }

    public static Component getComponent(Object k, int maxRowsShown) {
        Component res = new JPanel();
        if (k == null) {
            return res;
        }
        res = maxRowsShown > 0 ? KdbHelper.getJXTableFromKdb(k, maxRowsShown) : KdbHelper.getJXTable(k);
        if (res == null) {
            char[] ck;
            char[] cArray = ck = k instanceof char[] ? (char[])k : new char[]{};
            if (ck.length >= 2 && ck[0] == '{' && (ck[ck.length - 1] == '}' || ck[ck.length - 1] == ']')) {
                String code = new String(ck);
                DefaultSyntaxKit.initKit();
                JEditorPane codeEditor = new JEditorPane();
                JScrollPane scrPane = new JScrollPane(codeEditor);
                codeEditor.setContentType("text/qsql");
                codeEditor.setText(code);
                codeEditor.setEditable(false);
                codeEditor.setFont(UIManager.getFont("defaultFont"));
                return scrPane;
            }
            String txt = KdbHelper.asText(k);
            if (txt != null) {
                return new JScrollPane(Theme.getTextArea("flat-kdb-res", txt));
            }
        }
        if (k.getClass().isArray()) {
            JTabbedPane tabbedPane = new JTabbedPane();
            if (res != null) {
                tabbedPane.add("Table", res);
            }
            if (KdbHelper.isMixedList(k)) {
                tabbedPane.add("Tree", KdbHelper.getTree(k, maxRowsShown));
            }
            JScrollPane txtPanel = new JScrollPane(Theme.getTextArea("flat-kdb-res", KdbHelper.asText(k)));
            tabbedPane.add("Text", txtPanel);
            res = tabbedPane;
        }
        return res;
    }

    public static Component getJXTable(Object kObject) {
        return KdbHelper.getJXTableFromKdb(kObject, Integer.MAX_VALUE);
    }

    public static Component getJXTableFromKdb(Object kObject, int maxRowsShown) {
        try {
            return TableFactory.getTable(jdbc.getRS(kObject), maxRowsShown);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "problem creating table", e);
            return null;
        }
    }

    private static Component getTree(Object k, int maxRowsShown) {
        JScrollPane c2 = null;
        try {
            JTree tree = new JTree(KdbHelper.getBranch(k, maxRowsShown, -1));
            Font currentFont = tree.getFont();
            Font bigFont = new Font(currentFont.getName(), currentFont.getStyle(), currentFont.getSize() + 1);
            tree.setFont(bigFont);
            JTreeHelper.expandAll(tree, true);
            tree.setCellRenderer(new CustomNodeRenderer());
            tree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            c2 = new JScrollPane(tree);
        }
        catch (IllegalArgumentException iae) {
            LOG.log(Level.FINE, "getTree - wasn't an array", iae);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "getTree - bigger problem", e);
        }
        return c2;
    }

    private static DefaultMutableTreeNode getBranch(Object k, int maxRowsShown, int myIndex) {
        DefaultMutableTreeNode root;
        if (k instanceof String[] || k instanceof Object[]) {
            int len = Array.getLength(k);
            int l = Math.min(maxRowsShown, len);
            root = myIndex >= 0 ? new DefaultMutableTreeNode("[" + myIndex + "]") : new DefaultMutableTreeNode(len + " items");
            for (int i = 0; i < l; ++i) {
                Object nk = Array.get(k, i);
                if (nk instanceof String[] || nk instanceof Object[]) {
                    root.add(KdbHelper.getBranch(nk, maxRowsShown, i));
                    continue;
                }
                root.add(new CustomNode(Array.get(k, i), i));
            }
            if (len > l) {
                root.add(new DefaultMutableTreeNode("..."));
            }
        } else {
            root = new CustomNode(k);
        }
        return root;
    }

    private static boolean isMixedList(Object k) {
        if (k instanceof Object[]) {
            return k.getClass().getComponentType().equals(Object.class);
        }
        return false;
    }

    static {
        decimalPlaces = 7;
        formatString = "%." + decimalPlaces + "f";
        TABLE_STRINGER = new TimeStringValuer(l -> KdbHelper.format(l, true), null);
        VAL_STRINGER = new TimeStringValuer(l -> KdbHelper.format(l, false), "yyyy.MM.dd");
        NUM_FORMAT = NumberFormat.getInstance();
        KdbHelper.setMaximumFractionDigits(decimalPlaces);
        KdbHelper.setGroupingSize(0);
    }

    private static class CustomNodeRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.setToolTipText(null);
            if (value instanceof CustomNode) {
                CustomNode cn = (CustomNode)value;
                this.setText(cn.getText());
                this.setToolTipText(cn.getTooltip());
                if (cn.getIcon() != null) {
                    this.setIcon(cn.getIcon());
                }
            }
            return this;
        }
    }

    private static class CustomNode
    extends DefaultMutableTreeNode {
        public final Object k;
        public final int i;
        private ImageIcon icon;

        public CustomNode(Object k, int i) {
            this.k = k;
            this.i = i;
            CAtomTypes type = CAtomTypes.getTypeOfJavaObject(k);
            if (type != null) {
                this.icon = type.getIcon().get();
            }
        }

        public CustomNode(Object k) {
            this(k, -1);
        }

        public String getText() {
            return (this.i >= 0 ? "[" + this.i + "] = " : "") + KdbHelper.asLine(this.k);
        }

        public String getTooltip() {
            return "" + KdbHelper.count(this.k);
        }

        public Icon getIcon() {
            return this.icon;
        }
    }
}

