/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio.kdb;

import com.timestored.theme.Icon;
import com.timestored.theme.Theme;
import java.lang.reflect.Array;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import kx.c;

public enum CAtomTypes {
    BOOLEAN_LIST(1, Boolean.class),
    GUID_LIST(2),
    BYTE_LIST(4, Byte.class),
    SHORT_LIST(5, Short.class),
    INT_LIST(6, Integer.class),
    LONG_LIST(7, Long.class),
    REAL_LIST(8, Float.class),
    FLOAT_LIST(9, Double.class),
    CHAR_LIST(10, Character.class),
    SYMBOL_LIST(11, String.class),
    TIMESTAMP_LIST(12, Timestamp.class, true, true),
    MONTH_LIST(13, c.Month.class, true, false),
    DATE_LIST(14, Date.class, true, false),
    DATETIME_LIST(15, java.util.Date.class, true, true),
    TIMESPAN_LIST(16, null, false, true),
    MINUTE_LIST(17, c.Minute.class, false, true),
    SECOND_LIST(18, c.Second.class, false, true),
    TIME_LIST(19, Time.class, false, true),
    MIXED_LIST(0),
    BOOLEAN(-1, Boolean.class),
    GUID(-2),
    BYTE(-4, Byte.class),
    SHORT(-5, Short.class),
    INT(-6, Integer.class),
    LONG(-7, Long.class),
    REAL(-8, Float.class),
    FLOAT(-9, Double.class),
    CHAR(-10, Character.class),
    SYMBOL(-11, String.class),
    TIMESTAMP(-12, Timestamp.class, true, true),
    MONTH(-13, c.Month.class, true, false),
    DATE(-14, Date.class, true, false),
    DATETIME(-15, java.util.Date.class, true, true),
    TIMESPAN(-16, c.Timespan.class, false, true),
    MINUTE(-17, c.Minute.class, false, true),
    SECOND(-18, c.Second.class, false, true),
    TIME(-19, Time.class, false, true),
    TABLE(98),
    DICTIONARY(99),
    LAMBDA(100),
    UNARY_PRIMITIVE(101),
    BINARY_PRIMITIVE(102),
    TERNARY_OPERATOR(103),
    PROJECTION(104),
    COMPOSITION(105),
    F_EACH(106),
    F_OVER(107),
    F_SCAN(108),
    F_EACH_BOTH(109),
    F_EACH_RIGHT(110),
    F_EACH_LEFT(111),
    DYNAMIC_LOAD(112),
    VIEW(3000);

    private static final Map<Integer, CAtomTypes> typeMap;
    public static final EnumSet<CAtomTypes> NUMBERS;
    public static final EnumSet<CAtomTypes> TEMPORALS;
    public static final EnumSet<CAtomTypes> LISTS;
    public static final EnumSet<CAtomTypes> FUNCTIONS;
    public static final EnumSet<CAtomTypes> CHARACTERS;
    private final int typeNum;
    private final Class<?> clas;
    private final boolean hasDateComponent;
    private final boolean hasTimeComponent;

    private CAtomTypes(int typeNum, Class clas, boolean hasDateComponent, boolean hasTimeComponent) {
        this.typeNum = typeNum;
        this.clas = clas;
        this.hasDateComponent = hasDateComponent;
        this.hasTimeComponent = hasTimeComponent;
    }

    private CAtomTypes(int typeNum, Class clas) {
        this(typeNum, clas, false, false);
    }

    private CAtomTypes(int typeNum) {
        this(typeNum, null);
    }

    public int getTypeNum() {
        return this.typeNum;
    }

    public static CAtomTypes getType(int typeNum) {
        return typeMap.get(typeNum);
    }

    public static CAtomTypes getTypeOfJavaObject(Object o) {
        if (o == null) {
            return null;
        }
        if (o.getClass().isArray()) {
            if (Array.getLength(o) > 0) {
                Class<?> c2 = Array.get(o, 0).getClass();
                for (CAtomTypes at : EnumSet.allOf(CAtomTypes.class)) {
                    if (at.clas == null || !at.clas.equals(c2)) continue;
                    return at;
                }
            }
            return MIXED_LIST;
        }
        for (CAtomTypes at : EnumSet.allOf(CAtomTypes.class)) {
            if (!at.isAtom() || at.clas == null || !at.clas.equals(o.getClass())) continue;
            return at;
        }
        return null;
    }

    public Class<?> getClas() {
        return this.clas;
    }

    public boolean hasDateComponent() {
        return this.hasDateComponent;
    }

    public boolean hasTimeComponent() {
        return this.hasTimeComponent;
    }

    public boolean isNumber() {
        return NUMBERS.contains((Object)this);
    }

    public boolean isTemporal() {
        return TEMPORALS.contains((Object)this);
    }

    public boolean isList() {
        return LISTS.contains((Object)this);
    }

    public boolean isAtom() {
        return this.isFunction() || !LISTS.contains((Object)this) && !this.equals((Object)TABLE) && !this.equals((Object)DICTIONARY);
    }

    public boolean isFunction() {
        return FUNCTIONS.contains((Object)this);
    }

    public boolean isCharacter() {
        return CHARACTERS.contains((Object)this);
    }

    public Icon getIcon() {
        if (this.isNumber()) {
            return Theme.CIcon.NUMBER_ELEMENT;
        }
        if (this.isTemporal()) {
            return Theme.CIcon.DATE_ELEMENT;
        }
        if (this.equals((Object)VIEW)) {
            return Theme.CIcon.VIEW_ELEMENT;
        }
        if (this.equals((Object)LAMBDA)) {
            return Theme.CIcon.LAMBDA_ELEMENT;
        }
        if (this.isFunction()) {
            return Theme.CIcon.FUNCTION_ELEMENT;
        }
        if (this.isCharacter()) {
            return Theme.CIcon.CHAR_ELEMENT;
        }
        return Theme.CIcon.FUNCTION_ELEMENT;
    }

    static {
        typeMap = new HashMap<Integer, CAtomTypes>();
        NUMBERS = EnumSet.of(SHORT, new CAtomTypes[]{INT, LONG, REAL, FLOAT, SHORT_LIST, INT_LIST, LONG_LIST, REAL_LIST, FLOAT_LIST});
        TEMPORALS = EnumSet.of(TIMESTAMP, new CAtomTypes[]{MONTH, DATE, DATETIME, TIMESPAN, MINUTE, SECOND, TIME, TIMESTAMP_LIST, MONTH_LIST, DATE_LIST, DATETIME_LIST, TIMESPAN_LIST, MINUTE_LIST, SECOND_LIST, TIME_LIST});
        LISTS = EnumSet.of(BOOLEAN_LIST, new CAtomTypes[]{GUID_LIST, BYTE_LIST, SHORT_LIST, INT_LIST, LONG_LIST, REAL_LIST, FLOAT_LIST, CHAR_LIST, SYMBOL_LIST, TIMESTAMP_LIST, MONTH_LIST, DATE_LIST, DATETIME_LIST, TIMESPAN_LIST, MINUTE_LIST, SECOND_LIST, TIME_LIST, MIXED_LIST});
        FUNCTIONS = EnumSet.of(LAMBDA, new CAtomTypes[]{UNARY_PRIMITIVE, BINARY_PRIMITIVE, TERNARY_OPERATOR, PROJECTION, COMPOSITION, F_EACH, F_OVER, F_SCAN, F_EACH_BOTH, F_EACH_RIGHT, F_EACH_LEFT, DYNAMIC_LOAD, VIEW});
        CHARACTERS = EnumSet.of(CHAR, CHAR_LIST, SYMBOL_LIST, SYMBOL);
        for (CAtomTypes qt : EnumSet.allOf(CAtomTypes.class)) {
            typeMap.put(qt.typeNum, qt);
        }
    }
}

