/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio;

import com.timestored.qstudio.Persistance;
import com.timestored.qstudio.model.PersistanceInterface;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JDialog;

class WindowSizePersister {
    private final PersistanceInterface persistance;
    private final Persistance.Key key;

    WindowSizePersister(final JDialog dialog, final PersistanceInterface persistance, final Persistance.Key key) {
        this.persistance = persistance;
        this.key = key;
        dialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                persistance.put(key, WindowSizePersister.this.convertToString(dialog.getSize()));
            }
        });
    }

    private String convertToString(Dimension size) {
        return size.width + "," + size.height;
    }

    private Dimension convertToDimension(String val2) {
        String[] r = val2.split(",");
        if (r.length != 2) {
            throw new IllegalArgumentException("can't read dimensions");
        }
        return new Dimension(Integer.parseInt(r[0]), Integer.parseInt(r[1]));
    }

    public Dimension getDimension(Dimension defaultDim) {
        String d = this.persistance.get(this.key, "");
        if (!d.equals("")) {
            try {
                return this.convertToDimension(d);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultDim;
    }
}

