/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio;

import bibliothek.gui.dock.action.actions.SimpleButtonAction;
import com.timestored.TimeStored;
import com.timestored.babeldb.Curler;
import com.timestored.connections.ConnectionManager;
import com.timestored.connections.JdbcTypes;
import com.timestored.docs.OpenDocumentsModel;
import com.timestored.jgrowl.Growler;
import com.timestored.jgrowl.GrowlerFactory;
import com.timestored.misc.AppLaunchHelper;
import com.timestored.misc.HtmlUtils;
import com.timestored.qstudio.MyPreferences;
import com.timestored.qstudio.Persistance;
import com.timestored.qstudio.QStudioModel;
import com.timestored.theme.Theme;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class UpdateHelper {
    private static final Logger LOG = Logger.getLogger(UpdateHelper.class.getName());
    private static final Random R = new Random();
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static final Map<String, AtomicInteger> eventCount = new ConcurrentHashMap<String, AtomicInteger>();
    private static QStudioModel qStudioModel;
    private static final int GAP = 4;
    private static final String[] IMG_NAMES;

    private static String encode(String k, String v) throws IOException {
        return URLEncoder.encode(k, "UTF-8") + "=" + URLEncoder.encode(v, "UTF-8");
    }

    private static void postInfo() throws IOException {
        if (!MyPreferences.INSTANCE.isSendTelemetry()) {
            return;
        }
        StringBuilder postData = new StringBuilder();
        if (qStudioModel != null) {
            postData.append(UpdateHelper.getUrlParams(qStudioModel, 0));
        }
        for (Map.Entry<String, AtomicInteger> entry : eventCount.entrySet()) {
            if (postData.length() != 0) {
                postData.append('&');
            }
            postData.append(UpdateHelper.encode(entry.getKey(), "" + entry.getValue()));
        }
        String st2 = postData.toString();
        byte[] postDataBytes = st2.getBytes("UTF-8");
        String reqType = "application/x-www-form-urlencoded";
        String U = "https://www.timestored.com/qstudio/addon/u";
        Curler.POST(U, null, reqType, postDataBytes);
        eventCount.clear();
    }

    public static void registerEvent(String event) {
        eventCount.putIfAbsent(event, new AtomicInteger(0));
        eventCount.get(event).incrementAndGet();
    }

    public static JPanel getUpdateGrowler(String newVersion) {
        JPanel p = new JPanel(new BorderLayout(4, 4));
        JPanel topRow = new JPanel(new BorderLayout(4, 4));
        JLabel l = GrowlerFactory.getLabelWithFixedWidth("There's an update available: QStudio " + newVersion, 0);
        topRow.add((Component)l, "Center");
        topRow.add((Component)new JLabel("X"), "East");
        p.add((Component)topRow, "North");
        JButton updateButton = new JButton("Install Update");
        updateButton.addActionListener(al -> {
            HtmlUtils.browse(TimeStored.Page.QSTUDIO_DOWNLOAD.url());
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.exit(0);
        });
        updateButton.setBackground(Theme.HIGHLIGHT_BUTTON_COLOR);
        updateButton.setForeground(Color.WHITE);
        updateButton.setOpaque(true);
        JButton changesButton = new JButton("Release Notes");
        changesButton.addActionListener(al -> HtmlUtils.browse(TimeStored.Page.QSTUDIO_CHANGES.url()));
        JPanel butPanel = new JPanel(new GridLayout(1, 0, 4, 4));
        butPanel.add(new JLabel("   "));
        butPanel.add(updateButton);
        butPanel.add(changesButton);
        p.add((Component)butPanel, "South");
        return p;
    }

    static String getUrlParams(QStudioModel qsm, int queryCount) {
        StringBuilder sb = new StringBuilder();
        sb.append("?v=4.07");
        MyPreferences myPreferences = MyPreferences.INSTANCE;
        if (myPreferences != null && !myPreferences.isSendTelemetry()) {
            return sb.toString();
        }
        sb.append("&q=" + queryCount);
        try {
            String ctypes = "";
            Stream conns = qsm.getConnectionManager().getServerConnections().stream();
            Map ctypesMap = conns.map(sc -> sc.getJdbcType().name().toLowerCase().substring(0, 2)).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
            for (Map.Entry enn : ctypesMap.entrySet()) {
                ctypes = ctypes + "" + (String)enn.getKey() + enn.getValue();
            }
            sb.append("&c=" + ctypes);
        }
        catch (Exception ctypes) {
            // empty catch block
        }
        try {
            String ftypes = "";
            Stream docs = qsm.getOpenDocumentsModel().getDocuments().stream();
            Map ftypesMap = docs.map(d -> d.getFileEnding()).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
            for (Map.Entry enn : ftypesMap.entrySet()) {
                ftypes = ftypes + "-" + (String)enn.getKey() + "." + enn.getValue();
            }
            sb.append("&f=" + ftypes);
        }
        catch (Exception ftypes) {
            // empty catch block
        }
        try {
            long firstEverRun = qsm.getPersistance().getLong(Persistance.Key.FERDB, -1L);
            sb.append("&d=" + qsm.getOpenDocumentsModel().getDocuments().size());
            sb.append("&date=" + firstEverRun);
            sb.append("&os=" + UpdateHelper.getPropAsParam("os.name"));
            sb.append("&ctry=" + UpdateHelper.getPropAsParam("user.country"));
            sb.append("&lang=" + UpdateHelper.getPropAsParam("user.language"));
            sb.append("&vmn=" + UpdateHelper.getPropAsParam("java.vm.name"));
            sb.append("&vmv=" + UpdateHelper.getPropAsParam("java.vm.vendor"));
            sb.append("&jv=" + UpdateHelper.getPropAsParam("java.version"));
            sb.append("&tz=" + URLEncoder.encode(TimeZone.getDefault().getID()));
            sb.append("&" + UpdateHelper.encode("font", MyPreferences.INSTANCE.getCodeFont()));
            sb.append("&" + UpdateHelper.encode("fontsize", "" + MyPreferences.INSTANCE.getCodeFontSize()));
            sb.append("&" + UpdateHelper.encode("theme", MyPreferences.INSTANCE.getCodeTheme()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    public static void main(String ... args) {
        QStudioModel qsm = new QStudioModel(ConnectionManager.newInstance(), Persistance.INSTANCE, OpenDocumentsModel.newInstance());
        JFrame frame = new JFrame();
        frame.setSize(new Dimension(800, 800));
        JTabbedPane tabb = new JTabbedPane();
        Growler growler = GrowlerFactory.getGrowler(frame);
        JButton checkBut = new JButton("Check Version");
        checkBut.addActionListener(e -> UpdateHelper.checkVersion(qsm, 0, GrowlerFactory.getGrowler(frame)));
        JButton but = new JButton("Force");
        but.addActionListener(e -> growler.show(Level.INFO, UpdateHelper.getUpdateGrowler("VERSIONMARKER"), null, true));
        JPanel p = new JPanel();
        p.add(checkBut);
        p.add(but);
        tabb.add((Component)p, "Update Example");
        int i = 1;
        TimeStored.fetchOnlineNews();
        for (String html : TimeStored.getOnlineNews(true)) {
            tabb.add((Component)UpdateHelper.getNewsPanel(null, html), "Online Dark " + i++);
        }
        for (String html : TimeStored.getOnlineNews(false)) {
            tabb.add((Component)UpdateHelper.getNewsPanel(null, html), "Online Light " + i++);
        }
        i = 1;
        for (String html : TimeStored.NEWS) {
            tabb.add((Component)UpdateHelper.getNewsPanel(null, html), "Hardcoded " + i++);
        }
        frame.add(tabb);
        frame.setVisible(true);
    }

    static void checkVersion(QStudioModel qsm, int queryCount, Growler growler) {
        boolean newVersionAvailable = false;
        String vs = "?";
        String params = UpdateHelper.getUrlParams(qsm, queryCount);
        try (Scanner sc = new Scanner(new URL("https://www.timestored.com/qstudio/version3.txt" + params).openStream(), "UTF-8");){
            try {
                String[] versionTxt = sc.useDelimiter("\\A").next().split(",");
                vs = versionTxt[0];
                newVersionAvailable = !"4.07".equals(vs);
                try {
                    double vers = Double.parseDouble(vs);
                    double cur = Double.parseDouble("4.07");
                    newVersionAvailable = cur < vers;
                }
                catch (NumberFormatException e) {
                    LOG.warning("Error parsing versions");
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (newVersionAvailable && qsm.getQueryManager().hasAnyServers()) {
            growler.show(Level.INFO, UpdateHelper.getUpdateGrowler(vs), null, true);
        }
    }

    private static String getPropAsParam(String name) {
        String s = System.getProperty(name);
        return s == null ? "" : URLEncoder.encode(s);
    }

    public static JScrollPane getNewsPanel(JdbcTypes jdbcType) {
        boolean isDarkTheme = AppLaunchHelper.isLafDark(MyPreferences.INSTANCE.getCodeTheme());
        return UpdateHelper.getNewsPanel(jdbcType, TimeStored.getRandomLongNewsHtml(isDarkTheme));
    }

    private static JScrollPane getNewsPanel(JdbcTypes jdbcType, String newsHTML) {
        JPanel p = new JPanel(new BorderLayout());
        try {
            if (!TimeStored.isOnlineNewsAvailable()) {
                p.add(UpdateHelper.getKdbImage());
            } else {
                JPanel cp = new JPanel();
                JEditorPane tp = Theme.getHtmlText(newsHTML);
                cp.add(tp);
                p.add((Component)cp, "Center");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new JScrollPane(p);
    }

    public static JLabel getClickableImageLabel(String imgName, final TimeStored.Page page) {
        ImageIcon imgI = new ImageIcon(TimeStored.class.getResource(imgName));
        JLabel lbl = new JLabel(imgI);
        lbl.setCursor(Cursor.getPredefinedCursor(12));
        lbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                HtmlUtils.browse(page.url());
            }
        });
        return lbl;
    }

    public static JLabel getKdbImage() {
        return UpdateHelper.getClickableImageLabel(IMG_NAMES[R.nextInt(IMG_NAMES.length)], TimeStored.Page.PULSE_TUTORIALS_KDB);
    }

    public static boolean possiblyShowTimeStoredWebsite(Persistance persistance) {
        Calendar cal = Calendar.getInstance();
        if (cal.get(7) == 4 && cal.get(5) <= 4) {
            boolean advertSeenThisMonth;
            int lastOpen = persistance.getInt(Persistance.Key.LAST_AD, 0);
            int yearOffset = Math.max(cal.get(1) - 1900, 0) * 12;
            int thisOpen = yearOffset + cal.get(2);
            boolean bl = advertSeenThisMonth = thisOpen <= lastOpen;
            if (!advertSeenThisMonth) {
                persistance.putInt(Persistance.Key.LAST_AD, thisOpen);
                HtmlUtils.browse(TimeStored.Page.NEWSPAGE.url());
                return true;
            }
        }
        return false;
    }

    public static JButton tel(JButton button) {
        button.addActionListener(e -> {
            String txt = button.getName();
            txt = txt != null ? txt : (button.getText() != null ? button.getText() : button.getToolTipText());
            UpdateHelper.registerEvent("button_" + (txt == null ? "" : txt));
        });
        return button;
    }

    public JMenuItem tel(JMenuItem jMenuItem) {
        jMenuItem.addActionListener(e -> {
            String txt = jMenuItem.getName();
            txt = txt != null ? txt : (jMenuItem.getText() != null ? jMenuItem.getText() : jMenuItem.getToolTipText());
            UpdateHelper.registerEvent("menu_" + (txt == null ? "" : txt));
        });
        return jMenuItem;
    }

    public static SimpleButtonAction tel(SimpleButtonAction button) {
        String txt = button.getText();
        UpdateHelper.registerEvent("buttonaction_" + txt != null ? txt : button.getTooltip());
        return button;
    }

    public JTextField tel(JTextField txtField) {
        txtField.addActionListener(e -> UpdateHelper.registerEvent("textfield_" + txtField.getName()));
        return txtField;
    }

    public static void setQStudioModel(QStudioModel qStudioModel) {
        UpdateHelper.qStudioModel = qStudioModel;
    }

    static {
        Runnable runnable = () -> {
            try {
                UpdateHelper.postInfo();
            }
            catch (IOException e) {
                LOG.warning(e.toString());
            }
        };
        int secondsBetweenSaves = 3600;
        scheduler.scheduleAtFixedRate(runnable, secondsBetweenSaves, secondsBetweenSaves, TimeUnit.SECONDS);
        eventCount.clear();
        IMG_NAMES = new String[]{"kdb-cover.jpg", "kdb-tutorials.jpg", "crypto-dark-med.png", "excel-export.png", "fxdash-dark-med.png", "price-grid-dark-med.png", "sqlnotebook-start-menu.png", "trade-blotter-dark-med.png"};
    }
}

