/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio;

import com.timestored.qstudio.model.QueryAdapter;
import com.timestored.qstudio.model.QueryManager;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

class ServerNameComboBox
extends JComboBox {
    private static final long serialVersionUID = 1L;
    private final QueryManager queryManager;

    ServerNameComboBox(QueryManager queryManager) {
        this.queryManager = queryManager;
        this.addActionListener(this);
        queryManager.addQueryListener(new QueryAdapter(){

            @Override
            public void selectedServerChanged(String server) {
                ServerNameComboBox.this.refresh();
            }

            @Override
            public void serverListingChanged(List<String> serverNames) {
                String[] names = serverNames.toArray(new String[0]);
                ServerNameComboBox.this.setModel(new DefaultComboBoxModel<String>(names));
                ServerNameComboBox.this.refresh();
            }
        });
        this.setModel(new DefaultComboBoxModel<String>(queryManager.getServerNames().toArray(new String[0])));
        this.refresh();
    }

    private void refresh() {
        String selServer = this.queryManager.getSelectedServerName();
        String mySel = (String)this.getSelectedItem();
        if (selServer != null && !selServer.equals(mySel)) {
            this.setSelectedItem(selServer);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.queryManager.setSelectedServerName((String)this.getSelectedItem());
    }
}

