/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.timestored.docs.Document;
import com.timestored.docs.DocumentActions;
import com.timestored.docs.DocumentsPopupMenu;
import com.timestored.docs.FileDropDocumentHandler;
import com.timestored.docs.OpenDocumentsModel;
import com.timestored.qstudio.CommonActions;
import com.timestored.qstudio.DocEditorPane;
import com.timestored.qstudio.EditorConfigFactory;
import com.timestored.qstudio.GrabItem;
import com.timestored.qstudio.GrabableContainer;
import com.timestored.qstudio.QDocController;
import com.timestored.swingxx.TabbedPaneRightClickBlocker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterException;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jsyntaxpane.DefaultSyntaxKit;
import jsyntaxpane.syntaxkits.BashSyntaxKit;
import jsyntaxpane.syntaxkits.DOSBatchSyntaxKit;
import jsyntaxpane.syntaxkits.JavaScriptSyntaxKit;
import jsyntaxpane.syntaxkits.PlainSyntaxKit;
import jsyntaxpane.syntaxkits.SqlSyntaxKit;
import jsyntaxpane.util.Configuration;

public class ServerDocumentPanel
extends JPanel
implements GrabableContainer {
    private static final Logger LOG = Logger.getLogger(ServerDocumentPanel.class.getName());
    private static final long serialVersionUID = 1L;
    private static final int SPLITPANE_WIDTH = 200;
    private boolean ignoredOnce = false;
    private final JTabbedPane tabbedPane;
    private final OpenDocumentsModel openDocModel;
    private final CommonActions commonActions;
    private final DocumentActions documentActions;
    private final QDocController qDocController;
    private final FileDropDocumentHandler.Listener fileDropListener;
    private final JFrame parentFrame;
    private String assumedFileEnding = "q";
    private boolean iAmChangingSelection = false;
    private Font editorFont = null;
    private static Consumer<EditorConfigFactory.EditorConfig> editorConfigUpdater;

    ServerDocumentPanel(CommonActions commonActions, final DocumentActions documentActions, final OpenDocumentsModel openDocModel, JFrame parentFrame, QDocController qDocController, FileDropDocumentHandler.Listener fileDropListener) {
        this.openDocModel = openDocModel;
        this.commonActions = commonActions;
        this.documentActions = documentActions;
        this.parentFrame = parentFrame;
        this.qDocController = Preconditions.checkNotNull(qDocController);
        this.fileDropListener = Preconditions.checkNotNull(fileDropListener);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setTabLayoutPolicy(1);
        this.tabbedPane.setName("serverDocsTabbedPane");
        this.tabbedPane.setMinimumSize(new Dimension(400, 1));
        this.tabbedPane.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        for (Document document : openDocModel.getDocuments()) {
            this.addDocToTabs(document);
        }
        TabbedPaneRightClickBlocker.install(this.tabbedPane);
        this.tabbedPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                this.maybeHandleClick(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeHandleClick(e);
            }

            private void maybeHandleClick(MouseEvent e) {
                Document doc;
                JTabbedPane tabs;
                int idx;
                if (e.isPopupTrigger() && e.getSource() instanceof JTabbedPane && (idx = (tabs = (JTabbedPane)e.getSource()).indexAtLocation(e.getX(), e.getY())) >= 0 && idx < openDocModel.getDocuments().size() && (doc = openDocModel.getDocuments().get(idx)) != null) {
                    openDocModel.setSelectedDocument(doc);
                    new DocumentsPopupMenu(documentActions, doc).show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add(this.tabbedPane);
        this.refreshTabAppearance();
        openDocModel.addListener(new UpdateTabsListener());
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                QCodeEditorPanel docEditor;
                Document doc;
                Component c2;
                if (!ServerDocumentPanel.this.iAmChangingSelection && (c2 = ServerDocumentPanel.this.tabbedPane.getSelectedComponent()) != null && c2 instanceof QCodeEditorPanel && (doc = (docEditor = (QCodeEditorPanel)c2).getDoc()) != null && openDocModel.getDocuments().contains(doc) && !openDocModel.getSelectedDocument().equals(doc)) {
                    openDocModel.setSelectedDocument(doc);
                }
            }
        });
    }

    public static void setEditorConfig(EditorConfigFactory.EditorConfig editorConfig) {
        editorConfig.apply(DefaultSyntaxKit.getConfig(DefaultSyntaxKit.class));
        editorConfigUpdater.accept(editorConfig);
        editorConfig.apply(DefaultSyntaxKit.getConfig(SqlSyntaxKit.class));
        editorConfig.apply(DefaultSyntaxKit.getConfig(JavaScriptSyntaxKit.class));
        editorConfig.apply(DefaultSyntaxKit.getConfig(BashSyntaxKit.class));
        editorConfig.apply(DefaultSyntaxKit.getConfig(DOSBatchSyntaxKit.class));
        editorConfig.apply(DefaultSyntaxKit.getConfig(PlainSyntaxKit.class));
    }

    public boolean print(MessageFormat headerFormat, MessageFormat footerFormat) throws PrinterException {
        Component c2 = this.tabbedPane.getSelectedComponent();
        if (c2 != null && c2 instanceof QCodeEditorPanel) {
            QCodeEditorPanel docEditor = (QCodeEditorPanel)c2;
            return docEditor.print(headerFormat, footerFormat);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEditorFont(Font font) {
        this.editorFont = Preconditions.checkNotNull(font);
        Object object = this.tabbedPane.getTreeLock();
        synchronized (object) {
            for (Component c2 : this.tabbedPane.getComponents()) {
                if (!(c2 instanceof QCodeEditorPanel)) continue;
                ((QCodeEditorPanel)c2).setEditorFont(font);
            }
        }
    }

    private void addDocToTabs(Document document) {
        QCodeEditorPanel codep = new QCodeEditorPanel(document);
        if (this.editorFont != null) {
            codep.setEditorFont(this.editorFont);
        }
        this.documentActions.addActionsToEditor(codep, document);
        if (this.fileDropListener != null) {
            FileDropDocumentHandler fileDropHandler = new FileDropDocumentHandler(codep.getTransferHandler());
            fileDropHandler.addListener(this.fileDropListener);
            codep.setTransferHandler(fileDropHandler);
        }
        this.tabbedPane.add(codep);
        this.tabbedPane.setSelectedComponent(codep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QCodeEditorPanel getComponent(Document document) {
        Object object = this.tabbedPane.getTreeLock();
        synchronized (object) {
            for (Component c2 : this.tabbedPane.getComponents()) {
                QCodeEditorPanel codeEditorPanel;
                if (!(c2 instanceof QCodeEditorPanel) || !(codeEditorPanel = (QCodeEditorPanel)c2).getDoc().equals(document)) continue;
                return codeEditorPanel;
            }
            return null;
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        Component c2 = this.tabbedPane.getSelectedComponent();
        if (c2 != null) {
            return c2.requestFocusInWindow();
        }
        return false;
    }

    @Override
    public void requestFocus() {
        Component c2 = this.tabbedPane.getSelectedComponent();
        if (c2 != null) {
            c2.requestFocus();
        }
    }

    public int getNumberOfDocumentsOpen() {
        return this.openDocModel.getDocuments().size();
    }

    private void refreshTabAppearance() {
        for (Document doc : this.openDocModel.getDocuments()) {
            int idx;
            QCodeEditorPanel codeEditorPanel = this.getComponent(doc);
            if (codeEditorPanel == null || (idx = this.tabbedPane.indexOfComponent(codeEditorPanel)) == -1) continue;
            this.tabbedPane.setTabComponentAt(idx, this.getTabComponent(doc));
        }
        this.requestFocusInWindow();
    }

    private JPanel getTabComponent(final Document doc) {
        JPanel p = new JPanel(new FlowLayout(0, 2, 0));
        p.setName("tab-" + doc.getTitle());
        JLabel label = new JLabel(doc.getTitle(), doc.getIcon().get16(), 2);
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    ServerDocumentPanel.this.openDocModel.setSelectedDocument(doc);
                } else if (SwingUtilities.isMiddleMouseButton(e)) {
                    ServerDocumentPanel.this.documentActions.getCloseFileAction(doc).actionPerformed(null);
                }
                super.mouseClicked(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    ServerDocumentPanel.this.openDocModel.setSelectedDocument(doc);
                    new DocumentsPopupMenu(ServerDocumentPanel.this.documentActions, doc).show(e.getComponent(), e.getX(), e.getY());
                }
                super.mouseReleased(e);
            }
        });
        label.setToolTipText(doc.getFilePath());
        p.add(label);
        if (doc.equals(this.openDocModel.getSelectedDocument())) {
            JButton closeButton = new JButton("x");
            closeButton.setMaximumSize(new Dimension(16, 16));
            closeButton.setPreferredSize(new Dimension(16, 16));
            closeButton.setMargin(new Insets(0, 0, 0, 0));
            closeButton.setBorder(BorderFactory.createEmptyBorder());
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    ServerDocumentPanel.this.documentActions.getCloseFileAction(doc).actionPerformed(null);
                }
            });
            p.add(closeButton);
        }
        return p;
    }

    @Override
    public GrabItem grab() {
        Document d = new Document();
        d.setContent(this.openDocModel.getSelectedDocument().getContent());
        d.setTitle(d.getTitle());
        QCodeEditorPanel codep = new QCodeEditorPanel(d);
        if (this.editorFont != null) {
            codep.setEditorFont(this.editorFont);
        }
        codep.setEditorEditable(false);
        return new GrabItem(codep, d.getTitle());
    }

    public void setAssumedFileEnding(String assumedFileEnding) {
        this.assumedFileEnding = assumedFileEnding;
    }

    public static void setEditorConfigUpdater(Consumer<EditorConfigFactory.EditorConfig> editorConfigUpdater) {
        ServerDocumentPanel.editorConfigUpdater = editorConfigUpdater;
    }

    static {
        try {
            DefaultSyntaxKit.initKit();
        }
        catch (Exception e) {
            LOG.severe("Could not init code highlighter: " + e);
        }
        editorConfigUpdater = ec -> {};
    }

    private class QCodeEditorPanel
    extends JPanel {
        private final DocEditorPane editorPane;
        private final Document document;

        public QCodeEditorPanel(final Document document) {
            this.document = document;
            DefaultSyntaxKit.initKit();
            Configuration config = DefaultSyntaxKit.getConfig(DefaultSyntaxKit.class);
            config.put("DefaultFont", "monospaced 12");
            final int selectionStart = document.getSelectionStart();
            final int selectionEnd = document.getSelectionEnd();
            final int caretPosition = document.getCaratPosition();
            this.editorPane = new DocEditorPane(document);
            this.setActions(document);
            this.setLayout(new BorderLayout());
            this.editorPane.setName("codeEditor-" + document.getTitle());
            JScrollPane scrPane = new JScrollPane(this.editorPane);
            String txt = this.editorPane.getText();
            this.setContentType();
            this.editorPane.setText(txt);
            this.editorPane.setTooltipProvider(ServerDocumentPanel.this.qDocController.getTooltipProvider(document));
            this.add((Component)scrPane, "Center");
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    document.setSelection(selectionStart, selectionEnd, caretPosition);
                }
            });
        }

        void setContentType() {
            String end = this.document.getFileEnding();
            if (end.length() == 0) {
                end = ServerDocumentPanel.this.assumedFileEnding;
            }
            String newContentType = "";
            switch (end) {
                case "sql": 
                case "c": 
                case "cpp": 
                case "js": 
                case "json": 
                case "xml": 
                case "properties": 
                case "lua": 
                case "java": 
                case "prql": 
                case "dos": {
                    newContentType = "text/" + end;
                    break;
                }
                default: {
                    newContentType = end.equals("bat") ? "text/dosbatch" : (end.equals("sh") ? "text/bash" : (end.equals("html") || end.equals("htm") || end.equals("xhtml") ? "text/xhtml" : (end.equals("sh") ? "text/bash" : "text/qsql")));
                }
            }
            if (!this.editorPane.getContentType().equals(newContentType)) {
                String content = this.document.getContent();
                this.editorPane.setContentType(newContentType);
                this.editorPane.setText(content);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean print(MessageFormat headerFormat, MessageFormat footerFormat) throws PrinterException {
            Font originalFont;
            int sz = (originalFont = this.editorPane.getFont()).getSize();
            Font newFont = originalFont.deriveFont(0, sz > 11 ? (float)(sz - 8) : (float)sz);
            this.editorPane.setFont(newFont);
            try {
                boolean bl = this.editorPane.print(headerFormat, footerFormat);
                return bl;
            }
            finally {
                this.editorPane.setFont(originalFont);
            }
        }

        private void setActions(Document document) {
            this.editorPane.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.isControlDown() && e.getKeyCode() == 69) {
                        ServerDocumentPanel.this.commonActions.getqAction().actionPerformed(null);
                        e.consume();
                    }
                }
            });
            this.editorPane.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.isControlDown() && e.getKeyCode() == 82) {
                        ServerDocumentPanel.this.commonActions.getServerSelectAction().actionPerformed(null);
                        e.consume();
                    }
                }
            });
            this.add(ServerDocumentPanel.this.qDocController.getOutlineFileAction(this.editorPane));
            this.add(ServerDocumentPanel.this.qDocController.getOutlineAllFilesAction(this.editorPane));
            this.add(ServerDocumentPanel.this.qDocController.getAutoCompleteAction(this.editorPane, ServerDocumentPanel.this.parentFrame));
            final Action gotoDefinitionAction = ServerDocumentPanel.this.qDocController.getGotoDefinitionAction(document);
            this.add(gotoDefinitionAction);
            final Action docLookupAction = ServerDocumentPanel.this.qDocController.getDocLookupAction(this.editorPane);
            this.add(docLookupAction);
            this.editorPane.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent me) {
                    if (SwingUtilities.isRightMouseButton(me)) {
                        ArrayList<Action> acts = Lists.newArrayList(docLookupAction, gotoDefinitionAction);
                        EditorPopupMenu popMenu = new EditorPopupMenu(acts);
                        popMenu.show(me.getComponent(), me.getX(), me.getY());
                    }
                }
            });
        }

        private void add(Action action) {
            String mapkey = (String)action.getValue("Name");
            this.editorPane.getActionMap().put(mapkey, action);
            KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
            this.editorPane.getInputMap().put(keyStroke, mapkey);
        }

        public Document getDoc() {
            return this.document;
        }

        public void addCtrlActionShortcut(String key, int keyEvent, AbstractAction act) {
            KeyStroke ks = KeyStroke.getKeyStroke(keyEvent, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
            this.editorPane.getInputMap().put(ks, key);
            this.editorPane.getActionMap().put(key, act);
        }

        @Override
        public void setTransferHandler(TransferHandler newHandler) {
            this.editorPane.setTransferHandler(newHandler);
        }

        @Override
        public TransferHandler getTransferHandler() {
            return this.editorPane.getTransferHandler();
        }

        @Override
        public boolean requestFocusInWindow() {
            return this.editorPane.requestFocusInWindow();
        }

        @Override
        public void requestFocus() {
            this.editorPane.requestFocus();
        }

        public void setEditorFont(Font font) {
            this.editorPane.setFont(font);
        }

        public void setEditorEditable(boolean editable) {
            this.editorPane.setEditable(editable);
        }
    }

    private class EditorPopupMenu
    extends JPopupMenu {
        private static final long serialVersionUID = 1L;

        private EditorPopupMenu(List<Action> appendedActions) {
            this.setName("EditorPopupMenu");
            for (Action ca : ServerDocumentPanel.this.commonActions.getQueryActions()) {
                this.add(ca).setName(ca.getValue("Name") + "-action");
            }
            this.addSeparator();
            for (Action ca : ServerDocumentPanel.this.commonActions.getAiActions()) {
                this.add(ca).setName(ca.getValue("Name") + "-action");
            }
            this.addSeparator();
            for (Action ea : ServerDocumentPanel.this.documentActions.getEditorActions()) {
                if (ea == null) {
                    this.addSeparator();
                    continue;
                }
                this.add(ea).setName(ea.getValue("Name") + "-action");
            }
            if (!appendedActions.isEmpty()) {
                this.addSeparator();
                for (Action aa : appendedActions) {
                    this.add(aa).setName(aa.getValue("Name") + "-action");
                }
            }
        }
    }

    private class UpdateTabsListener
    implements OpenDocumentsModel.Listener {
        private UpdateTabsListener() {
        }

        @Override
        public void docClosed(final Document document) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ServerDocumentPanel.this.iAmChangingSelection = true;
                    QCodeEditorPanel qCodeEditorPanel = ServerDocumentPanel.this.getComponent(document);
                    if (qCodeEditorPanel != null) {
                        qCodeEditorPanel.setTransferHandler(null);
                        ServerDocumentPanel.this.tabbedPane.remove(qCodeEditorPanel);
                        ServerDocumentPanel.this.iAmChangingSelection = false;
                    }
                }
            });
        }

        @Override
        public void docSelected(final Document document) {
            EventQueue.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = ServerDocumentPanel.this.tabbedPane.getTreeLock();
                    synchronized (object) {
                        QCodeEditorPanel cep = (QCodeEditorPanel)ServerDocumentPanel.this.tabbedPane.getSelectedComponent();
                        if (!cep.getDoc().equals(document)) {
                            ServerDocumentPanel.this.refreshTabAppearance();
                            ServerDocumentPanel.this.iAmChangingSelection = true;
                            QCodeEditorPanel newDocEditor = ServerDocumentPanel.this.getComponent(document);
                            try {
                                ServerDocumentPanel.this.tabbedPane.setSelectedComponent(newDocEditor);
                            }
                            catch (IllegalArgumentException e) {
                                if (!ServerDocumentPanel.this.ignoredOnce) {
                                    ServerDocumentPanel.this.ignoredOnce = true;
                                    LOG.warning("Ignoring setSelectedComponent");
                                }
                                throw e;
                            }
                            ServerDocumentPanel.this.iAmChangingSelection = false;
                        }
                        ServerDocumentPanel.this.requestFocusInWindow();
                    }
                }
            });
        }

        @Override
        public void docAdded(final Document document) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ServerDocumentPanel.this.addDocToTabs(document);
                    ServerDocumentPanel.this.refreshTabAppearance();
                }
            });
        }

        @Override
        public void docSaved() {
            QCodeEditorPanel codeEditorPanel = ServerDocumentPanel.this.getComponent(ServerDocumentPanel.this.openDocModel.getSelectedDocument());
            codeEditorPanel.setContentType();
            this.refresh();
        }

        @Override
        public void docContentModified() {
            this.refresh();
        }

        private void refresh() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ServerDocumentPanel.this.refreshTabAppearance();
                }
            });
        }

        @Override
        public void docCaratModified() {
        }

        @Override
        public void folderSelected(File selectedFolder) {
        }

        @Override
        public void ignoredFolderPatternSelected(Pattern ignoredFolderPattern) {
        }
    }
}

