/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio;

import com.timestored.qstudio.MyPreferences;
import com.timestored.qstudio.PreferencesPanel;
import com.timestored.theme.Theme;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class QueryPreferencesPanel
extends PreferencesPanel {
    private static final long serialVersionUID = 1L;
    private final JFormattedTextField sizeLimitField;
    private final JCheckBox queryWrappedCheckBox;
    private final JTextField queryWrapPreTextField;
    private final JTextField queryWrapPostTextField;
    private final JCheckBox connectionPersistentCheckBox;

    public QueryPreferencesPanel(MyPreferences myPreferences, Component Container2) {
        super(myPreferences, Container2);
        Box panel = Box.createVerticalBox();
        panel.setBorder(Theme.getCentreBorder());
        this.connectionPersistentCheckBox = new JCheckBox();
        String tooltipText = "<html>qStudio will keep an open connection to the current server, <br/> rather than opening a new connection with each query.</html>";
        panel.add(Theme.getFormRow(this.connectionPersistentCheckBox, "Keep Server Connection Open:", tooltipText));
        this.queryWrappedCheckBox = new JCheckBox();
        tooltipText = "<html>Wrapping a query allows protecting against large results freezing the GUI <br/> and displaying exact text in the console panel. However protected <br/>servers that restrict function calls may require this to be turned off.</html>";
        JLabel b = new JLabel(Theme.CIcon.INFO.get());
        b.setToolTipText(tooltipText);
        panel.add(Theme.getFormRow(this.queryWrappedCheckBox, "Wrap query sent to server:", tooltipText, b));
        this.queryWrappedCheckBox.setSelected(myPreferences.isQueryWrapped());
        this.queryWrappedCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                QueryPreferencesPanel.this.sizeLimitField.setEnabled(QueryPreferencesPanel.this.queryWrappedCheckBox.isSelected());
            }
        });
        this.sizeLimitField = new JFormattedTextField((Object)0);
        String sizeTT = "Queries will never return objects over this size. Useful to prevent lockups due to slow transfers.";
        panel.add(Theme.getFormRow(this.sizeLimitField, "Query Maximum Size Limit MB:", sizeTT));
        panel.add(Box.createVerticalStrut(10));
        Box queryWrapPanel = Box.createVerticalBox();
        queryWrapPanel.setBorder(BorderFactory.createTitledBorder("Query Wrapping"));
        String wrapTooltip = "Any queries sent to a kdb server will be wrapped with these pre/postfixes.";
        this.queryWrapPreTextField = new JTextField(20);
        this.queryWrapPostTextField = new JTextField(20);
        queryWrapPanel.add(Theme.getFormRow(this.queryWrapPreTextField, "Prefix:", wrapTooltip));
        queryWrapPanel.add(Theme.getFormRow(this.queryWrapPostTextField, "Postfix:", wrapTooltip));
        panel.add(queryWrapPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "North");
        this.refresh();
    }

    @Override
    void saveSettings() {
        int max = (Integer)this.sizeLimitField.getValue();
        this.myPreferences.setMaxReturnSizeMB(max);
        this.myPreferences.setQueryWrapped(this.queryWrappedCheckBox.isSelected());
        this.myPreferences.setQueryWrapPre(this.queryWrapPreTextField.getText());
        this.myPreferences.setQueryWrapPost(this.queryWrapPostTextField.getText());
        this.myPreferences.setConnectionPersistent(this.connectionPersistentCheckBox.isSelected());
    }

    @Override
    void refresh() {
        int max = this.myPreferences.getMaxReturnSizeMB();
        this.sizeLimitField.setValue(max);
        boolean wrapped = this.myPreferences.isQueryWrapped();
        this.queryWrappedCheckBox.setSelected(wrapped);
        this.sizeLimitField.setEnabled(wrapped);
        this.queryWrapPreTextField.setText(this.myPreferences.getQueryWrapPre());
        this.queryWrapPostTextField.setText(this.myPreferences.getQueryWrapPost());
        this.connectionPersistentCheckBox.setSelected(this.myPreferences.isConnectionPersistent());
    }

    @Override
    void cancel() {
    }
}

