/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio;

import com.google.common.base.Preconditions;
import com.timestored.connections.ServerConfig;
import com.timestored.qstudio.KDBResultPanel;
import com.timestored.qstudio.kdb.KdbHelper;
import com.timestored.qstudio.model.QueryAdapter;
import com.timestored.qstudio.model.QueryManager;
import com.timestored.qstudio.model.QueryResult;
import com.timestored.theme.Theme;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.swingx.JXTable;

class QueryHistoryPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int FIXED_SIZE = 5;
    private final QueryManager queryManager;
    private final List<QueryResult> history = new LinkedList<QueryResult>();
    private final String[] colNames = new String[]{"Query", "Result", "Success"};
    private final DefaultTableModel tableModel;
    private final JPanel elementDetailPanel;
    private final JXTable table;
    private int maxRowsShown = Integer.MAX_VALUE;

    QueryHistoryPanel(QueryManager queryManager) {
        this.queryManager = queryManager;
        this.setLayout(new BorderLayout());
        this.tableModel = new DefaultTableModel(this.colNames, 0);
        this.table = Theme.getStripedTable(this.tableModel);
        this.table.setEditable(false);
        JScrollPane historyScrollPane = new JScrollPane(20, 31);
        historyScrollPane.setViewportView(this.table);
        this.elementDetailPanel = new JPanel(new BorderLayout());
        JSplitPane splitPane = new JSplitPane(1, historyScrollPane, this.elementDetailPanel);
        splitPane.setResizeWeight(0.5);
        this.add((Component)splitPane, "Center");
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                int row = QueryHistoryPanel.this.table.getSelectedRow();
                if (row >= 0 && row < QueryHistoryPanel.this.history.size()) {
                    QueryHistoryPanel.this.display(row);
                }
            }
        });
        this.table.addMouseListener(new PopupMenuMouseListener());
        queryManager.addQueryListener(new QueryAdapter(){

            @Override
            public void queryResultReturned(ServerConfig sc, QueryResult queryResult) {
                QueryHistoryPanel.this.addToHistory(queryResult);
                QueryHistoryPanel.this.display(QueryHistoryPanel.this.history.size() - 1);
            }
        });
    }

    private void display(int row) {
        final Component c2 = KDBResultPanel.getComponent(this.history.get(row), this.maxRowsShown, this.queryManager, false);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                QueryHistoryPanel.this.elementDetailPanel.removeAll();
                QueryHistoryPanel.this.elementDetailPanel.add(c2, "Center");
                QueryHistoryPanel.this.elementDetailPanel.revalidate();
            }
        });
    }

    private void addToHistory(QueryResult qr) {
        if (this.history.size() == 5) {
            this.history.remove(0);
        }
        this.history.add(qr);
        if (this.tableModel.getRowCount() == 5) {
            this.tableModel.removeRow(0);
        }
        Object[] rowData = new String[]{qr.query, KdbHelper.asLine(qr.k), qr.getResultType()};
        this.tableModel.addRow(rowData);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                QueryHistoryPanel.this.table.scrollRectToVisible(QueryHistoryPanel.this.table.getCellRect(QueryHistoryPanel.this.table.getRowCount() - 1, 0, true));
            }
        });
    }

    void setMaximumRowsShown(int maxRowsShown) {
        Preconditions.checkArgument(maxRowsShown > 0);
        this.maxRowsShown = maxRowsShown;
    }

    private class PopupMenuMouseListener
    extends MouseAdapter {
        private PopupMenuMouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            int r = QueryHistoryPanel.this.table.rowAtPoint(e.getPoint());
            if (r >= 0 && r < QueryHistoryPanel.this.table.getRowCount()) {
                QueryHistoryPanel.this.table.setRowSelectionInterval(r, r);
            } else {
                QueryHistoryPanel.this.table.clearSelection();
            }
            final int row = QueryHistoryPanel.this.table.getSelectedRow();
            if (e.isPopupTrigger() && row >= 0 && row < QueryHistoryPanel.this.history.size()) {
                JPopupMenu popup = new JPopupMenu();
                JMenuItem resendExp = new JMenuItem("Resend", Theme.CIcon.SERVER_GO.get16());
                resendExp.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        QueryHistoryPanel.this.queryManager.sendQuery(((QueryResult)((QueryHistoryPanel)QueryHistoryPanel.this).history.get((int)row)).query);
                    }
                });
                JMenuItem copyToClipboardButton = new JMenuItem("Copy Query to Clipboard", Theme.CIcon.EDIT_COPY.get16());
                copyToClipboardButton.addActionListener(ev -> {
                    Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clpbrd.setContents(new StringSelection(((QueryResult)((QueryHistoryPanel)QueryHistoryPanel.this).history.get((int)row)).query), null);
                });
                popup.add(resendExp);
                popup.add(copyToClipboardButton);
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int row = QueryHistoryPanel.this.table.getSelectedRow();
            if (e.getClickCount() == 2 && row >= 0 && row < QueryHistoryPanel.this.history.size()) {
                QueryHistoryPanel.this.queryManager.sendQuery(((QueryResult)((QueryHistoryPanel)QueryHistoryPanel.this).history.get((int)row)).query);
            }
            super.mouseClicked(e);
        }
    }
}

