/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio;

import com.google.common.base.Preconditions;
import com.timestored.babeldb.BabelDBJdbcDriver;
import com.timestored.babeldb.Dbrunner;
import com.timestored.connections.ConnectionManager;
import com.timestored.connections.JdbcTypes;
import com.timestored.connections.ServerConfig;
import com.timestored.docs.Document;
import com.timestored.docs.OpenDocumentsModel;
import com.timestored.messages.Msg;
import com.timestored.qstudio.BackgroundExecutor;
import com.timestored.qstudio.Language;
import com.timestored.qstudio.Persistance;
import com.timestored.qstudio.UpdateHelper;
import com.timestored.qstudio.model.AdminModel;
import com.timestored.qstudio.model.QueryManager;
import java.io.File;
import java.io.IOException;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.h2.Driver;

public class QStudioModel {
    public static final String APP_TITLE = "QStudio";
    public static final String LEGACY_FOLDER_NAME = "qStudio";
    public static final File APP_HOME = new File(System.getProperty("user.home") + File.separator + "qStudio");
    static final File SCRATCH_DIR = new File(APP_HOME, "scratch");
    private final ConnectionManager connectionManager;
    private final OpenDocumentsModel openDocumentsModel;
    private final AdminModel adminModel;
    private final QueryManager queryManager;
    private final Persistance persistance;
    private static final File LOCALDB_DIR = new File(APP_HOME, "qduckdb");
    private static final Logger LOG = Logger.getLogger(QStudioModel.class.getName());
    private int queryCount = 0;
    private static final String MEMNAME = "QDUCKDB";
    private static final ServerConfig MEMDUCK = new ServerConfig("", 0, "", "", "QDUCKDB", JdbcTypes.BABELDB, null, "jdbc:babeldb:duckdb:");

    public QStudioModel(ConnectionManager connectionManager, Persistance persistance, OpenDocumentsModel openDocumentsModel) {
        this.connectionManager = Preconditions.checkNotNull(connectionManager);
        this.persistance = Preconditions.checkNotNull(persistance);
        this.openDocumentsModel = Preconditions.checkNotNull(openDocumentsModel);
        this.queryManager = new QueryManager(connectionManager);
        SCRATCH_DIR.mkdirs();
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException e) {
            LOG.warning("Couldn't reg H2");
        }
        BabelDBJdbcDriver.setDEFAULT_DBRUNNER(new MyDbRunner(connectionManager));
        this.adminModel = new AdminModel(connectionManager, this.queryManager);
        this.queryCount = persistance.getInt(Persistance.Key.QUERY_COUNT, 0);
    }

    Language getCurrentSqlLanguage() {
        String serverName = this.queryManager.getSelectedServerName();
        ServerConfig sc = serverName == null ? null : this.connectionManager.getServer(serverName);
        Language fallbackLang = sc != null && sc.isKDB() ? Language.Q : Language.SQL;
        Language l = Language.getLanguage(this.openDocumentsModel.getSelectedDocument().getFileEnding());
        return l.equals((Object)Language.MARKDOWN) || l.equals((Object)Language.OTHER) ? fallbackLang : l;
    }

    String[] getFileEndings() {
        String[] qFirst = new String[]{"q", "sql", "prql"};
        String[] sqlFirst = new String[]{"sql", "q", "prql"};
        String[] prqlFirst = new String[]{"prql", "sql", "q"};
        String[] anyFirst = new String[]{"", "prql", "sql", "q"};
        String[] dosFirst = new String[]{"dos", "prql", "sql", "q"};
        String title = this.openDocumentsModel.getSelectedDocument().getTitle();
        if (title.endsWith(".q")) {
            return qFirst;
        }
        if (title.endsWith(".sql")) {
            return sqlFirst;
        }
        if (title.endsWith(".prql")) {
            return prqlFirst;
        }
        if (title.contains(".")) {
            return anyFirst;
        }
        if (this.connectionManager.getServerConnections().isEmpty()) {
            return qFirst;
        }
        ServerConfig sc = this.connectionManager.getServer(this.queryManager.getSelectedServerName());
        return sc != null ? (JdbcTypes.DOLPHINDB.equals((Object)sc.getJdbcType()) ? dosFirst : (sc.isKDB() ? qFirst : sqlFirst)) : qFirst;
    }

    public BabelDBJdbcDriver putIfAbsentLocalSQL() {
        LOCALDB_DIR.mkdirs();
        if (this.connectionManager.getServer(MEMNAME) == null) {
            this.connectionManager.addServer(MEMDUCK);
        }
        return BabelDBJdbcDriver.getDriverIfExists(MEMDUCK.getUrl());
    }

    public void loadExistingParquet() throws SQLException {
        if (this.connectionManager.getServer(MEMNAME) == null) {
            return;
        }
        BabelDBJdbcDriver babelDuck = this.putIfAbsentLocalSQL();
        babelDuck.loadExistingParquet(LOCALDB_DIR);
    }

    void addDataFiles(List<File> dataFiles) {
        UpdateHelper.registerEvent("qsm_adddata");
        if (dataFiles.size() == 0) {
            return;
        }
        this.putIfAbsentLocalSQL();
        StringBuilder pubQry = new StringBuilder();
        pubQry.append("\n");
        String name = null;
        for (File dfile : dataFiles) {
            name = BabelDBJdbcDriver.getTblName(dfile);
            pubQry.append("SELECT * FROM " + name + " LIMIT 111000;\n");
        }
        pubQry.append("\n\n-- Press F7 on the comment line below to use AI to generate queries");
        pubQry.append("\n-- Generate 5 example queries for the table " + name + ". Include a simple select, a count and 3 more advanced queries.");
        this.queryManager.setSelectedServerName(MEMNAME);
        String docTitle = dataFiles.size() == 1 && name != null ? name + ".sql" : null;
        Document selDoc = this.openDocumentsModel.addDocument(docTitle);
        this.openDocumentsModel.setSelectedDocument(selDoc);
        String code = BabelDBJdbcDriver.getReplaceView(dataFiles) + pubQry.toString();
        this.openDocumentsModel.insertSelectedText(code);
        this.queryManager.sendQuery(code);
        BackgroundExecutor.EXECUTOR.execute(() -> this.adminModel.refresh(this.connectionManager.getServer(MEMNAME)));
    }

    void addDBfiles(List<File> dbFiles) {
        if (dbFiles.size() == 0) {
            return;
        }
        ServerConfig sc = null;
        for (File dbFile : dbFiles) {
            String db = dbFile.getAbsolutePath();
            try {
                sc = ServerConfig.forFile(db);
                this.connectionManager.addServer(sc);
            }
            catch (IOException ioe) {
                String msg = Msg.get(Msg.Key.ERROR_SAVING) + ": " + db + "\r\n" + ioe.toString();
                LOG.warning(msg);
                JOptionPane.showMessageDialog(null, msg, "Error Adding Database from File " + db, 0);
            }
        }
        if (sc != null) {
            this.queryManager.setSelectedServerName(sc.getName());
            Document selDoc = this.openDocumentsModel.addDocument();
            this.openDocumentsModel.setSelectedDocument(selDoc);
            StringBuilder sb = new StringBuilder();
            sb.append(sc.getJdbcType().getComment() + " Database:" + sc.getShortName());
            sb.append("\n");
            sb.append("\n-- Press F7 on the comment line below to use AI to generate queries");
            sb.append("\n-- Generate 5 example queries. Include a simple select, a count and 3 more advanced queries.");
            String code = sb.toString();
            this.openDocumentsModel.insertSelectedText(code);
        }
        UpdateHelper.registerEvent("qsm_adddbfiles");
    }

    public File saveToQDuckDB(ResultSet rs2, String name) throws SQLException {
        UpdateHelper.registerEvent("qsm_savetoduck");
        BabelDBJdbcDriver babelDuck = this.putIfAbsentLocalSQL();
        if (babelDuck != null) {
            babelDuck.dropCreatePopulate(rs2, "exportTbl");
            File f = new File(LOCALDB_DIR, name + ".parquet");
            babelDuck.run("COPY exportTbl TO '" + f.getAbsolutePath() + "' (FORMAT PARQUET);");
            babelDuck.run("CREATE OR REPLACE VIEW " + name + " AS SELECT * FROM read_parquet('" + f.getAbsolutePath() + "');");
            return f;
        }
        return null;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public OpenDocumentsModel getOpenDocumentsModel() {
        return this.openDocumentsModel;
    }

    public AdminModel getAdminModel() {
        return this.adminModel;
    }

    public QueryManager getQueryManager() {
        return this.queryManager;
    }

    public Persistance getPersistance() {
        return this.persistance;
    }

    public int getQueryCount() {
        return this.queryCount;
    }

    public void setQueryCount(int queryCount) {
        this.queryCount = queryCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QStudioModel)) {
            return false;
        }
        QStudioModel other = (QStudioModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getQueryCount() != other.getQueryCount()) {
            return false;
        }
        ConnectionManager this$connectionManager = this.getConnectionManager();
        ConnectionManager other$connectionManager = other.getConnectionManager();
        if (this$connectionManager == null ? other$connectionManager != null : !this$connectionManager.equals(other$connectionManager)) {
            return false;
        }
        OpenDocumentsModel this$openDocumentsModel = this.getOpenDocumentsModel();
        OpenDocumentsModel other$openDocumentsModel = other.getOpenDocumentsModel();
        if (this$openDocumentsModel == null ? other$openDocumentsModel != null : !this$openDocumentsModel.equals(other$openDocumentsModel)) {
            return false;
        }
        AdminModel this$adminModel = this.getAdminModel();
        AdminModel other$adminModel = other.getAdminModel();
        if (this$adminModel == null ? other$adminModel != null : !this$adminModel.equals(other$adminModel)) {
            return false;
        }
        QueryManager this$queryManager = this.getQueryManager();
        QueryManager other$queryManager = other.getQueryManager();
        if (this$queryManager == null ? other$queryManager != null : !this$queryManager.equals(other$queryManager)) {
            return false;
        }
        Persistance this$persistance = this.getPersistance();
        Persistance other$persistance = other.getPersistance();
        return !(this$persistance == null ? other$persistance != null : !this$persistance.equals(other$persistance));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QStudioModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getQueryCount();
        ConnectionManager $connectionManager = this.getConnectionManager();
        result = result * 59 + ($connectionManager == null ? 43 : $connectionManager.hashCode());
        OpenDocumentsModel $openDocumentsModel = this.getOpenDocumentsModel();
        result = result * 59 + ($openDocumentsModel == null ? 43 : $openDocumentsModel.hashCode());
        AdminModel $adminModel = this.getAdminModel();
        result = result * 59 + ($adminModel == null ? 43 : $adminModel.hashCode());
        QueryManager $queryManager = this.getQueryManager();
        result = result * 59 + ($queryManager == null ? 43 : $queryManager.hashCode());
        Persistance $persistance = this.getPersistance();
        result = result * 59 + ($persistance == null ? 43 : $persistance.hashCode());
        return result;
    }

    public String toString() {
        return "QStudioModel(connectionManager=" + this.getConnectionManager() + ", openDocumentsModel=" + this.getOpenDocumentsModel() + ", adminModel=" + this.getAdminModel() + ", queryManager=" + this.getQueryManager() + ", persistance=" + this.getPersistance() + ", queryCount=" + this.getQueryCount() + ")";
    }

    public static File getLOCALDB_DIR() {
        return LOCALDB_DIR;
    }

    private static class MyDbRunner
    implements Dbrunner {
        private final ConnectionManager connectionManager;

        @Override
        public ResultSet executeQry(String serverName, String sql, int millisStalenessPermitted) throws IOException {
            try {
                return this.connectionManager.executeQuery(this.connectionManager.getServer(serverName), sql);
            }
            catch (IOException | SQLException e) {
                throw new IOException(e);
            }
        }

        @Override
        public List<String> getServerWithSymbols() {
            return Collections.emptyList();
        }

        @Override
        public ServerConfig getServer(String serverName) {
            return this.connectionManager.getServer(serverName);
        }

        @Override
        public boolean isEmpty() {
            return this.connectionManager.isEmpty();
        }

        @Override
        public void close() {
        }

        public MyDbRunner(ConnectionManager connectionManager) {
            this.connectionManager = connectionManager;
        }
    }
}

