/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio;

import com.timestored.TimeStored;
import com.timestored.connections.ConnectionManager;
import com.timestored.docs.OpenDocumentsModel;
import com.timestored.misc.AppLaunchHelper;
import com.timestored.misc.ErrorReporter;
import com.timestored.plugins.PluginLoader;
import com.timestored.qstudio.FlatDesktop;
import com.timestored.qstudio.MyPreferences;
import com.timestored.qstudio.Persistance;
import com.timestored.qstudio.PreferencesDialog;
import com.timestored.qstudio.QStudioFrame;
import com.timestored.qstudio.QStudioModel;
import com.timestored.sqldash.chart.JdbcChartPanel;
import com.timestored.swingxx.ApplicationInstanceListener;
import com.timestored.swingxx.ApplicationInstanceManager;
import com.timestored.swingxx.FileTreePanel;
import com.timestored.swingxx.SwingUtils;
import java.awt.EventQueue;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;

public class QStudioLauncher {
    private static QStudioFrame appFrame;
    private static final Logger LOG;
    private static final String ERR_URL;
    private static final int MINS_BETWEEN = 720;
    public static final ErrorReporter ERR_REPORTER;

    public static void main(final String ... args) throws InterruptedException, InvocationTargetException {
        int uiScale;
        boolean firstInstance = ApplicationInstanceManager.registerInstance(args);
        if (!firstInstance) {
            System.out.println("Not the first instance.");
            if (args.length > 0) {
                System.out.println("I had arguments, they were handled so EXIT.");
                return;
            }
        }
        if ((uiScale = MyPreferences.INSTANCE.getUIScale()) > 0) {
            System.setProperty("sun.java2d.uiScale", "1.0");
            System.setProperty("flatlaf.uiScale", "" + (double)uiScale / 100.0);
        }
        String title = "QStudio";
        URL imageUrl = QStudioLauncher.class.getResource("qstudio-dock.png");
        BufferedImage image = null;
        if (imageUrl != null) {
            try {
                image = ImageIO.read(imageUrl);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        AppLaunchHelper.setMacAndWindowsAppearance(title, image);
        ApplicationInstanceManager.setApplicationInstanceListener(new ApplicationInstanceListener(){

            @Override
            public void newInstanceCreated(List<String> args) {
                System.out.println("New instance detected...");
                if (args.size() > 0 && appFrame != null) {
                    appFrame.handleArgs(args);
                    EventQueue.invokeLater(() -> SwingUtils.forceToFront(appFrame));
                }
            }
        });
        try {
            boolean bl = PluginLoader.loadPlugins("QStudio".toLowerCase());
        }
        catch (Throwable ucve) {
            LOG.severe("Could not load a plugin due to " + ucve.getLocalizedMessage());
        }
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                this.launch(args);
            }

            private void launch(String ... args2) {
                OpenDocumentsModel openDocumentsModel = OpenDocumentsModel.newInstance();
                Persistance persistance = Persistance.INSTANCE;
                long firstEverRun = persistance.getLong(Persistance.Key.FERDB, -1L);
                if (firstEverRun == -1L) {
                    firstEverRun = System.currentTimeMillis();
                    persistance.putLong(Persistance.Key.FERDB, firstEverRun);
                }
                AppLaunchHelper.setTheme(MyPreferences.INSTANCE.getCodeTheme());
                AppLaunchHelper.logToUsersFolder("qStudio");
                LOG.info("Starting QStudioLauncher  launch() ###################################");
                LOG.info("version = 4.07");
                LOG.info("current dir = " + new File(".").getAbsolutePath());
                LOG.info("PATH = " + System.getenv("PATH"));
                LOG.info("JAVA_HOME = " + System.getenv("JAVA_HOME"));
                LOG.info("java.version =" + System.getProperty("java.version"));
                LOG.info("os.name =" + System.getProperty("os.name"));
                LOG.info("user.home =" + System.getProperty("user.home"));
                LOG.info("user.dir =" + System.getProperty("user.dir"));
                Thread.setDefaultUncaughtExceptionHandler(ERR_REPORTER.getUncaughtExceptionHandler());
                JdbcChartPanel.TEST_MODE = false;
                FileTreePanel.TEST_MODE = false;
                ConnectionManager conMan = ConnectionManager.newInstance();
                MyPreferences my = MyPreferences.INSTANCE;
                String u = my.getDefaultLoginUsername();
                String p = my.getDefaultLoginPassword();
                if (u != null || p != null) {
                    conMan.setDefaultLogin(u, p);
                }
                conMan.setPreferenceStore(persistance.getPref(), Persistance.Key.CONNECTIONS.name());
                QStudioModel qStudioModel = new QStudioModel(conMan, persistance, openDocumentsModel);
                try {
                    Class<?> clazz = Class.forName("com.timestored.pro.kdb.PluginInitialiser");
                    clazz.getDeclaredMethod("init", QStudioModel.class).invoke(null, qStudioModel);
                }
                catch (Throwable ucve) {
                    LOG.severe("Could not load a plugin due to " + ucve.getLocalizedMessage());
                }
                appFrame = new QStudioFrame(qStudioModel);
                if (System.getProperty("os.name").toLowerCase().indexOf("mac") >= 0) {
                    FlatDesktop.setAboutHandler(() -> QStudioFrame.showAboutDialog(appFrame));
                    FlatDesktop.setPreferencesHandler(() -> new PreferencesDialog(MyPreferences.INSTANCE, appFrame));
                    FlatDesktop.setQuitHandler(response -> response.performQuit());
                }
                appFrame.setVisible(true);
                appFrame.handleArgs(Arrays.asList(args2));
                LOG.info("Ending QStudioLauncher launch()");
            }
        });
    }

    static {
        LOG = Logger.getLogger(QStudioLauncher.class.getName());
        ERR_URL = TimeStored.getContactUrl("qStudio Error Report");
        ERR_REPORTER = new ErrorReporter(ERR_URL, "tech@timestored.com", "qStudio Bug Report 4.07", 720);
    }
}

