/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio;

import bibliothek.gui.DockController;
import bibliothek.gui.DockFrontend;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DefaultDockable;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.action.DefaultDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.actions.SimpleButtonAction;
import bibliothek.gui.dock.station.split.DockableSplitDockTree;
import bibliothek.gui.dock.station.split.SplitDockTree;
import com.formdev.flatlaf.fonts.jetbrains_mono.FlatJetBrainsMonoFont;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.timestored.StringUtils;
import com.timestored.TimeStored;
import com.timestored.babeldb.DBHelper;
import com.timestored.command.CodeSnippetCommandProvider;
import com.timestored.command.CommandDialog;
import com.timestored.command.CommandManager;
import com.timestored.command.CommandProvider;
import com.timestored.connections.ConnectionManager;
import com.timestored.connections.ConnectionManagerDialog;
import com.timestored.connections.LoginDialog;
import com.timestored.connections.ServerConfig;
import com.timestored.docs.BackgroundDocumentsSaver;
import com.timestored.docs.Document;
import com.timestored.docs.DocumentActions;
import com.timestored.docs.FileDropDocumentHandler;
import com.timestored.docs.OpenDocumentsModel;
import com.timestored.docs.RecentDocumentPersister;
import com.timestored.jgrowl.Growler;
import com.timestored.jgrowl.GrowlerFactory;
import com.timestored.messages.Msg;
import com.timestored.misc.AIFacade;
import com.timestored.misc.AppLaunchHelper;
import com.timestored.misc.HtmlUtils;
import com.timestored.misc.IOUtils;
import com.timestored.qstudio.BackgroundExecutor;
import com.timestored.qstudio.ChartResultPanel;
import com.timestored.qstudio.CommonActions;
import com.timestored.qstudio.ConsolePanel;
import com.timestored.qstudio.EditorConfigFactory;
import com.timestored.qstudio.GenerateDocumentationAction;
import com.timestored.qstudio.GrabItem;
import com.timestored.qstudio.GrabableContainer;
import com.timestored.qstudio.KDBResultPanel;
import com.timestored.qstudio.Language;
import com.timestored.qstudio.MyPreferences;
import com.timestored.qstudio.Persistance;
import com.timestored.qstudio.PreferencesDialog;
import com.timestored.qstudio.QDocController;
import com.timestored.qstudio.QStudioModel;
import com.timestored.qstudio.QueryHistoryPanel;
import com.timestored.qstudio.ServerDocumentPanel;
import com.timestored.qstudio.ServerNameComboBox;
import com.timestored.qstudio.UpdateHelper;
import com.timestored.qstudio.WelcomeDialog;
import com.timestored.qstudio.kdb.KdbHelper;
import com.timestored.qstudio.model.AdminModel;
import com.timestored.qstudio.model.QEntity;
import com.timestored.qstudio.model.QueryAdapter;
import com.timestored.qstudio.model.QueryManager;
import com.timestored.qstudio.model.QueryResult;
import com.timestored.qstudio.model.ServerModel;
import com.timestored.qstudio.servertree.PagingTablePanel;
import com.timestored.qstudio.servertree.ServerTreePanel;
import com.timestored.sqldash.chart.ChartTheme;
import com.timestored.sqldash.chart.TableFactory;
import com.timestored.sqldash.chart.ViewStrategyFactory;
import com.timestored.swingxx.AAction;
import com.timestored.swingxx.DockerHelper;
import com.timestored.swingxx.FileOpenCommandProvider;
import com.timestored.swingxx.FileTreePanel;
import com.timestored.swingxx.JToolBarWithBetterTooltips;
import com.timestored.swingxx.QueryStatusBar;
import com.timestored.swingxx.SwingUtils;
import com.timestored.swingxx.TableExporter;
import com.timestored.swingxx.ToggleDockableMenuItem;
import com.timestored.theme.AboutDialog;
import com.timestored.theme.Icon;
import com.timestored.theme.ShortcutAction;
import com.timestored.theme.Theme;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import lombok.NonNull;

public class QStudioFrame
extends JFrame {
    private static final String KDB_EXAMPLE_FILE = "kdb-examples.q";
    private static final String FIRST_OPEN_FILE = "firstOpen.bat";
    private static final Logger LOG = Logger.getLogger(QStudioFrame.class.getName());
    private static QStudioFramePlugin<Action> helpMenuPlugin = (a, b, c2) -> Collections.emptyList();
    private static QStudioFramePlugin<JButton> toolbarPlugin = (a, b, c2) -> Collections.emptyList();
    private static QStudioFramePlugin<Action> toolsMenuPlugin = (a, b, c2) -> Collections.emptyList();
    private static final int SERVER_NAME_WIDTH = 190;
    private static final long serialVersionUID = 1L;
    private static final String UNIQUE_ID = "UNIQ_ID";
    public static final String VERSION = "4.07";
    private final QStudioModel qStudioModel;
    private final ConnectionManager conMan;
    private final OpenDocumentsModel openDocsModel;
    private final QueryManager queryManager;
    private final Persistance persistance;
    private final DockFrontend frontend;
    private final AdminModel adminModel;
    private final KDBResultPanel kdbResultPanel;
    private final MyPreferences myPreferences;
    private final ServerTreePanel sTreePanel;
    private final QueryHistoryPanel queryHistorypanel;
    private final FileTreePanel fileTreePanel;
    private final ConsolePanel consolePanel;
    private final Growler growler;
    private final CommandManager commandManager;
    private final DocumentActions documentActions;
    private final ChartResultPanel chartResultPanel;
    private final ServerDocumentPanel serverDocumentPanel;
    private final CommonActions commonActions;
    private final QDocController qDocController;
    private RecentDocumentPersister recentDocumentPersister;
    private BackgroundDocumentsSaver backgroundDocsSaver;
    private JMenu fileMenu;
    private String defaultLayoutXml = "";
    private int queryCount = 0;
    private final Color defaultFrameColor;
    private SimpleButtonAction xlsButton;
    private SimpleButtonAction pivotButton;
    private SimpleButtonAction saveToDuckButton;
    private SimpleButtonAction emailButton;
    private QueryResult lastQueryResult;
    private final AbstractAction commandPaletteAction;
    private ShortcutAction openFilesAction;

    public QStudioFrame(final QStudioModel qStudioModel) {
        boolean isDarkTheme;
        this.qStudioModel = qStudioModel;
        LOG.info("Starting QStudioFrame Constructor");
        long startT = System.nanoTime();
        long prevT = System.nanoTime();
        this.conMan = Preconditions.checkNotNull(qStudioModel.getConnectionManager());
        this.openDocsModel = Preconditions.checkNotNull(qStudioModel.getOpenDocumentsModel());
        this.adminModel = Preconditions.checkNotNull(qStudioModel.getAdminModel());
        this.queryManager = Preconditions.checkNotNull(qStudioModel.getQueryManager());
        this.persistance = qStudioModel.getPersistance();
        this.commandManager = new CommandManager();
        final boolean firstEverOpen = this.persistance.getBoolean(Persistance.Key.FIRST_OPEN, true);
        if (firstEverOpen) {
            this.persistance.putBoolean(Persistance.Key.FIRST_OPEN, false);
        }
        long nextT = System.nanoTime();
        System.out.println("MODELS = " + (double)(nextT - prevT) / 1000000.0);
        prevT = nextT;
        GenerateDocumentationAction docGen = new GenerateDocumentationAction(this.openDocsModel);
        this.documentActions = new DocumentActions(this.openDocsModel, () -> qStudioModel.getFileEndings(), docGen);
        FileDropDocumentHandler myTransferHandler = new FileDropDocumentHandler().addListener(files -> this.handleArgsFiles(files));
        this.setTransferHandler(myTransferHandler);
        this.growler = GrowlerFactory.getGrowler(this);
        this.commonActions = new CommonActions(qStudioModel, this, this.persistance, this.growler);
        this.openDocsModel.addListener(new OpenDocumentsModel.Adapter(){

            @Override
            public void docSelected(Document document) {
                QStudioFrame.this.setFrameTitle();
            }
        });
        this.setTitle("QStudio");
        this.setLayout(new BorderLayout(4, 4));
        this.restoreBounds(this.persistance);
        this.queryCount = this.persistance.getInt(Persistance.Key.QUERY_COUNT, 0);
        this.setDefaultCloseOperation(3);
        this.setIconImage(Theme.CIcon.QSTUDIO_LOGO.get().getImage());
        this.openDocsModel.forceKeyboardShortcutOverrides();
        this.myPreferences = MyPreferences.INSTANCE;
        this.defaultFrameColor = this.getContentPane().getBackground();
        this.setFrameColor();
        this.setVisible(true);
        this.queryManager.addQueryListener(new QueryAdapter(){

            @Override
            public void selectedServerChanged(String server) {
                QStudioFrame.this.setFrameTitle();
                QStudioFrame.this.setFrameColor();
            }

            @Override
            public void queryResultReturned(ServerConfig sc, QueryResult queryResult) {
                if (queryResult.e != null && queryResult.e.toString().contains("ClassNotFoundException")) {
                    ConnectionManagerDialog.offerToInstallDriver(sc.getJdbcType(), QStudioFrame.this);
                }
                QStudioFrame.this.setLastQueryResult(queryResult);
            }
        });
        this.adminModel.addListener(new AdminModel.Listener(){

            @Override
            public void selectionChanged(ServerModel serverModel, AdminModel.Category category, String namespace, QEntity element) {
                QStudioFrame.this.setLastQueryResult(null);
            }

            @Override
            public void modelChanged() {
            }

            @Override
            public void modelChanged(ServerModel sm) {
            }
        });
        DockController.disableCoreWarning();
        this.frontend = new DockFrontend(this);
        SplitDockStation station = new SplitDockStation();
        this.frontend.addRoot(UNIQUE_ID, station);
        this.frontend.setShowHideAction(true);
        if (this.myPreferences.getCodeFont().toLowerCase().contains("jetbrains")) {
            FlatJetBrainsMonoFont.install();
        }
        EditorConfigFactory.TCOLOR tcolor = (isDarkTheme = AppLaunchHelper.isLafDark(MyPreferences.INSTANCE.getCodeTheme())) ? EditorConfigFactory.TCOLOR.DARK : EditorConfigFactory.TCOLOR.LIGHT;
        ServerDocumentPanel.setEditorConfig(EditorConfigFactory.get(tcolor));
        this.qDocController = new QDocController(qStudioModel);
        this.serverDocumentPanel = new ServerDocumentPanel(this.commonActions, this.documentActions, this.openDocsModel, this, this.qDocController, files -> this.handleArgsFiles(files));
        this.serverDocumentPanel.setEditorFont(this.myPreferences.getCodeFontFont());
        this.serverDocumentPanel.setAssumedFileEnding(this.conMan.isEmpty() || this.conMan.containsKdbServer() ? "q" : "sql");
        ActionMap am = this.getRootPane().getActionMap();
        InputMap im = this.getRootPane().getInputMap(1);
        this.queryManager.addQueryListener(new QueryAdapter(){

            @Override
            public void selectedServerChanged(String server) {
                ServerConfig sc;
                String fileEnding;
                String string = fileEnding = QStudioFrame.this.conMan.isEmpty() || QStudioFrame.this.conMan.containsKdbServer() ? "q" : "sql";
                if (server != null && (sc = QStudioFrame.this.conMan.getServer(server)) != null) {
                    fileEnding = sc.isKDB() ? "q" : "sql";
                }
                QStudioFrame.this.serverDocumentPanel.setAssumedFileEnding(fileEnding);
            }
        });
        DefaultDockable documentsDockable = this.createDockable(Msg.get(Msg.Key.DOCUMENTS), Theme.CIcon.PAGE_CODE, this.serverDocumentPanel, null);
        this.kdbResultPanel = new KDBResultPanel(this.adminModel, this.queryManager);
        this.kdbResultPanel.setTransferHandler(myTransferHandler);
        ActionListener refreshResendQueryAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                QStudioFrame.this.queryManager.resendLastQuery();
            }
        };
        this.pivotButton = QStudioFrame.makeButton("Pulse Pivot", Theme.CIcon.TABLE_PIVOT, ae -> this.kdbResultPanel.togglePivotFormVisible());
        DefaultDockActionSource actions = new DefaultDockActionSource(new DockAction[0]);
        this.xlsButton = QStudioFrame.makeButton("Export to Excel", Theme.CIcon.XLSX, ae -> {
            if (this.lastQueryResult != null && this.lastQueryResult.rs != null) {
                TableExporter.saveToExcelAndOpen(this.lastQueryResult.rs, this.lastQueryResult.query, new TableFactory.KdbStringValuer());
            }
        });
        this.emailButton = QStudioFrame.makeButton("Send Excel Attachment", Theme.CIcon.EMAIL_ATTACH, ae -> {
            if (this.lastQueryResult != null && this.lastQueryResult.rs != null) {
                TableExporter.emailExcelForUser(this.lastQueryResult.rs, this.lastQueryResult.query, new TableFactory.KdbStringValuer());
            }
        });
        this.saveToDuckButton = QStudioFrame.makeButton("Export to QDuckDB Table", Theme.CIcon.DUCK, ae -> {
            if (this.lastQueryResult != null && this.lastQueryResult.rs != null) {
                try {
                    String name = JOptionPane.showInputDialog(this, "Enter table name", "tbl");
                    if (name != null) {
                        File f = qStudioModel.saveToQDuckDB(this.lastQueryResult.rs, name);
                        if (f == null) {
                            this.growler.showSevere("QDuckDB failed to init.", "QDuckDB failed.");
                        } else {
                            this.growler.show("Saved to: " + f.getAbsolutePath(), "File Saved");
                        }
                    }
                }
                catch (Exception e) {
                    String msg = "Error saving file: ";
                    LOG.log(Level.SEVERE, msg, e);
                    JTextArea errTA = Theme.getTextArea("msg", e.getMessage());
                    JScrollPane sp = new JScrollPane(errTA);
                    sp.setPreferredSize(new Dimension(400, 300));
                    JOptionPane.showMessageDialog(null, sp, "Error Saving", 0);
                }
            }
        });
        actions.add(this.pivotButton);
        actions.add(this.xlsButton);
        actions.add(this.emailButton);
        actions.add(this.saveToDuckButton);
        this.setLastQueryResult(null);
        DefaultDockable kdbResDockable = this.createDockable(Msg.get(Msg.Key.RESULT), Theme.CIcon.TAB_GO, this.kdbResultPanel, refreshResendQueryAL, actions);
        this.fileTreePanel = QStudioFrame.getFileTreePanel(this.openDocsModel, this.documentActions);
        this.fileTreePanel.addListener(selectedFile -> {
            if (!selectedFile.isDirectory()) {
                FileTreePanel.openFileOrBrowseTo(selectedFile, fl -> this.handleArgsFiles((File)fl));
                UpdateHelper.registerEvent("filetree-openfile");
            }
        });
        DefaultDockable fileTreeDockable = this.createDockable(Msg.get(Msg.Key.FILE_TREE), Theme.CIcon.DOCUMENT_OPEN, this.fileTreePanel, ae -> this.fileTreePanel.refreshGui());
        this.consolePanel = new ConsolePanel();
        this.consolePanel.setCodeFont(this.myPreferences.getCodeFontFont());
        this.queryManager.addQueryListener(this.consolePanel);
        DefaultDockable consoleDockable = this.createDockable(Msg.get(Msg.Key.CONSOLE), Theme.CIcon.TERMINAL, this.consolePanel, refreshResendQueryAL);
        this.sTreePanel = new ServerTreePanel(qStudioModel, this.commonActions, this);
        this.sTreePanel.setTransferHandler(myTransferHandler);
        ActionListener refreshAL = ae -> BackgroundExecutor.EXECUTOR.execute(() -> this.adminModel.refresh());
        DefaultDockable serverTreeDockable = this.createDockable(Msg.get(Msg.Key.SERVER_TREE), Theme.CIcon.SERVER, this.sTreePanel, refreshAL);
        this.chartResultPanel = new ChartResultPanel(this.queryManager, this.growler);
        ChartTheme chartTheme = isDarkTheme ? ViewStrategyFactory.DARK_THEME : ViewStrategyFactory.LIGHT_THEME;
        this.chartResultPanel.setChartTheme(chartTheme);
        DefaultDockable chartDockable = this.createDockable(Msg.get(Msg.Key.CHART), Theme.CIcon.CHART_CURVE, this.chartResultPanel, refreshResendQueryAL);
        this.queryHistorypanel = new QueryHistoryPanel(this.queryManager);
        DefaultDockable historyDockable = this.createDockable(Msg.get(Msg.Key.HISTORY), Theme.CIcon.TABLE_MULTIPLE, this.queryHistorypanel, refreshResendQueryAL);
        this.commandManager.registerProvider(this.commonActions);
        this.commandManager.registerProvider(new FileOpenCommandProvider(this.documentActions, this.fileTreePanel, file -> this.handleArgsFiles((File)file)));
        this.commandManager.registerProvider(Language.Q.name(), new CodeSnippetCommandProvider(this.openDocsModel, this.queryManager));
        this.commandManager.registerProvider(this.queryManager);
        this.qDocController.registerCommandProviders(this.commandManager, this.kdbResultPanel);
        this.commandPaletteAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CommandProvider cp = () -> QStudioFrame.this.commandManager.getCommands(qStudioModel.getCurrentSqlLanguage().name());
                CommandDialog cd = new CommandDialog("", cp, BackgroundExecutor.EXECUTOR);
                cd.setPreferredSize(new Dimension(600, 400));
                cd.setMinimumSize(new Dimension(600, 400));
                cd.setLocationRelativeTo(QStudioFrame.this);
                cd.setVisible(true);
                UpdateHelper.registerEvent("qsf_commandbar");
            }
        };
        KeyStroke COMMAND_PALETTE_KS = KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        am.put("commandPalette", this.commandPaletteAction);
        im.put(COMMAND_PALETTE_KS, "commandPalette");
        this.myPreferences.addListener(() -> this.pushPreferencesToModels());
        this.pushPreferencesToModels();
        DockableSplitDockTree tree = new DockableSplitDockTree();
        SplitDockTree.Key docsGroup = tree.put((D[])new Dockable[]{documentsDockable}, documentsDockable);
        SplitDockTree.Key resultsGroup = tree.put((D[])new Dockable[]{kdbResDockable, chartDockable, historyDockable, consoleDockable}, kdbResDockable);
        SplitDockTree.Key rightSide = tree.vertical(docsGroup, resultsGroup, 0.55);
        SplitDockTree.Key leftSide = tree.vertical(serverTreeDockable, fileTreeDockable, 0.6);
        SplitDockTree.Key root = tree.horizontal(leftSide, rightSide, 0.2);
        tree.root(root);
        station.dropTree(tree);
        JMenuBar menuBar = this.getBasicMenuBar(this.commonActions, this.documentActions);
        JMenu panelsMenu = QStudioFrame.getJMenu(Msg.get(Msg.Key.WINDOWS), 87);
        panelsMenu.add(new ToggleDockableMenuItem(documentsDockable, this.frontend, "wDocsMenuItem"));
        panelsMenu.add(new ToggleDockableMenuItem(serverTreeDockable, this.frontend, "wSTreeMenuItem"));
        panelsMenu.add(new ToggleDockableMenuItem(fileTreeDockable, this.frontend, "wFileTreeMenuItem"));
        panelsMenu.add(new ToggleDockableMenuItem(consoleDockable, this.frontend, "wConsoleMenuItem"));
        panelsMenu.add(new ToggleDockableMenuItem(kdbResDockable, this.frontend, "wKdbResMenuItem"));
        panelsMenu.add(new ToggleDockableMenuItem(chartDockable, this.frontend, "wChartMenuItem"));
        panelsMenu.add(new ToggleDockableMenuItem(historyDockable, this.frontend, "wHistoryMenuItem"));
        panelsMenu.addSeparator();
        panelsMenu.add(new AAction("Restore Default Layout", ae -> DockerHelper.loadLayout(this.defaultLayoutXml, this.frontend)));
        menuBar.add(panelsMenu);
        menuBar.add(this.getHelpMenu());
        menuBar.setName("qStudiomenuBar");
        this.setJMenuBar(menuBar);
        this.openFilesAction = new ShortcutAction(Msg.get(Msg.Key.OPEN_FILE) + "...", Theme.CIcon.DOCUMENT_OPEN, 79){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                File lastSelection = QStudioFrame.this.documentActions.getLastSelectedOpenFileFolder();
                JFileChooser fc = lastSelection != null ? new JFileChooser(lastSelection) : new JFileChooser();
                fc.setMultiSelectionEnabled(true);
                if (fc.showOpenDialog(null) == 0) {
                    QStudioFrame.this.handleArgsFiles(Arrays.asList(fc.getSelectedFiles()));
                } else {
                    LOG.info(Msg.get(Msg.Key.OPEN_CANCELLED));
                }
            }
        };
        this.rebuildFileMenu();
        this.add((Component)this.getToolbar(this.commonActions, this.queryManager, this.documentActions), "North");
        this.add((Component)station, "Center");
        this.add((Component)QStudioFrame.getStatusBar(this.queryManager), "South");
        this.defaultLayoutXml = DockerHelper.getLayout(this.frontend);
        DockerHelper.loadLayout(this.persistance.get(Persistance.Key.WINDOW_POSITIONS, ""), this.frontend);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                QStudioFrame.this.backgroundDocsSaver.shutdownNow();
                QStudioFrame.this.backgroundDocsSaver.saveDocumentsScratch();
                QStudioFrame.this.persistance.put(Persistance.Key.WINDOW_POSITIONS, DockerHelper.getLayout(QStudioFrame.this.frontend));
                Rectangle r = QStudioFrame.this.getBounds();
                QStudioFrame.this.persistance.putInt(Persistance.Key.FRAME_X, (int)r.getX());
                QStudioFrame.this.persistance.putInt(Persistance.Key.FRAME_Y, (int)r.getY());
                QStudioFrame.this.persistance.putInt(Persistance.Key.FRAME_WIDTH, QStudioFrame.this.getWidth());
                QStudioFrame.this.persistance.putInt(Persistance.Key.FRAME_HEIGHT, QStudioFrame.this.getHeight());
                QStudioFrame.this.persistance.putInt(Persistance.Key.FRAME_EXTENDEDSTATE, QStudioFrame.this.getExtendedState());
                QStudioFrame.this.persistance.putInt(Persistance.Key.QUERY_COUNT, QStudioFrame.this.queryCount);
                try {
                    QStudioFrame.this.persistance.getPref().flush();
                }
                catch (BackingStoreException e1) {
                    LOG.severe("problem flushing to persistanct");
                }
                System.exit(0);
            }
        });
        this.queryManager.addQueryListener(new QueryAdapter(){

            private void setC(int c2) {
                QStudioFrame.this.setCursor(Cursor.getPredefinedCursor(c2));
            }

            @Override
            public void queryResultReturned(ServerConfig sc, QueryResult queryResult) {
                this.setC(0);
            }

            @Override
            public void sendingQuery(ServerConfig sc, String query) {
                this.setC(3);
                QStudioFrame.this.queryCount++;
                UpdateHelper.registerEvent("qsf_qry");
            }
        });
        nextT = System.nanoTime();
        System.out.println("ENDER = " + (double)(nextT - startT) / 1000000.0);
        BackgroundExecutor.EXECUTOR.execute(() -> this.adminModel.refresh());
        BackgroundExecutor.EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                QStudioFrame.this.recentDocumentPersister = new RecentDocumentPersister(QStudioFrame.this.persistance, Persistance.Key.RECENT_DOCS, Persistance.Key.LAST_OPENED_FOLDER);
                QStudioFrame.this.backgroundDocsSaver = new BackgroundDocumentsSaver(QStudioFrame.this.openDocsModel, QStudioModel.SCRATCH_DIR, 30);
                File folder = QStudioFrame.this.recentDocumentPersister.getOpenFolder(QStudioFrame.this.persistance);
                QStudioFrame.this.openDocsModel.setSelectedFolder(folder);
                if (firstEverOpen) {
                    QStudioFrame.this.openExampleFile(QStudioFrame.class, QStudioFrame.FIRST_OPEN_FILE);
                } else {
                    QStudioFrame.this.backgroundDocsSaver.restoreDocuments();
                }
                QStudioFrame.this.openDocsModel.addListener(QStudioFrame.this.recentDocumentPersister);
                QStudioFrame.this.queryManager.addQueryListener(new QueryAdapter(){

                    @Override
                    public void sendingQuery(ServerConfig sc, String query) {
                        QStudioFrame.this.backgroundDocsSaver.requestSave();
                    }
                });
                QStudioFrame.this.openDocsModel.addListener(QStudioFrame.this.backgroundDocsSaver);
                if (QStudioFrame.this.queryManager.hasAnyServers() && UpdateHelper.possiblyShowTimeStoredWebsite(QStudioFrame.this.persistance)) {
                    QStudioFrame.this.requestFocus();
                }
                if (QStudioFrame.this.conMan.getServerConnections().isEmpty()) {
                    WelcomeDialog wd = new WelcomeDialog(QStudioFrame.this, "QStudio", QStudioFrame.VERSION, QStudioFrame.this.commonActions.getAddServerAction());
                    wd.setVisible(true);
                }
                UpdateHelper.checkVersion(qStudioModel, QStudioFrame.this.queryCount, QStudioFrame.this.growler);
                QStudioFrame.this.conMan.addListener(new ConnectionManager.Adapter(){

                    @Override
                    public void serverAdded(ServerConfig sc) {
                        if (QStudioFrame.this.conMan.getServerConnections().size() > 3) {
                            return;
                        }
                        BackgroundExecutor.EXECUTOR.execute(() -> {
                            try {
                                Thread.sleep(1500L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (sc.isKDB()) {
                                String msg = "You just added a kdb+ server.<br>Would you like to see example code for generating charts from kdb+ queries?";
                                EventQueue.invokeLater(() -> {
                                    int choice = CommonActions.showDismissibleWarning(QStudioFrame.this.persistance, Persistance.Key.SHOW_KDB_EXAMPLE_WARNING, msg, "Open kdb+ Demo", "Open kdb+ Example Code", 2);
                                    if (choice == 0) {
                                        QStudioFrame.this.openExampleFile(this.getClass(), QStudioFrame.KDB_EXAMPLE_FILE);
                                    }
                                });
                            }
                        });
                    }
                });
                try {
                    qStudioModel.loadExistingParquet();
                }
                catch (SQLException e) {
                    QStudioFrame.this.growler.showWarning("Could not load all files within the QDuckDB folder.", "QDuckDB Load Error");
                }
            }
        });
        BackgroundExecutor.EXECUTOR.execute(() -> TimeStored.fetchOnlineNews());
        LOG.info("Finished QStudioFrame Constructor");
    }

    private static QueryStatusBar getStatusBar(QueryManager queryManager) {
        final QueryStatusBar queryStatusBar = new QueryStatusBar();
        queryManager.addQueryListener(new QueryAdapter(){

            @Override
            public void sendingQuery(ServerConfig sc, String query) {
                queryStatusBar.startQuery(query);
            }

            @Override
            public void queryResultReturned(ServerConfig sc, QueryResult qr) {
                int count = -1;
                String txt = "";
                if (qr.rs == null) {
                    count = qr.k == null ? -1 : KdbHelper.count(qr.k);
                    String res = KdbHelper.asLine(qr.k);
                    txt = qr.getResultType() + ":" + (res == null ? "" : res);
                } else {
                    try {
                        count = DBHelper.getSize(qr.rs);
                        txt = qr.rs.getMetaData().getColumnCount() + " columns";
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                queryStatusBar.endQuery(txt, count);
            }
        });
        return queryStatusBar;
    }

    public static void showPopup(Window frame, Component component, String title, Image icon) {
        new Thread(() -> {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            EventQueue.invokeLater(() -> {
                JFrame f = SwingUtils.getPopupFrame(frame, title, component, icon);
                f.setVisible(true);
            });
        }).start();
    }

    private void setFrameTitle() {
        String docTitle = this.openDocsModel.getSelectedDocument().getTitle();
        String srvr = this.queryManager.getSelectedServerName();
        this.setTitle(docTitle + (srvr == null ? "" : " #" + srvr) + " - " + "QStudio");
    }

    private void setFrameColor() {
        Color tc;
        ServerConfig sc;
        String srvr = this.queryManager.getSelectedServerName();
        HashSet<String> kws = Sets.newHashSet(this.myPreferences.getCriticalServerKeywords().split(","));
        Color c2 = this.defaultFrameColor;
        for (String k : kws) {
            if (srvr == null || !srvr.contains(k)) continue;
            c2 = this.myPreferences.getCriticalServerColor();
            break;
        }
        if (srvr != null && (sc = this.conMan.getServer(srvr)) != null && (tc = sc.getColor()) != null && !sc.isDefaultColor()) {
            c2 = tc;
        }
        this.getContentPane().setBackground(c2);
    }

    private JMenu getHelpMenu() {
        JMenu helpMenu = QStudioFrame.getJMenu(Msg.get(Msg.Key.HELP), 72);
        Action a = HtmlUtils.getWWWaction(Msg.get(Msg.Key.HELP), TimeStored.Page.QSTUDIO_HELP.url());
        a.putValue("MnemonicKey", 72);
        a.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F1"));
        helpMenu.add(a);
        AAction welcomeAction = new AAction(Msg.get(Msg.Key.WELCOME), Theme.CIcon.HAND.get16(), ae -> {
            WelcomeDialog wd = new WelcomeDialog(this, "QStudio", VERSION, this.commonActions.getAddServerAction());
            wd.setVisible(true);
        });
        welcomeAction.putValue("MnemonicKey", 87);
        helpMenu.add(welcomeAction);
        helpMenu.add(HtmlUtils.getWWWaction("Release Notes", TimeStored.Page.QSTUDIO_CHANGES.url()));
        helpMenu.add(HtmlUtils.getWWWaction("Keyboard Shortcuts", TimeStored.Page.QSTUDIO_HELP_KEYBOARD.url()));
        helpMenu.addSeparator();
        helpMenu.add(HtmlUtils.getWWWaction(Msg.get(Msg.Key.REPORT_A_BUG), TimeStored.Page.QDOC_REPORT_ISSUE.url()));
        helpMenu.add(HtmlUtils.getWWWaction("Search Feature Requests", TimeStored.Page.QDOC_FEATURE_REQUEST.url()));
        helpMenu.addSeparator();
        ImageIcon codeImage = Theme.CIcon.PAGE_CODE.get16();
        helpMenu.add(new AAction("Open QStudio Folder", Theme.CIcon.FOLDER.get16(), e -> {
            File p = QStudioModel.APP_HOME;
            try {
                Desktop.getDesktop().open(p);
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(null, "Error opening folder: " + (p == null ? "null" : p.getAbsolutePath()));
            }
        }));
        helpMenu.add(new AAction(Msg.get(Msg.Key.OPEN_EXAMPLE_CHARTS), codeImage, e -> this.openExampleFile(QStudioFrame.class, KDB_EXAMPLE_FILE)));
        helpMenu.add(new AAction("Open DuckDB Example .sql", codeImage, e -> this.openExampleFile(QStudioFrame.class, "duckdb.sql")));
        for (Action pluginAction : helpMenuPlugin.getPlugin(this, this.growler, this.commandManager)) {
            helpMenu.add(pluginAction);
        }
        helpMenu.addSeparator();
        helpMenu.add(new AAction(Msg.get(Msg.Key.ABOUT), e -> QStudioFrame.showAboutDialog(this)));
        return helpMenu;
    }

    public void openExampleFile(Class<?> containerClass, String file) {
        try {
            String welcomeCode = IOUtils.toString(containerClass, file);
            File tempf = Files.createTempDir();
            File f = new File(tempf, file);
            IOUtils.writeStringToFile(welcomeCode, f);
            this.openDocsModel.openDocument(f);
            UpdateHelper.registerEvent("qsf_openeg");
        }
        catch (IOException e) {
            String msg = Msg.get(Msg.Key.COULD_NOT_LOAD_FILE) + file;
            LOG.severe(msg);
            this.growler.showSevere(msg, "load error");
        }
    }

    private static FileTreePanel getFileTreePanel(OpenDocumentsModel openDocsModel, DocumentActions documentActions) {
        final FileTreePanel fileTreePanel = new FileTreePanel();
        fileTreePanel.setName("DocFolderFileTreePanel");
        openDocsModel.addListener(new OpenDocumentsModel.Adapter(){

            @Override
            public void folderSelected(File selectedFolder) {
                fileTreePanel.setRoot(selectedFolder);
            }
        });
        final Runnable syncSettings = () -> {
            File openFolder = openDocsModel.getSelectedFolder();
            fileTreePanel.setRoot(openFolder);
            Pattern pat = Pattern.compile(MyPreferences.INSTANCE.getIgnoreFilterRegex());
            fileTreePanel.setIgnoredFoldersRegex(pat);
        };
        syncSettings.run();
        openDocsModel.addListener(new OpenDocumentsModel.Adapter(){

            @Override
            public void ignoredFolderPatternSelected(Pattern ignoredFolderPattern) {
                syncSettings.run();
            }

            @Override
            public void folderSelected(File selectedFolder) {
                syncSettings.run();
            }
        });
        JPanel noRootsComponent = Theme.getVerticalBoxPanel();
        noRootsComponent.add(Theme.getSubHeader(Msg.get(Msg.Key.NO_FOLDER_SELECTED)));
        JPanel p = new JPanel();
        p.add(new JButton(documentActions.getOpenFolderAction()));
        noRootsComponent.add(p);
        fileTreePanel.setNoRootsComponent(noRootsComponent);
        return fileTreePanel;
    }

    public static boolean isClipped(Rectangle rec) {
        int recArea = rec.width * rec.height;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] sd = ge.getScreenDevices();
        int boundsArea = 0;
        for (GraphicsDevice gd : sd) {
            Rectangle bounds = gd.getDefaultConfiguration().getBounds();
            if (!bounds.intersects(rec)) continue;
            bounds = bounds.intersection(rec);
            boundsArea += bounds.width * bounds.height;
        }
        return boundsArea != recArea;
    }

    private void restoreBounds(Persistance persistance) {
        int y;
        Toolkit tk = Toolkit.getDefaultToolkit();
        Insets si = tk.getScreenInsets(this.getGraphicsConfiguration());
        int defWidth = (tk.getScreenSize().width - si.left - si.right) * 4 / 5;
        int defHeight = (tk.getScreenSize().height - si.top - si.bottom) * 4 / 5;
        int w = persistance.getInt(Persistance.Key.FRAME_WIDTH, defWidth);
        int h = persistance.getInt(Persistance.Key.FRAME_HEIGHT, defHeight);
        int x = persistance.getInt(Persistance.Key.FRAME_X, 0);
        Rectangle r = new Rectangle(x, y = persistance.getInt(Persistance.Key.FRAME_Y, 0), w, h);
        if (!QStudioFrame.isClipped(r)) {
            this.setBounds(x, y, w, h);
        } else {
            this.setBounds(0, 0, defWidth, defHeight);
        }
        int xs = persistance.getInt(Persistance.Key.FRAME_EXTENDEDSTATE, 6) & 0xFFFFFFFE;
        this.setExtendedState(xs);
    }

    private DefaultDockable createDockable(final String uniqueTitle, final Icon icon, JPanel panel, ActionListener refreshAL, DefaultDockActionSource actions) {
        DefaultDockable d = new DefaultDockable(panel, uniqueTitle, icon.get16());
        this.frontend.addDockable(uniqueTitle, d);
        this.frontend.setHideable(d, true);
        if (refreshAL != null) {
            actions.add(QStudioFrame.makeButton(Msg.get(Msg.Key.REFRESH), Theme.CIcon.ARROW_REFRESH, refreshAL));
        }
        if (panel != null && panel instanceof GrabableContainer) {
            final GrabableContainer gc = (GrabableContainer)((Object)panel);
            SimpleButtonAction button = QStudioFrame.makeButton("Pop-out" + uniqueTitle, Theme.CIcon.POPUP_WINDOW, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GrabItem gi = gc.grab();
                    if (gi != null) {
                        String title = StringUtils.abbreviate(gi.getTitle(), 70);
                        Icon ic = icon;
                        if (gi.getIcon() != null) {
                            ic = gi.getIcon();
                        }
                        QStudioFrame.showPopup(QStudioFrame.this, gi.getComponent(), title, ic.getBufferedImage());
                    }
                    UpdateHelper.registerEvent("qsf_popout" + uniqueTitle.replace(" ", ""));
                }
            });
            actions.add(button);
        }
        d.setActionOffers(actions);
        return d;
    }

    private static SimpleButtonAction makeButton(String text, Theme.CIcon cIcon, ActionListener actionListener) {
        SimpleButtonAction button = new SimpleButtonAction();
        button.setText(text);
        button.setIcon(cIcon.get16());
        button.addActionListener(actionListener);
        return button;
    }

    private DefaultDockable createDockable(String uniqueTitle, Icon icon, JPanel panel, ActionListener refreshAL) {
        return this.createDockable(uniqueTitle, icon, panel, refreshAL, new DefaultDockActionSource(new DockAction[0]));
    }

    private void pushPreferencesToModels() {
        String lfname;
        boolean isDarkTheme;
        int uiScale;
        this.queryManager.setMaxReturnSize(this.myPreferences.getMaxReturnSize());
        this.queryManager.setQueryWrapped(this.myPreferences.isQueryWrapped());
        this.queryManager.setQueryWrapPrefix(this.myPreferences.getQueryWrapPre());
        this.queryManager.setQueryWrapPostfix(this.myPreferences.getQueryWrapPost());
        this.queryManager.setConnectionPersisted(this.myPreferences.isConnectionPersistent());
        AIFacade.setOpenAIkey(this.myPreferences.getOpenAIkey());
        this.sTreePanel.setHiddenNamespaces(this.myPreferences.getHiddenNamespaces());
        this.consolePanel.setMaxLength(this.myPreferences.getMaxConsoleLength());
        Font f = this.myPreferences.getCodeFontFont();
        if (f != null) {
            this.serverDocumentPanel.setEditorFont(f);
            this.consolePanel.setCodeFont(f);
        }
        if ((uiScale = this.myPreferences.getUIScale()) > 0) {
            System.setProperty("flatlaf.uiScale", "" + (double)uiScale / 100.0);
        }
        EditorConfigFactory.TCOLOR tcolor = (isDarkTheme = AppLaunchHelper.isLafDark(lfname = this.myPreferences.getCodeTheme())) ? EditorConfigFactory.TCOLOR.DARK : EditorConfigFactory.TCOLOR.LIGHT;
        AppLaunchHelper.setTheme(lfname);
        SwingUtilities.updateComponentTreeUI(this);
        ChartTheme chartTheme = isDarkTheme ? ViewStrategyFactory.DARK_THEME : ViewStrategyFactory.LIGHT_THEME;
        this.chartResultPanel.setChartTheme(chartTheme);
        ServerDocumentPanel.setEditorConfig(EditorConfigFactory.get(tcolor));
        int mr = this.myPreferences.getMaxRowsShown();
        mr = mr == 0 ? Integer.MAX_VALUE : mr;
        PagingTablePanel.setMaximumRowsShown(mr);
        this.kdbResultPanel.setMaximumRowsShown(mr);
        this.queryHistorypanel.setMaximumRowsShown(mr);
        KdbHelper.setMaximumFractionDigits(this.myPreferences.getMaximumFractionDigits());
        KdbHelper.setGroupingSize(this.myPreferences.getNumberGroupingSize());
        this.documentActions.setSaveWithWindowsLineEndings(this.myPreferences.isSaveWithWindowsLineEndings());
        try {
            Pattern pat = Pattern.compile(this.myPreferences.getIgnoreFilterRegex());
            this.fileTreePanel.setIgnoredFoldersRegex(pat);
            this.openDocsModel.setIgnoredFoldersRegex(pat);
        }
        catch (PatternSyntaxException e) {
            LOG.warning("Could not compile IgnoredFoldersRegex" + this.myPreferences.getIgnoreFilterRegex());
        }
    }

    private JToolBar getToolbar(CommonActions commonActions, QueryManager queryManager, DocumentActions dh) {
        JToolBarWithBetterTooltips toolbar = new JToolBarWithBetterTooltips("Common Actions");
        ServerNameComboBox serverNameComboBox = new ServerNameComboBox(queryManager);
        serverNameComboBox.setName("serverNameComboBox");
        serverNameComboBox.setMinimumSize(new Dimension(190, 1));
        serverNameComboBox.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        ((JToolBar)toolbar).add(dh.getNewFileAction());
        ((JToolBar)toolbar).add(this.openFilesAction);
        ((JToolBar)toolbar).add(dh.getSaveFileAction());
        toolbar.addSeparator();
        commonActions.getQueryActions().forEach(toolbar::add);
        commonActions.getAiActions().forEach(toolbar::add);
        boolean isMac = System.getProperty("os.name").toLowerCase().indexOf("mac") >= 0;
        JTextField searchComboBox = new JTextField("Cmd Search [" + (isMac ? "Cmd" : "Ctrl") + "]+[P]");
        searchComboBox.setName("searchComboBox");
        String searchTooltip = "Search all available commands within qStudio.\r\nServer changing, Docs search etc.";
        searchComboBox.setToolTipText(searchTooltip);
        searchComboBox.setMinimumSize(new Dimension(190, 1));
        searchComboBox.setMaximumSize(new Dimension(380, Integer.MAX_VALUE));
        searchComboBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                QStudioFrame.this.commandPaletteAction.actionPerformed(null);
            }
        });
        JButton searchButton = new JButton(Theme.CIcon.SEARCH.get16());
        searchButton.addActionListener(ae -> this.commandPaletteAction.actionPerformed(null));
        searchButton.setToolTipText(searchTooltip);
        toolbar.addSeparator();
        for (JButton b : toolbarPlugin.getPlugin(this, this.growler, this.commandManager)) {
            toolbar.add(b);
        }
        toolbar.addSeparator();
        toolbar.add(searchButton);
        toolbar.add(searchComboBox);
        toolbar.addSeparator();
        JLabel serverLabel = new JLabel(Msg.get(Msg.Key.SERVER) + ":");
        serverLabel.setLabelFor(serverNameComboBox);
        toolbar.add(serverLabel);
        ((JToolBar)toolbar).add(commonActions.getServerSelectAction());
        toolbar.add(serverNameComboBox);
        Action copyServer = commonActions.getCopyServerHopenToClipboardAction();
        if (this.conMan.containsKdbServer()) {
            ((JToolBar)toolbar).add(copyServer).setName("copyHopenButton");
        }
        Action editServer = commonActions.getEditCurrentServerAction();
        ((JToolBar)toolbar).add(editServer).setName("editServerButton");
        Action addServer = commonActions.getAddServerAction();
        ((JToolBar)toolbar).add(addServer).setName("addServerButton");
        return toolbar;
    }

    private JMenuBar getBasicMenuBar(final CommonActions commonActions, DocumentActions dh) {
        final JMenu serverMenu = QStudioFrame.getJMenu(Msg.get(Msg.Key.SERVER), 83);
        serverMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                serverMenu.removeAll();
                for (Action a : commonActions.getServerActions()) {
                    serverMenu.add(new JMenuItem(a));
                }
                serverMenu.addSeparator();
                List<ServerConfig> cons = QStudioFrame.this.conMan.getServerConnections();
                int DISPLAY_LIMIT = 9;
                for (int i = 0; i < cons.size() && i < 9; ++i) {
                    ServerConfig sc = cons.get(i);
                    serverMenu.add(commonActions.getEditServerAction(sc));
                }
                if (cons.size() > 9) {
                    serverMenu.add(new JMenuItem("..."));
                    serverMenu.add(new JMenuItem("Right Click on Server Tree to Edit Servers"));
                }
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }
        });
        final JMenu editMenu = QStudioFrame.getJMenu(Msg.get(Msg.Key.EDIT), 69);
        MenuListener ml = new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                editMenu.removeAll();
                editMenu.add(QStudioFrame.this.documentActions.getUndoAction());
                editMenu.add(QStudioFrame.this.documentActions.getRedoAction());
                editMenu.addSeparator();
                for (Action a : QStudioFrame.this.documentActions.getEditorActions()) {
                    if (a == null) {
                        editMenu.addSeparator();
                        continue;
                    }
                    editMenu.add(new JMenuItem(a));
                }
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }
        };
        editMenu.addMenuListener(ml);
        ml.menuSelected(null);
        JMenu queryMenu = QStudioFrame.getJMenu(Msg.get(Msg.Key.QUERY), 81);
        for (Action a : commonActions.getQueryActions()) {
            queryMenu.add(new JMenuItem(a));
        }
        queryMenu.addSeparator();
        for (Action a : commonActions.getAiActions()) {
            queryMenu.add(new JMenuItem(a));
        }
        if (this.conMan.containsKdbServer()) {
            queryMenu.addSeparator();
            for (Action a : commonActions.getProActions()) {
                queryMenu.add(new JMenuItem(a));
            }
        }
        JMenu toolsMenu = QStudioFrame.getJMenu(Msg.get(Msg.Key.TOOLS), 84);
        if (this.documentActions.getGenerateDocumentationAction() != null) {
            JMenuItem mi = new JMenuItem(this.documentActions.getGenerateDocumentationAction());
            mi.setEnabled(this.conMan.containsKdbServer());
            if (!this.conMan.containsKdbServer()) {
                mi.setToolTipText("Only works for kdb+. Add kdb+ server and restart");
            }
            toolsMenu.add(mi);
        }
        for (Action a : toolsMenuPlugin.getPlugin(this, this.growler, this.commandManager)) {
            toolsMenu.add(a);
        }
        JMenu settingsMenu = QStudioFrame.getJMenu(Msg.get(Msg.Key.SETTINGS), 71);
        settingsMenu.add(new JMenuItem(new AAction(Msg.get(Msg.Key.PREFERENCES), Theme.CIcon.PREFERENCES.get16(), ae -> new PreferencesDialog(MyPreferences.INSTANCE, this))));
        settingsMenu.add(new JMenuItem(new AAction("Set Default Database Login", Theme.CIcon.SET_PASSWORD.get16(), ae -> {
            new LoginDialog(this.conMan, this);
            MyPreferences.INSTANCE.setDefaultLoginUsername(this.conMan.getDefaultLoginUsername());
            MyPreferences.INSTANCE.setDefaultLoginPassword(this.conMan.getDefaultLoginPassword());
        })));
        settingsMenu.add(new JMenuItem(new AbstractAction(Msg.get(Msg.Key.RESET_ALL)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                String message = "This will close qStudio and remove:\r\n- all saved connections\r\n- stored settings\r\n- open file history. \r\nAre you sure you want to continue?";
                int choice = JOptionPane.showConfirmDialog(QStudioFrame.this, message, Msg.get(Msg.Key.DELETE_ALL_SETTINGS), 0, 2);
                if (choice == 0) {
                    try {
                        QStudioFrame.resetDefaults(false);
                        System.exit(1);
                    }
                    catch (BackingStoreException e1) {
                        String errMsg = "Problem accessing registry, please report as bug";
                        JOptionPane.showMessageDialog(QStudioFrame.this, errMsg);
                    }
                }
            }
        }));
        this.fileMenu = QStudioFrame.getJMenu(Msg.get(Msg.Key.FILE), 70);
        this.fileMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                QStudioFrame.this.rebuildFileMenu();
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }
        });
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.fileMenu);
        menuBar.add(editMenu);
        menuBar.add(queryMenu);
        menuBar.add(settingsMenu);
        menuBar.add(toolsMenu);
        menuBar.add(serverMenu);
        return menuBar;
    }

    private static JMenu getJMenu(String title, int mnemonic) {
        JMenu m = new JMenu(title);
        m.setName(title + "Menu");
        m.setMnemonic(mnemonic);
        return m;
    }

    private void rebuildFileMenu() {
        this.fileMenu.removeAll();
        this.fileMenu.add(this.documentActions.getNewFileAction());
        this.fileMenu.add(this.openFilesAction);
        for (Action a : this.documentActions.getFileActions()) {
            this.fileMenu.add(new JMenuItem(a));
        }
        JMenuItem print = new JMenuItem(Msg.get(Msg.Key.PRINT));
        print.setMnemonic('x');
        print.setAction(new AbstractAction(Msg.get(Msg.Key.PRINT)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent ae) {
                Document doc = QStudioFrame.this.openDocsModel.getSelectedDocument();
                MessageFormat footerFormat = null;
                if (doc.getFilePath() != null) {
                    footerFormat = new MessageFormat(doc.getFilePath());
                }
                try {
                    QStudioFrame.this.serverDocumentPanel.print(new MessageFormat(doc.getTitle()), footerFormat);
                }
                catch (PrinterException e) {
                    QStudioFrame.this.growler.showSevere("Could not print document", "Printing Failed");
                    LOG.log(Level.WARNING, "Printing Failed", e);
                }
            }
        });
        this.fileMenu.add(print);
        this.fileMenu.addSeparator();
        this.fileMenu.add(new JMenuItem(new ShortcutAction("New DuckDB Database", Theme.CIcon.DUCK, ""){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                File savedDocFile = SwingUtils.askUserSaveLocation(null, "duckdb");
                if (savedDocFile != null) {
                    QStudioFrame.this.qStudioModel.addDBfiles(Arrays.asList(savedDocFile));
                }
            }
        }));
        this.fileMenu.add(new JMenuItem(new ShortcutAction("Open Database (sqlite/duckdb/h2)", Theme.CIcon.SERVER_DATABASE, ""){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser jfc = new JFileChooser();
                jfc.showOpenDialog(null);
                jfc.setFileSelectionMode(0);
                File selFile = jfc.getSelectedFile();
                if (selFile != null) {
                    QStudioFrame.this.qStudioModel.addDBfiles(Arrays.asList(selFile));
                }
            }
        }));
        if (this.recentDocumentPersister != null) {
            List<String> filePaths = this.recentDocumentPersister.getRecentFilePaths();
            this.fileMenu.addSeparator();
            for (Action a : this.documentActions.getOpenRecentActions(filePaths)) {
                this.fileMenu.add(a);
            }
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.documentActions.openAllAction(filePaths));
        }
        this.fileMenu.addSeparator();
        JMenuItem exit = new JMenuItem(Msg.get(Msg.Key.EXIT));
        exit.setMnemonic('x');
        exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowEvent wev = new WindowEvent(QStudioFrame.this, 201);
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(wev);
            }
        });
        this.fileMenu.add(exit);
    }

    public static void resetDefaults(boolean wipeLicense) throws BackingStoreException {
        MyPreferences.INSTANCE.resetDefaults();
        Persistance.INSTANCE.clear(wipeLicense);
    }

    public ConnectionManager getConnectionManager() {
        return this.conMan;
    }

    public static void showAboutDialog(JFrame frame) {
        Theme.CIcon icon = Theme.CIcon.QSTUDIO_LOGO;
        String htmlTitle = "<h1><font color='#2580A2'>q</font><font color='#25A230'>Studio</font></h1>";
        new AboutDialog(frame, "QStudio", icon, htmlTitle, VERSION).setVisible(true);
    }

    public void handleArgs(List<String> args) {
        if (args.size() == 2 && args.get(0).toLowerCase().equals("query-csv")) {
            File csvFile = new File(args.get(1));
            this.qStudioModel.addDataFiles(Lists.newArrayList(csvFile));
            return;
        }
        this.handleArgsFiles(args.stream().map(s -> new File((String)s)).collect(Collectors.toList()));
    }

    public void handleArgsFiles(File file) {
        this.handleArgsFiles(Arrays.asList(file));
    }

    public void handleArgsFiles(List<File> files) {
        Predicate<String> isDB = s -> s.endsWith(".duckdb") || s.endsWith(".db") || s.endsWith(".sqlite");
        List<File> dbFiles = files.stream().filter(f -> isDB.test(f.getName())).collect(Collectors.toList());
        List<File> parquetFiles = files.stream().filter(f -> f.getName().endsWith(".parquet")).collect(Collectors.toList());
        List<File> docsToOpen = files.stream().filter(f -> !isDB.test(f.getName()) && !f.getName().endsWith(".parquet")).collect(Collectors.toList());
        this.documentActions.openFiles(docsToOpen);
        this.qStudioModel.addDBfiles(dbFiles);
        this.qStudioModel.addDataFiles(parquetFiles);
    }

    public void setLastQueryResult(QueryResult lastQueryResult) {
        this.lastQueryResult = lastQueryResult;
        boolean hasRS = lastQueryResult != null && lastQueryResult.rs != null;
        this.xlsButton.setEnabled(hasRS);
        this.emailButton.setEnabled(hasRS);
        this.saveToDuckButton.setEnabled(hasRS);
        this.pivotButton.setEnabled(hasRS);
    }

    public static void setHelpMenuPlugin(QStudioFramePlugin<Action> helpMenuPlugin) {
        QStudioFrame.helpMenuPlugin = helpMenuPlugin;
    }

    public static void setToolbarPlugin(QStudioFramePlugin<JButton> toolbarPlugin) {
        QStudioFrame.toolbarPlugin = toolbarPlugin;
    }

    public static void setToolsMenuPlugin(QStudioFramePlugin<Action> toolsMenuPlugin) {
        QStudioFrame.toolsMenuPlugin = toolsMenuPlugin;
    }

    @FunctionalInterface
    public static interface QStudioFramePlugin<T> {
        public List<T> getPlugin(@NonNull QStudioFrame var1, @NonNull Growler var2, @NonNull CommandManager var3);
    }
}

