/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio;

import com.timestored.command.Command;
import com.timestored.command.CommandDialog;
import com.timestored.command.CommandManager;
import com.timestored.docs.Document;
import com.timestored.messages.Msg;
import com.timestored.qdoc.AutoCompleteDialog;
import com.timestored.qdoc.DocumentationDialog;
import com.timestored.qdoc.DocumentedEntity;
import com.timestored.qdoc.DocumentedMatcher;
import com.timestored.qdoc.EmptyDocSource;
import com.timestored.qdoc.GotoDefinitionCommandProvider;
import com.timestored.qdoc.ParsedQEntity;
import com.timestored.qstudio.BackgroundExecutor;
import com.timestored.qstudio.CommonActions;
import com.timestored.qstudio.DisplayQDocCommandProvider;
import com.timestored.qstudio.DocEditorPane;
import com.timestored.qstudio.KDBResultPanel;
import com.timestored.qstudio.Language;
import com.timestored.qstudio.Persistance;
import com.timestored.qstudio.QStudioModel;
import com.timestored.qstudio.WindowSizePersister;
import com.timestored.qstudio.qdoc.ContextualDocCompleter;
import com.timestored.swingxx.AAction;
import com.timestored.theme.Theme;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import lombok.NonNull;

public class QDocController {
    private static final int shortModifier = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private static final KeyStroke SHOW_DOC_KS = KeyStroke.getKeyStroke(113, 0);
    private static final KeyStroke GOTO_DEFINITION_KS = KeyStroke.getKeyStroke(68, shortModifier);
    private static final KeyStroke OUTLINE_DOC_KS = KeyStroke.getKeyStroke(73, shortModifier);
    private static final KeyStroke OUTLINE_ALL_DOC_KS = KeyStroke.getKeyStroke(85, shortModifier);
    @NonNull
    private final QStudioModel qStudioModel;
    @NonNull
    private static final List<Supplier<DocumentedMatcher>> SUPPLIERS = new ArrayList<Supplier<DocumentedMatcher>>();
    @NonNull
    private static final List<DocumentedMatcher> docMatchers = new ArrayList<DocumentedMatcher>();
    @NonNull
    private final ContextualDocCompleter contextualDocCompleter;
    private static final DocumentedMatcher EMPTY_DOC_MATCHER = new DocumentedMatcher(Language.OTHER, EmptyDocSource.INSTANCE);

    public static void registerDocMatcherSupplier(Supplier<DocumentedMatcher> dms) {
        SUPPLIERS.add(dms);
    }

    public QDocController(QStudioModel qStudioModel) {
        this.qStudioModel = qStudioModel;
        this.contextualDocCompleter = new ContextualDocCompleter(qStudioModel);
        for (Supplier<DocumentedMatcher> supplier : SUPPLIERS) {
            docMatchers.add(supplier.get());
        }
        for (DocumentedMatcher dm2 : docMatchers) {
            dm2.setContextDocCompleter(this.contextualDocCompleter);
        }
    }

    DocumentedMatcher getDocumentedMatcher() {
        for (DocumentedMatcher dm2 : docMatchers) {
            dm2.setContextDocCompleter(this.contextualDocCompleter);
            if (!this.qStudioModel.getCurrentSqlLanguage().equals((Object)dm2.getLanguage())) continue;
            return dm2;
        }
        return EMPTY_DOC_MATCHER;
    }

    Action getAutoCompleteAction(DocEditorPane docEditorPane, JFrame parentFrame) {
        AAction autoCompleteAction = new AAction("autodoc", e -> {
            AutoCompleteDialog autoDialog = new AutoCompleteDialog(docEditorPane, parentFrame, this.getDocumentedMatcher());
            this.showDocPopup(autoDialog, docEditorPane);
            docEditorPane.requestFocus();
        });
        this.configureAction(autoCompleteAction, CommonActions.AUTO_COMPLETE_KS, "Show Autocomplete Suggestions");
        return autoCompleteAction;
    }

    Action getGotoDefinitionAction(final Document document) {
        AbstractAction gotoDefinitionAction = new AbstractAction("goto Definition", Theme.CIcon.INFO.get16()){

            @Override
            public void actionPerformed(ActionEvent e) {
                int cp = document.getCaratPosition();
                List<DocumentedEntity> docEs = QDocController.this.getDocumentedMatcher().findDocs(document.getContent(), cp);
                for (DocumentedEntity de : docEs) {
                    if (!(de instanceof ParsedQEntity)) continue;
                    try {
                        ((ParsedQEntity)de).gotoDefinition(QDocController.this.qStudioModel.getOpenDocumentsModel());
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog(null, "Error Opening Source File:\r\n" + ioe.toString(), "Error Opening File", 0);
                    }
                    break;
                }
            }
        };
        this.configureAction(gotoDefinitionAction, GOTO_DEFINITION_KS, "Try to goto the definition for the element under the carat.");
        return gotoDefinitionAction;
    }

    Action getOutlineAllFilesAction(DocEditorPane docEditorPane) {
        AAction outlineAllFilesAction = new AAction("outlineAllFiles", e -> this.showCommandDialog(this.getDocumentedMatcher().findSourceDocs(), true, docEditorPane));
        return this.configureAction(outlineAllFilesAction, OUTLINE_ALL_DOC_KS, "Show Code Outline for all files.");
    }

    Action getOutlineFileAction(DocEditorPane docEditorPane) {
        AAction outlineFileAction = new AAction("outlineFile", e -> {
            String fname = this.qStudioModel.getOpenDocumentsModel().getSelectedDocument().getTitle();
            List<ParsedQEntity> docs = this.getDocumentedMatcher().findSourceDocs(fname);
            this.showCommandDialog(docs, false, docEditorPane);
        });
        return this.configureAction(outlineFileAction, OUTLINE_DOC_KS, "Show Code Outline");
    }

    Action getDocLookupAction(DocEditorPane docEditorPane) {
        AAction docLookupAction = new AAction("Lookup Doc", Theme.CIcon.INFO.get16(), e -> {
            Document d = this.qStudioModel.getOpenDocumentsModel().getSelectedDocument();
            int cp = d.getCaratPosition();
            DocumentedEntity doc = this.getDocumentedMatcher().findDoc(d.getContent(), cp);
            this.showDocPopup(new DocumentationDialog(doc), docEditorPane);
        });
        return this.configureAction(docLookupAction, SHOW_DOC_KS, "Try to lookup documentation for the text under the carat.");
    }

    private void showCommandDialog(List<ParsedQEntity> docs, boolean showSource, DocEditorPane docEditorPane) {
        List<Command> commands = GotoDefinitionCommandProvider.convert(docs, this.qStudioModel.getOpenDocumentsModel(), showSource, "");
        CommandDialog coD = new CommandDialog("Jump to Definition", commands, BackgroundExecutor.EXECUTOR);
        coD.setLocation(docEditorPane.getPopupPoint());
        coD.setVisible(true);
        Document d = this.qStudioModel.getOpenDocumentsModel().getSelectedDocument();
        for (int i = 0; i < docs.size(); ++i) {
            ParsedQEntity pqe = docs.get(i);
            if (!pqe.getSource().equals(d.getTitle()) || pqe.getOffset() < d.getCaratPosition()) continue;
            coD.setSelectedCommand(commands.get(i));
            break;
        }
    }

    private void showDocPopup(JDialog dialog, DocEditorPane docEditorPane) {
        WindowSizePersister wsp = new WindowSizePersister(dialog, this.qStudioModel.getPersistance(), Persistance.Key.QDOC_WINDOW_SIZE);
        dialog.setSize(wsp.getDimension(DocumentationDialog.PREF_DIMENSION));
        dialog.setLocation(docEditorPane.getPopupPoint());
        dialog.setVisible(true);
    }

    private Action configureAction(Action action, KeyStroke keyStroke, String shortDescription) {
        action.putValue("ShortDescription", shortDescription);
        action.putValue("AcceleratorKey", keyStroke);
        return action;
    }

    public DocEditorPane.TooltipProvider getTooltipProvider(final Document document) {
        return new DocEditorPane.TooltipProvider(){

            @Override
            public String getToolTipText(MouseEvent event, int pos) {
                DocumentedEntity de;
                String txt = document.getContent();
                if (pos < txt.length() && pos >= 0 && !" \r\n".contains("" + txt.charAt(pos)) && (de = QDocController.this.getDocumentedMatcher().findDoc(txt, pos)) != null) {
                    return DocumentationDialog.getTooltip(de);
                }
                return null;
            }
        };
    }

    void registerCommandProviders(CommandManager commandManager, KDBResultPanel kdbResultPanel) {
        for (DocumentedMatcher dm2 : docMatchers) {
            GotoDefinitionCommandProvider cp = new GotoDefinitionCommandProvider(dm2, this.qStudioModel.getOpenDocumentsModel(), true, Msg.get(Msg.Key.GOTO_DEFINITION));
            commandManager.registerProvider(dm2.getLanguage().name(), cp);
            commandManager.registerProvider(dm2.getLanguage().name(), new DisplayQDocCommandProvider(dm2, kdbResultPanel));
        }
    }

    public void setIgnoredFoldersRegex(Pattern pat) {
    }

    public void folderSelected(File selectedFolder) {
    }

    public Object getOpenDocumentsDocSource() {
        return null;
    }

    public QDocController(@NonNull QStudioModel qStudioModel, @NonNull ContextualDocCompleter contextualDocCompleter) {
        if (qStudioModel == null) {
            throw new NullPointerException("qStudioModel is marked non-null but is null");
        }
        if (contextualDocCompleter == null) {
            throw new NullPointerException("contextualDocCompleter is marked non-null but is null");
        }
        this.qStudioModel = qStudioModel;
        this.contextualDocCompleter = contextualDocCompleter;
    }
}

