/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.timestored.qstudio.AppearancePreferencesPanel;
import com.timestored.qstudio.MyPreferences;
import com.timestored.qstudio.PreferencesPanel;
import com.timestored.qstudio.QueryPreferencesPanel;
import com.timestored.swingxx.SwingUtils;
import com.timestored.theme.Theme;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

class PreferencesDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final MyPreferences myPreferences;
    private final List<PreferencesPanel> prefPanels = Lists.newArrayList();

    PreferencesDialog(MyPreferences myPreferences, JFrame frame) {
        this.myPreferences = Preconditions.checkNotNull(myPreferences);
        this.setTitle("Preferences");
        SwingUtils.setSensibleDimensions(frame, this);
        this.setIconImage(Theme.CIcon.PREFERENCES.get().getImage());
        this.setLayout(new BorderLayout());
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        JTabbedPane tabpane = new JTabbedPane();
        AppearancePreferencesPanel appearancePreferencesPanel = new AppearancePreferencesPanel(myPreferences, frame);
        tabpane.add("Appearance", appearancePreferencesPanel);
        this.prefPanels.add(appearancePreferencesPanel);
        QueryPreferencesPanel queryPanel = new QueryPreferencesPanel(myPreferences, this);
        tabpane.add("Connections", queryPanel);
        this.prefPanels.add(queryPanel);
        MiscPreferencesPanel miscPanel = new MiscPreferencesPanel(myPreferences, this);
        tabpane.add("Misc", miscPanel);
        this.prefPanels.add(miscPanel);
        this.add((Component)tabpane, "Center");
        this.add((Component)this.getCloseSaveBox(), "South");
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
    }

    private Box getCloseSaveBox() {
        JButton closeButton = new JButton(new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (PreferencesPanel pp : PreferencesDialog.this.prefPanels) {
                    pp.cancel();
                    PreferencesDialog.this.myPreferences.notifyListeners();
                }
                PreferencesDialog.this.setVisible(false);
                PreferencesDialog.this.dispatchEvent(new WindowEvent(PreferencesDialog.this, 201));
            }
        });
        JButton saveButton = new JButton(new AbstractAction("Save"){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (PreferencesPanel pp : PreferencesDialog.this.prefPanels) {
                    pp.saveSettings();
                    PreferencesDialog.this.myPreferences.notifyListeners();
                }
                PreferencesDialog.this.setVisible(false);
                PreferencesDialog.this.dispatchEvent(new WindowEvent(PreferencesDialog.this, 201));
            }
        });
        Box closeBox = Box.createHorizontalBox();
        closeBox.add(Box.createHorizontalGlue());
        closeBox.add(saveButton);
        closeBox.add(Box.createHorizontalGlue());
        closeBox.add(closeButton);
        closeBox.add(Box.createHorizontalGlue());
        return closeBox;
    }

    private static class MiscPreferencesPanel
    extends PreferencesPanel {
        private static final long serialVersionUID = 1L;
        private final JCheckBox saveWithWindowsLineEndingsCheckBox;
        private final JCheckBox sendTelemetryCheckBox;
        private final JTextField hideNsTextField;
        private final JTextField hideFoldersTextField;
        private final JTextField openaiKeyField;

        public MiscPreferencesPanel(MyPreferences myPreferences, Component container) {
            super(myPreferences, container);
            Box panel = Box.createVerticalBox();
            panel.setBorder(Theme.getCentreBorder());
            this.saveWithWindowsLineEndingsCheckBox = new JCheckBox();
            String tooltipText = "<html>Files will be saved with \\r\\n line endings,<br/> compared to \\n standard found on linux/mac</html>";
            panel.add(Theme.getFormRow(this.saveWithWindowsLineEndingsCheckBox, "Save with \\r\\n Windows Line Ending:", tooltipText));
            panel.add(Box.createVerticalStrut(10));
            this.hideNsTextField = new JTextField(20);
            tooltipText = "<html>These namespaces will not be displayed in the server tree panel.</html>";
            panel.add(Theme.getFormRow(this.hideNsTextField, "Hidden Namespaces:", null));
            panel.add(Box.createVerticalStrut(10));
            this.hideFoldersTextField = new JTextField(20);
            tooltipText = "<html>These folders will not be searched when opening files using the Command Bar (Ctrl+P).</html>";
            panel.add(Theme.getFormRow(this.hideFoldersTextField, "Regex Filter To Hide Folders:", tooltipText));
            panel.add(Box.createVerticalStrut(10));
            JLabel label = new JLabel("This will send details on your database to OpenAI!!!");
            label.setForeground(Color.RED);
            panel.add(Theme.getFormRow(label, "Warning:", null));
            panel.add(Theme.getFormRow(new JLabel("Do NOT add a key unless you are happy to send those details."), "Warning:", null));
            this.openaiKeyField = new JTextField(40);
            tooltipText = "<html>This key will be used to generate AI queries.</html>";
            panel.add(Theme.getFormRow(this.openaiKeyField, "OpenAI Key:", null));
            panel.add(Box.createVerticalStrut(10));
            this.sendTelemetryCheckBox = new JCheckBox();
            String sendTelemetryTooltipText = "<html>Help TimeStored improve its products by sending anonymous data<br/> about features and plugins used.</html>";
            panel.add(Theme.getFormRow(this.sendTelemetryCheckBox, "Send Usage Statistics:", sendTelemetryTooltipText));
            panel.add(Box.createVerticalStrut(10));
            this.setLayout(new BorderLayout());
            this.add((Component)panel, "North");
            this.refresh();
        }

        @Override
        void refresh() {
            this.saveWithWindowsLineEndingsCheckBox.setSelected(this.myPreferences.isSaveWithWindowsLineEndings());
            this.sendTelemetryCheckBox.setSelected(this.myPreferences.isSendTelemetry());
            String hid = Joiner.on(" ").join(this.myPreferences.getHiddenNamespaces());
            this.hideNsTextField.setText(hid);
            this.openaiKeyField.setText(this.myPreferences.getOpenAIkey());
            this.hideFoldersTextField.setText(this.myPreferences.getIgnoreFilterRegex());
        }

        @Override
        void saveSettings() {
            this.myPreferences.setSaveWithWindowsLineEndings(this.saveWithWindowsLineEndingsCheckBox.isSelected());
            this.myPreferences.setSendTelemetry(this.sendTelemetryCheckBox.isSelected());
            String[] ns = this.hideNsTextField.getText().split(" ");
            this.myPreferences.setHiddenNamespaces(ns);
            this.myPreferences.setOpenAIkey(this.openaiKeyField.getText().trim());
            this.myPreferences.setIgnoreFilterRegex(this.hideFoldersTextField.getText());
        }

        @Override
        void cancel() {
        }
    }
}

