/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PivotFormConfig {
    public static final String[] AGG_OPS = new String[]{"count", "max", "min", "sum", "avg", "dev", "sdev", "var", "svar"};
    private static final Set<Integer> GROUPING_TYPES;
    private static final Set<Integer> NUM_TYPES;
    private final String sqlQuery;
    private final List<String> allCols;
    private final List<String> aggCols;
    private final List<String> byColsShown;
    private final String aggOp;
    private final String aggCol;
    private final List<String> byColsSelected;
    private final List<String> pivotColsSelected;

    public boolean containsPivot() {
        return this.pivotColsSelected.size() > 0;
    }

    public PivotFormConfig(String originalQry, ResultSetMetaData metaData) throws SQLException {
        this.sqlQuery = originalQry;
        List<ColDetails> cds = PivotFormConfig.getColDetails(metaData);
        Function<Stream, List> conv = s -> ImmutableList.copyOf(s.map(ColDetails::getName).collect(Collectors.toList()));
        this.allCols = conv.apply(cds.stream());
        this.aggCols = conv.apply(cds.stream().filter(cd -> NUM_TYPES.contains(cd.getJdbcType())));
        this.byColsShown = conv.apply(cds.stream().filter(cd -> GROUPING_TYPES.contains(cd.getJdbcType())));
        this.aggCol = this.aggCols.size() > 0 ? this.aggCols.get(0) : "";
        this.aggOp = "sum";
        this.byColsSelected = Collections.emptyList();
        this.pivotColsSelected = Collections.emptyList();
    }

    private PivotFormConfig(PivotFormConfig pivotConfig, List<String> byColsSelected, List<String> pivotColsSelected, String aggOp, String aggCol) throws SQLException {
        this.sqlQuery = pivotConfig.sqlQuery;
        this.allCols = pivotConfig.allCols;
        this.aggCols = pivotConfig.aggCols;
        this.byColsShown = pivotConfig.byColsShown;
        this.aggOp = aggOp;
        this.aggCol = aggCol;
        this.byColsSelected = byColsSelected;
        this.pivotColsSelected = pivotColsSelected;
    }

    public PivotFormConfig changeSelection(List<String> byColsSelected, List<String> pivotColsSelected, String aggOp, String aggCol) throws SQLException {
        return new PivotFormConfig(this, byColsSelected, pivotColsSelected, aggOp, aggCol);
    }

    private static List<ColDetails> getColDetails(ResultSetMetaData rsmd) throws SQLException {
        int cols = rsmd.getColumnCount();
        ArrayList<ColDetails> cns = new ArrayList<ColDetails>(cols);
        for (int c2 = 1; c2 <= cols; ++c2) {
            cns.add(new ColDetails(rsmd.getColumnName(c2), rsmd.getColumnType(c2)));
        }
        return cns;
    }

    public String getAggSel() {
        return this.aggCol + ":" + this.aggOp + " " + this.aggCol;
    }

    public String getSqlQuery() {
        return this.sqlQuery;
    }

    public List<String> getAllCols() {
        return this.allCols;
    }

    public List<String> getAggCols() {
        return this.aggCols;
    }

    public List<String> getByColsShown() {
        return this.byColsShown;
    }

    public String getAggOp() {
        return this.aggOp;
    }

    public String getAggCol() {
        return this.aggCol;
    }

    public List<String> getByColsSelected() {
        return this.byColsSelected;
    }

    public List<String> getPivotColsSelected() {
        return this.pivotColsSelected;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PivotFormConfig)) {
            return false;
        }
        PivotFormConfig other = (PivotFormConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$sqlQuery = this.getSqlQuery();
        String other$sqlQuery = other.getSqlQuery();
        if (this$sqlQuery == null ? other$sqlQuery != null : !this$sqlQuery.equals(other$sqlQuery)) {
            return false;
        }
        List<String> this$allCols = this.getAllCols();
        List<String> other$allCols = other.getAllCols();
        if (this$allCols == null ? other$allCols != null : !((Object)this$allCols).equals(other$allCols)) {
            return false;
        }
        List<String> this$aggCols = this.getAggCols();
        List<String> other$aggCols = other.getAggCols();
        if (this$aggCols == null ? other$aggCols != null : !((Object)this$aggCols).equals(other$aggCols)) {
            return false;
        }
        List<String> this$byColsShown = this.getByColsShown();
        List<String> other$byColsShown = other.getByColsShown();
        if (this$byColsShown == null ? other$byColsShown != null : !((Object)this$byColsShown).equals(other$byColsShown)) {
            return false;
        }
        String this$aggOp = this.getAggOp();
        String other$aggOp = other.getAggOp();
        if (this$aggOp == null ? other$aggOp != null : !this$aggOp.equals(other$aggOp)) {
            return false;
        }
        String this$aggCol = this.getAggCol();
        String other$aggCol = other.getAggCol();
        if (this$aggCol == null ? other$aggCol != null : !this$aggCol.equals(other$aggCol)) {
            return false;
        }
        List<String> this$byColsSelected = this.getByColsSelected();
        List<String> other$byColsSelected = other.getByColsSelected();
        if (this$byColsSelected == null ? other$byColsSelected != null : !((Object)this$byColsSelected).equals(other$byColsSelected)) {
            return false;
        }
        List<String> this$pivotColsSelected = this.getPivotColsSelected();
        List<String> other$pivotColsSelected = other.getPivotColsSelected();
        return !(this$pivotColsSelected == null ? other$pivotColsSelected != null : !((Object)this$pivotColsSelected).equals(other$pivotColsSelected));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PivotFormConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sqlQuery = this.getSqlQuery();
        result = result * 59 + ($sqlQuery == null ? 43 : $sqlQuery.hashCode());
        List<String> $allCols = this.getAllCols();
        result = result * 59 + ($allCols == null ? 43 : ((Object)$allCols).hashCode());
        List<String> $aggCols = this.getAggCols();
        result = result * 59 + ($aggCols == null ? 43 : ((Object)$aggCols).hashCode());
        List<String> $byColsShown = this.getByColsShown();
        result = result * 59 + ($byColsShown == null ? 43 : ((Object)$byColsShown).hashCode());
        String $aggOp = this.getAggOp();
        result = result * 59 + ($aggOp == null ? 43 : $aggOp.hashCode());
        String $aggCol = this.getAggCol();
        result = result * 59 + ($aggCol == null ? 43 : $aggCol.hashCode());
        List<String> $byColsSelected = this.getByColsSelected();
        result = result * 59 + ($byColsSelected == null ? 43 : ((Object)$byColsSelected).hashCode());
        List<String> $pivotColsSelected = this.getPivotColsSelected();
        result = result * 59 + ($pivotColsSelected == null ? 43 : ((Object)$pivotColsSelected).hashCode());
        return result;
    }

    public String toString() {
        return "PivotFormConfig(sqlQuery=" + this.getSqlQuery() + ", allCols=" + this.getAllCols() + ", aggCols=" + this.getAggCols() + ", byColsShown=" + this.getByColsShown() + ", aggOp=" + this.getAggOp() + ", aggCol=" + this.getAggCol() + ", byColsSelected=" + this.getByColsSelected() + ", pivotColsSelected=" + this.getPivotColsSelected() + ")";
    }

    static {
        HashSet<Integer> numTypes = new HashSet<Integer>();
        numTypes.add(-5);
        numTypes.add(3);
        numTypes.add(8);
        numTypes.add(6);
        numTypes.add(4);
        numTypes.add(2);
        numTypes.add(7);
        numTypes.add(5);
        numTypes.add(-6);
        NUM_TYPES = ImmutableSet.copyOf(numTypes);
        HashSet<Integer> groupingTypes = new HashSet<Integer>();
        groupingTypes.add(16);
        groupingTypes.add(91);
        groupingTypes.add(4);
        groupingTypes.add(-15);
        groupingTypes.add(-9);
        groupingTypes.add(5);
        groupingTypes.add(-6);
        groupingTypes.add(-8);
        groupingTypes.add(12);
        GROUPING_TYPES = ImmutableSet.copyOf(groupingTypes);
    }

    private static class ColDetails {
        private final String name;
        private final int jdbcType;

        public ColDetails(String name, int jdbcType) {
            this.name = name;
            this.jdbcType = jdbcType;
        }

        public String getName() {
            return this.name;
        }

        public int getJdbcType() {
            return this.jdbcType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ColDetails)) {
                return false;
            }
            ColDetails other = (ColDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getJdbcType() != other.getJdbcType()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ColDetails;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getJdbcType();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "PivotFormConfig.ColDetails(name=" + this.getName() + ", jdbcType=" + this.getJdbcType() + ")";
        }
    }
}

