/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio;

import com.timestored.qstudio.MyPreferences;
import com.timestored.qstudio.PivotFormConfig;
import com.timestored.theme.Theme;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

class PivotForm
extends JPanel {
    private final JList selList;
    private final JComboBox pivotColCB;
    private final JComboBox<String> aggColCB;
    private final JComboBox<String> aggOpCB;
    private PivotFormConfig pivotConfig;
    private boolean imChanging = false;
    private String lastQuery = "";

    public PivotForm(Consumer<PivotFormConfig> callBack) {
        this.setLayout(new BorderLayout());
        Box form = Box.createHorizontalBox();
        String[] aggOps = PivotFormConfig.AGG_OPS;
        this.aggOpCB = new JComboBox<String>(aggOps);
        int ROW_HEIGHT = Math.max(15, MyPreferences.INSTANCE.getCodeFontSize() * 2);
        this.aggOpCB.setMaximumSize(new Dimension(30, ROW_HEIGHT));
        this.aggColCB = new JComboBox();
        this.aggColCB.setMaximumSize(new Dimension(280, ROW_HEIGHT));
        this.selList = new JList();
        this.selList.setLayoutOrientation(2);
        this.selList.setVisibleRowCount(1);
        this.pivotColCB = new JComboBox();
        this.pivotColCB.setMaximumSize(new Dimension(280, ROW_HEIGHT));
        JButton resetToTableButton = new JButton(new AbstractAction("", Theme.CIcon.TABLE_ELEMENT.get16()){

            @Override
            public void actionPerformed(ActionEvent e) {
                PivotForm.this.pivotColCB.setSelectedIndex(0);
                PivotForm.this.selList.clearSelection();
            }
        });
        JButton copyButtonSmall = new JButton(this.createCopyAction(""));
        JButton copyButton = new JButton(this.createCopyAction("Copy Query"));
        form.add(resetToTableButton);
        form.add(copyButtonSmall);
        form.add(new JLabel("Select "));
        form.add(this.aggOpCB);
        form.add(this.aggColCB);
        form.add(new JLabel(" By: "));
        form.add(this.selList);
        form.add(new JLabel(" Pivot On: "));
        form.add(this.pivotColCB);
        form.setPreferredSize(new Dimension(300, 30));
        form.add(copyButton);
        form.add(Box.createHorizontalGlue());
        form.add(Box.createHorizontalStrut(30));
        Runnable sendCallback = () -> {
            if (this.imChanging) {
                return;
            }
            List<String> groupbylist = this.getSelectedGroupBys();
            ArrayList<String> pivotlist = new ArrayList<String>();
            if (this.pivotColCB.getSelectedIndex() > 0) {
                pivotlist.add((String)this.pivotColCB.getSelectedItem());
            }
            ArrayList<String> agglist = new ArrayList<String>();
            if (this.aggColCB.getSelectedIndex() != -1) {
                agglist.add((String)this.aggColCB.getSelectedItem());
            }
            try {
                String aggCol;
                String aggOp;
                PivotFormConfig newPC;
                if (this.pivotConfig != null && !(newPC = this.pivotConfig.changeSelection(groupbylist, pivotlist, aggOp = (String)this.aggOpCB.getSelectedItem(), aggCol = (String)this.aggColCB.getSelectedItem())).equals(this.pivotConfig)) {
                    callBack.accept(newPC);
                }
            }
            catch (SQLException e1) {
                JOptionPane.showMessageDialog(null, "Error changing PulsePivot");
            }
        };
        this.selList.addListSelectionListener(lse -> {
            if (!lse.getValueIsAdjusting()) {
                sendCallback.run();
            }
        });
        this.pivotColCB.addActionListener(l -> sendCallback.run());
        this.aggOpCB.addActionListener(l -> sendCallback.run());
        this.aggColCB.addActionListener(l -> sendCallback.run());
        this.add((Component)form, "Center");
    }

    private Action createCopyAction(String text) {
        return new AbstractAction(text, Theme.CIcon.EDIT_COPY.get16()){

            @Override
            public void actionPerformed(ActionEvent e) {
                Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
                clpbrd.setContents(new StringSelection(PivotForm.this.lastQuery), null);
                this.putValue("ShortDescription", "Copy the query used to generate the latest result to the clipboard.");
            }
        };
    }

    public void setDisplay(PivotFormConfig pivotConfig, String lastQuery) {
        this.imChanging = true;
        this.pivotConfig = pivotConfig;
        this.lastQuery = lastQuery;
        this.aggOpCB.setSelectedItem(pivotConfig.getAggOp());
        this.aggColCB.setSelectedItem(pivotConfig.getAggCol());
        List<String> colNamesList = pivotConfig.getByColsShown();
        String[] colNames = pivotConfig.getByColsShown().toArray(new String[0]);
        this.aggColCB.setModel(new DefaultComboBoxModel<String>(pivotConfig.getAggCols().toArray(new String[0])));
        this.selList.setModel(new DefaultComboBoxModel<String>(colNames));
        if (colNames.length > 12) {
            this.selList.setVisibleRowCount(2);
        }
        List<String> bySel = pivotConfig.getByColsSelected();
        int[] indices = new int[bySel.size()];
        for (int i = 0; i < bySel.size(); ++i) {
            indices[i] = pivotConfig.getByColsShown().indexOf(bySel.get(i));
        }
        if (!PivotForm.isEqual(this.selList.getSelectedIndices(), indices)) {
            this.selList.setSelectedIndices(indices);
        }
        ArrayList<String> pivotOptions = new ArrayList<String>();
        pivotOptions.add("--NONE--");
        this.pivotColCB.setEnabled(indices.length > 0);
        if (indices.length > 0) {
            pivotOptions.addAll(colNamesList);
            this.pivotColCB.setModel(new DefaultComboBoxModel<String>(pivotOptions.toArray(new String[0])));
            if (pivotConfig.getPivotColsSelected().size() > 0) {
                String selItem = pivotConfig.getPivotColsSelected().get(0);
                for (int i = 0; i < pivotOptions.size(); ++i) {
                    if (!selItem.equals(pivotOptions.get(i))) continue;
                    this.pivotColCB.setSelectedIndex(i);
                    break;
                }
            }
        } else {
            this.pivotColCB.setModel(new DefaultComboBoxModel<String>(pivotOptions.toArray(new String[0])));
        }
        this.imChanging = false;
    }

    private static boolean isEqual(int[] selectedIndices, int[] indices) {
        if (selectedIndices == null && indices == null) {
            return true;
        }
        if (selectedIndices == null || indices == null) {
            return false;
        }
        if (selectedIndices.length != indices.length) {
            return false;
        }
        for (int i = 0; i < selectedIndices.length; ++i) {
            if (selectedIndices[i] == indices[i]) continue;
            return false;
        }
        return true;
    }

    List<String> getSelectedGroupBys() {
        int[] selIndices = this.selList.getSelectedIndices();
        ArrayList<String> groupbylist = new ArrayList<String>();
        for (int i = 0; i < selIndices.length; ++i) {
            groupbylist.add((String)this.selList.getModel().getElementAt(selIndices[i]));
        }
        return groupbylist;
    }
}

