/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio;

import com.timestored.qstudio.model.KeyInterface;
import com.timestored.qstudio.model.PersistanceInterface;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public enum Persistance implements PersistanceInterface
{
    INSTANCE;

    private static final Preferences PREF;

    @Override
    public void put(KeyInterface key, String value) {
        PREF.put(key.name(), value);
    }

    @Override
    public String get(KeyInterface key, String def) {
        return PREF.get(key.name(), def);
    }

    @Override
    public void putBoolean(KeyInterface key, boolean value) {
        PREF.putBoolean(key.name(), value);
    }

    @Override
    public boolean getBoolean(KeyInterface key, boolean def) {
        return PREF.getBoolean(key.name(), def);
    }

    @Override
    public void putInt(KeyInterface key, int value) {
        PREF.putInt(key.name(), value);
    }

    @Override
    public int getInt(KeyInterface key, int def) {
        return PREF.getInt(key.name(), def);
    }

    @Override
    public void putLong(KeyInterface key, long val2) {
        PREF.putLong(key.name(), val2);
    }

    @Override
    public long getLong(KeyInterface key, long def) {
        return PREF.getLong(key.name(), def);
    }

    @Override
    public void clear(boolean wipeLicense) throws BackingStoreException {
        if (wipeLicense) {
            PREF.clear();
        }
        for (Key k : Key.values()) {
            if (k.equals(Key.FERDB)) continue;
            PREF.remove(k.name());
        }
    }

    @Override
    public Preferences getPref() {
        return PREF;
    }

    static {
        PREF = Preferences.userNodeForPackage(Persistance.class);
    }

    public static enum Key implements KeyInterface
    {
        WINDOW_POSITIONS,
        OPEN_DOCS,
        CONNECTIONS,
        FRAME_HEIGHT,
        FRAME_WIDTH,
        RECENT_DOCS,
        QDOC_WINDOW_SIZE,
        FIRST_OPEN,
        LAST_AD,
        LAST_OPENED_FOLDER,
        SHOW_QDOC_WARNING,
        SHOW_DBM_WARNING,
        SIGNED_LICENSE,
        FERDB,
        QUERY_COUNT,
        FRAME_X,
        FRAME_Y,
        FRAME_EXTENDEDSTATE,
        SHOW_KDB_EXAMPLE_WARNING,
        SHOW_NOTEBOOK_WARNING;

    }
}

