/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.timestored.connections.PreferenceHelper;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;

enum MyPreferences {
    INSTANCE;

    private static final Logger LOG;
    private static final Preferences PREF;
    private static final String DEFAULT_HID_NS = ".Q .q .h .o .j";
    private static final long DEFAULT_MAX_RET = 0xA00000L;
    private static final boolean DEFAULT_QUERY_WRAPPED = true;
    private static final boolean DEFAULT_SAVE_WITH_WINDOWS_LINE_ENDINGS;
    private static final boolean DEFAULT_SEND_TELEMETRY = true;
    private static final int DEFAULT_MAX_ROWS_SHOWN = 10000;
    private static final int DEFAULT_CONSOLE_LENGTH = 16000;
    private static final int KDB_IPC_LIMIT_MB = 2000;
    private static final int DEFAULT_CODE_FONT_SIZE = 12;
    private static final String DEFAULT_CODE_FONT = "Monospaced";
    private static final String DEFAULT_CODE_THEME = "Darcula";
    private static final boolean DEFAULT_CONNECTION_PERSISTENT = true;
    private static final boolean DEFAULT_SHOW_TOOLTIPS = true;
    private static final int DEFAULT_UISCALE = 100;
    private static final int DEFAULT_FRACTION_DIGITS = 7;
    private static final int DEFAULT_NUMBER_GROUPING_SIZE = 0;
    private static final String DEFAULT_CRITICAL_KEYWORDS = "prod,PROD,preprod,preprd";
    private static final String DEFAULT_IGNORE_FOLDER_REGEX = "^\\..*|^target$";
    private static final int DEFAULT_CRITICAL_COLOR;
    private static final boolean DEFAULT_QUERY_LOGGING = false;
    private static final String DEFAULT_QUERY_LOGGING_FOLDER;
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();

    public void resetDefaults() throws BackingStoreException {
        for (Key k : Key.values()) {
            PREF.remove(k.name());
        }
    }

    public int getMaxRowsShown() {
        return PREF.getInt(Key.MAX_ROWS_SHOWN.toString(), 10000);
    }

    public void setMaxRowsShown(int maxRowsShown) {
        Preconditions.checkArgument(maxRowsShown >= 0);
        PREF.putInt(Key.MAX_ROWS_SHOWN.toString(), maxRowsShown);
    }

    public int getCodeFontSize() {
        int def_font = 12;
        try {
            int w = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode().getWidth();
            def_font = w > 1920 ? 20 : (w == 1920 ? 13 : def_font);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return PREF.getInt(Key.CODE_FONT_SIZE.toString(), def_font);
    }

    public void setCodeFontSize(int fontSize) {
        if (fontSize < 1) {
            fontSize = 1;
        } else if (fontSize > 50) {
            fontSize = 50;
        }
        PREF.putInt(Key.CODE_FONT_SIZE.toString(), fontSize);
    }

    public Font getCodeFontFont() {
        return new Font(this.getCodeFont(), 0, this.getCodeFontSize());
    }

    public String getCodeFont() {
        return PREF.get(Key.CODE_FONT.toString(), DEFAULT_CODE_FONT);
    }

    public String getCodeTheme() {
        return PREF.get(Key.CODE_THEME.toString(), DEFAULT_CODE_THEME);
    }

    public void setCodeTheme(String codeTheme) {
        PREF.put(Key.CODE_THEME.toString(), codeTheme);
    }

    public void setCodeFont(String font) {
        String[] f = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        if (Arrays.asList(f).contains(font)) {
            PREF.put(Key.CODE_FONT.toString(), font);
        }
    }

    public String getQueryWrapPre() {
        return PREF.get(Key.QUERY_WRAP_PRE.toString(), "");
    }

    public void setQueryWrapPost(String queryWrapPost) {
        if (queryWrapPost != null) {
            PREF.put(Key.QUERY_WRAP_POST.toString(), queryWrapPost);
        }
    }

    public String getQueryWrapPost() {
        return PREF.get(Key.QUERY_WRAP_POST.toString(), "");
    }

    public void setQueryWrapPre(String queryWrapPre) {
        if (queryWrapPre != null) {
            PREF.put(Key.QUERY_WRAP_PRE.toString(), queryWrapPre);
        }
    }

    public void setDefaultLoginUsername(String username) {
        if (username != null) {
            PREF.put(Key.LOGIN_USERNAME.toString(), PreferenceHelper.encode(username));
        }
    }

    public String getDefaultLoginUsername() {
        try {
            return PreferenceHelper.decode(PREF.get(Key.LOGIN_USERNAME.toString(), null));
        }
        catch (IOException e) {
            return "";
        }
    }

    public void setDefaultLoginPassword(String password) {
        if (password != null) {
            PREF.put(Key.LOGIN_PASSWORD.toString(), PreferenceHelper.encode(password));
        }
    }

    public String getDefaultLoginPassword() {
        try {
            return PreferenceHelper.decode(PREF.get(Key.LOGIN_PASSWORD.toString(), null));
        }
        catch (IOException e) {
            return "";
        }
    }

    public void setCriticalServerKeywords(String criticalKeywordsCommaSeparated) {
        if (criticalKeywordsCommaSeparated != null) {
            PREF.put(Key.CRITICAL_KEYWORDS.toString(), criticalKeywordsCommaSeparated);
        }
    }

    public String getCriticalServerKeywords() {
        return PREF.get(Key.CRITICAL_KEYWORDS.toString(), DEFAULT_CRITICAL_KEYWORDS);
    }

    public void setIgnoreFilterRegex(String ignoreFilterRegex) {
        if (ignoreFilterRegex != null) {
            PREF.put(Key.IGNORE_FOLDER_REGEX.toString(), ignoreFilterRegex);
        }
    }

    public String getIgnoreFilterRegex() {
        return PREF.get(Key.IGNORE_FOLDER_REGEX.toString(), DEFAULT_IGNORE_FOLDER_REGEX);
    }

    void setOpenAIkey(String openAIkey) {
        if (openAIkey != null) {
            PREF.put(Key.OPENAI_KEY.toString(), openAIkey);
        }
    }

    public String getOpenAIkey() {
        return PREF.get(Key.OPENAI_KEY.toString(), "");
    }

    public void setCriticalServerColor(Color color) {
        if (color != null) {
            PREF.putInt(Key.CRITICAL_COLOR.toString(), color.getRGB());
        }
    }

    public Color getCriticalServerColor() {
        int c2 = PREF.getInt(Key.CRITICAL_COLOR.toString(), DEFAULT_CRITICAL_COLOR);
        return new Color(c2);
    }

    public boolean isConnectionPersistent() {
        return PREF.getBoolean(Key.CONNECTION_PERSISTENT.toString(), true);
    }

    public void setConnectionPersistent(boolean connectionPersistent) {
        PREF.putBoolean(Key.CONNECTION_PERSISTENT.toString(), connectionPersistent);
    }

    public boolean isShowTooltips() {
        return PREF.getBoolean(Key.SHOW_TOOLTIPS.toString(), true);
    }

    public void setShowTooltips(boolean showTooltips) {
        PREF.putBoolean(Key.SHOW_TOOLTIPS.toString(), showTooltips);
    }

    public int getUIScale() {
        int def = 100;
        try {
            int w = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode().getWidth();
            def = w > 2000 ? 150 : 100;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return PREF.getInt(Key.UISCALE.toString(), def);
    }

    public void setUIScale(int UIScale2) {
        PREF.putInt(Key.UISCALE.toString(), UIScale2);
    }

    public void setMaxConsoleLength(int maxLength) {
        Preconditions.checkArgument(maxLength >= 1000);
        PREF.putInt(Key.MAX_CONSOLE_LENGTH.toString(), maxLength);
    }

    public int getMaxConsoleLength() {
        return PREF.getInt(Key.MAX_CONSOLE_LENGTH.toString(), 16000);
    }

    public Set<String> getHiddenNamespaces() {
        String[] ns = PREF.get(Key.HID_NS.toString(), DEFAULT_HID_NS).split(" ");
        return new HashSet<String>(Arrays.asList(ns));
    }

    public void setHiddenNamespaces(String[] hiddenNamespaces) {
        Preconditions.checkNotNull(hiddenNamespaces);
        PREF.put(Key.HID_NS.toString(), Joiner.on(' ').join(hiddenNamespaces));
    }

    public void setMaxReturnSizeMB(int maxSizeMB) {
        long l = maxSizeMB < 2000 ? (long)maxSizeMB * 1024L * 1024L : 0L;
        this.setMaxReturnSize(l);
    }

    public void setMaxReturnSize(long maxSize) {
        Preconditions.checkArgument(maxSize >= 0L);
        PREF.putLong(Key.MAX_RET.toString(), maxSize);
    }

    public long getMaxReturnSize() {
        return PREF.getLong(Key.MAX_RET.toString(), 0xA00000L);
    }

    public void setMaximumFractionDigits(int decimalPlaces) {
        if (decimalPlaces < 0) {
            decimalPlaces = 0;
        }
        PREF.putInt(Key.FRACTION_DIGITS.toString(), decimalPlaces);
    }

    public int getMaximumFractionDigits() {
        return PREF.getInt(Key.FRACTION_DIGITS.toString(), 7);
    }

    public void setNumberGroupingSize(int groupingSize) {
        if (groupingSize < 0) {
            groupingSize = 0;
        }
        PREF.putInt(Key.NUMBER_GROUPING_SIZE.toString(), groupingSize);
    }

    public int getNumberGroupingSize() {
        return PREF.getInt(Key.NUMBER_GROUPING_SIZE.toString(), 0);
    }

    public void setQueryLogging(boolean on) {
        PREF.putBoolean(Key.QUERY_LOGGING.toString(), on);
    }

    public boolean isQueryLogging() {
        return PREF.getBoolean(Key.QUERY_LOGGING.toString(), false);
    }

    public void setQueryLoggingFolder(String filepath) {
        PREF.put(Key.QUERY_LOGGING_FOLDER.toString(), filepath);
    }

    public String getQueryLoggingFolder() {
        return PREF.get(Key.QUERY_LOGGING_FOLDER.toString(), DEFAULT_QUERY_LOGGING_FOLDER);
    }

    public boolean isQueryWrapped() {
        return PREF.getBoolean(Key.QUERY_WRAPPED.toString(), true);
    }

    public boolean isSaveWithWindowsLineEndings() {
        return PREF.getBoolean(Key.SAVE_WITH_WINDOWS_LINE_ENDINGS.toString(), DEFAULT_SAVE_WITH_WINDOWS_LINE_ENDINGS);
    }

    public boolean isSendTelemetry() {
        return PREF.getBoolean(Key.SEND_TELEMETRY.toString(), true);
    }

    public void setSendTelemetry(boolean isSendTelemetry) {
        PREF.putBoolean(Key.SEND_TELEMETRY.toString(), isSendTelemetry);
    }

    public void setQueryWrapped(boolean queryWrapped) {
        PREF.putBoolean(Key.QUERY_WRAPPED.toString(), queryWrapped);
    }

    public void setSaveWithWindowsLineEndings(boolean saveWithWindowsLineEndings) {
        PREF.putBoolean(Key.SAVE_WITH_WINDOWS_LINE_ENDINGS.toString(), saveWithWindowsLineEndings);
    }

    public int getMaxReturnSizeMB() {
        return (int)(this.getMaxReturnSize() / 0x100000L);
    }

    public String toXML() {
        ByteArrayOutputStream baOS = new ByteArrayOutputStream();
        String s = null;
        try {
            PREF.exportSubtree(baOS);
            s = baOS.toString();
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Couldn't convert preferences to xml", e);
        }
        catch (BackingStoreException e) {
            LOG.log(Level.WARNING, "Couldn't convert preferences to xml", e);
        }
        return s;
    }

    public static void importXML(String xmlSettings) {
        if (xmlSettings != null) {
            ByteArrayInputStream is = new ByteArrayInputStream(xmlSettings.getBytes());
            try {
                Preferences.importPreferences(is);
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Couldn't import xml preferences", e);
            }
            catch (InvalidPreferencesFormatException e) {
                LOG.log(Level.WARNING, "Couldn't import xml preferences", e);
            }
        }
    }

    public void addListener(Listener l) {
        this.listeners.add(l);
    }

    public void removeListener(Listener l) {
        this.listeners.remove(l);
    }

    public void notifyListeners() {
        for (Listener l : this.listeners) {
            l.changeEvent();
        }
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().indexOf("win") >= 0;
    }

    static {
        LOG = Logger.getLogger(MyPreferences.class.getName());
        PREF = Preferences.userNodeForPackage(MyPreferences.class);
        DEFAULT_SAVE_WITH_WINDOWS_LINE_ENDINGS = MyPreferences.isWindows();
        DEFAULT_CRITICAL_COLOR = Color.RED.getRGB();
        DEFAULT_QUERY_LOGGING_FOLDER = System.getProperty("user.home");
    }

    static interface Listener {
        public void changeEvent();
    }

    private static enum Key {
        HID_NS,
        MAX_RET,
        MAX_ROWS_SHOWN,
        MAX_CONSOLE_LENGTH,
        CODE_FONT_SIZE,
        QUERY_WRAPPED,
        CODE_FONT,
        QUERY_WRAP_PRE,
        QUERY_WRAP_POST,
        CONNECTION_PERSISTENT,
        FRACTION_DIGITS,
        QUERY_LOGGING,
        QUERY_LOGGING_FOLDER,
        CODE_THEME,
        LOGIN_USERNAME,
        LOGIN_PASSWORD,
        CRITICAL_KEYWORDS,
        CRITICAL_COLOR,
        SAVE_WITH_WINDOWS_LINE_ENDINGS,
        IGNORE_FOLDER_REGEX,
        OPENAI_KEY,
        SEND_TELEMETRY,
        SHOW_TOOLTIPS,
        NUMBER_GROUPING_SIZE,
        UISCALE;

    }
}

