/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio;

import com.google.common.base.Preconditions;
import com.timestored.StringUtils;
import com.timestored.connections.JdbcTypes;
import com.timestored.connections.ServerConfig;
import com.timestored.kdb.KError;
import com.timestored.misc.AIFacade;
import com.timestored.misc.HtmlUtils;
import com.timestored.qstudio.BackgroundExecutor;
import com.timestored.qstudio.CommonActions;
import com.timestored.qstudio.GrabItem;
import com.timestored.qstudio.GrabableContainer;
import com.timestored.qstudio.MyPreferences;
import com.timestored.qstudio.PivotForm;
import com.timestored.qstudio.PivotFormConfig;
import com.timestored.qstudio.UpdateHelper;
import com.timestored.qstudio.kdb.KdbHelper;
import com.timestored.qstudio.model.AdminModel;
import com.timestored.qstudio.model.QEntity;
import com.timestored.qstudio.model.QueryAdapter;
import com.timestored.qstudio.model.QueryManager;
import com.timestored.qstudio.model.QueryResult;
import com.timestored.qstudio.model.ServerModel;
import com.timestored.qstudio.servertree.SelectedServerObjectPanel;
import com.timestored.sqldash.chart.TableFactory;
import com.timestored.theme.Theme;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import kx.c;

class KDBResultPanel
extends JPanel
implements GrabableContainer {
    private static final long serialVersionUID = 1L;
    private final SelectedServerObjectPanel selectedServerObjectPanel;
    private QueryResult lastQueryResult;
    private QueryManager queryManager;
    private int maxRowsShown = Integer.MAX_VALUE;
    private boolean pivotFormVisible = false;

    KDBResultPanel(AdminModel adminModel, QueryManager queryManager) {
        this.setLayout(new BorderLayout());
        this.selectedServerObjectPanel = new SelectedServerObjectPanel(adminModel, queryManager);
        this.queryManager = queryManager;
        queryManager.addQueryListener(new QueryAdapter(){

            @Override
            public void queryResultReturned(ServerConfig sc, QueryResult qr) {
                KDBResultPanel.this.lastQueryResult = qr;
                KDBResultPanel.this.regenerateDisplay(qr);
            }

            @Override
            public void sendingQuery(ServerConfig sc, String query) {
                KDBResultPanel.this.lastQueryResult = null;
                String txt = sc.getName() + "<- " + query;
                KDBResultPanel.this.clearAndSetContent(Theme.getTextArea("querySent", txt));
            }
        });
        adminModel.addListener(new AdminModel.Listener(){

            @Override
            public void modelChanged() {
            }

            @Override
            public void modelChanged(ServerModel sm) {
            }

            @Override
            public void selectionChanged(ServerModel serverModel, AdminModel.Category category, String namespace, QEntity element) {
                KDBResultPanel.this.lastQueryResult = null;
                KDBResultPanel.this.clearAndSetContent(KDBResultPanel.this.selectedServerObjectPanel);
            }
        });
        BackgroundExecutor.EXECUTOR.execute(() -> {
            JPanel p = new JPanel(new BorderLayout());
            String licTxt = "Version: <b>4.07</b>";
            p.add((Component)Theme.getHtmlText(licTxt), "North");
            if (queryManager.hasAnyServers()) {
                JdbcTypes jdbcTypes = adminModel.getConnectionManager().containsKdbServer() ? JdbcTypes.KDB : null;
                p.add((Component)UpdateHelper.getNewsPanel(jdbcTypes), "Center");
            }
            this.clearAndSetContent(p);
        });
    }

    private void regenerateDisplay(QueryResult qr) {
        boolean isNonNullKdbResult;
        boolean bl = isNonNullKdbResult = qr.k != null || qr.getConsoleView().length() > 0 && !qr.getConsoleView().equals("::");
        if (isNonNullKdbResult || qr.rs != null) {
            this.clearAndSetContent(KDBResultPanel.getComponent(qr, this.maxRowsShown, this.queryManager, this.pivotFormVisible));
        } else if (qr.getConsoleView().length() > 0) {
            String txt = qr.getConsoleView();
            this.clearAndSetContent(new JScrollPane(Theme.getTextArea("consoleView", txt)));
        }
    }

    static Component getComponent(QueryResult qr, int maxRowsShown, QueryManager queryManager, boolean pivotFormVisible) {
        JdbcTypes jdbcType;
        Component p = new JLabel("Result returned for query: " + qr.query);
        JdbcTypes jdbcTypes = jdbcType = qr.getServerConfig() != null ? qr.getServerConfig().getJdbcType() : JdbcTypes.KDB;
        if (qr.isCancelled() || qr.isException()) {
            String errMsg = qr.getE() == null ? null : qr.getE().toString();
            Box searchBox = KDBResultPanel.getSearchBoxes(qr.getQuery(), errMsg, jdbcType);
            if (qr.e instanceof c.KException) {
                p = KError.getDescriptionComponent((c.KException)qr.e);
            } else {
                JScrollPane newsPanel = UpdateHelper.getNewsPanel(jdbcType);
                JTextArea errDetails = Theme.getTextArea("qryErr", errMsg);
                int sz = MyPreferences.INSTANCE.getCodeFontSize();
                Font f = new Font(MyPreferences.INSTANCE.getCodeFont(), 0, sz);
                errDetails.setFont(f);
                p = Theme.getErrorBox(qr.getConsoleView(), searchBox, errDetails, newsPanel);
            }
        } else if (qr.k != null || qr.rs != null) {
            Box b = Box.createVerticalBox();
            p = b;
            try {
                if (pivotFormVisible && qr.rs != null) {
                    PivotFormConfig pc;
                    PivotFormConfig pivotFormConfig = pc = qr.getPivotConfig() == null ? new PivotFormConfig(qr.query, qr.rs.getMetaData()) : qr.getPivotConfig();
                    if (pc.getByColsShown().size() >= 1) {
                        PivotForm form = new PivotForm(pivotConfig -> queryManager.sendQuery((PivotFormConfig)pivotConfig, qr.query, null));
                        form.setDisplay(pc, qr.getQuery());
                        form.setPreferredSize(new Dimension(Integer.MAX_VALUE, 30));
                        form.setMaximumSize(new Dimension(Integer.MAX_VALUE, 90));
                        b.add(form);
                    }
                }
            }
            catch (SQLException e1) {
                b.add(new JLabel("Problem adding PulsePivot Form"));
            }
            if (qr.k != null) {
                b.add(KdbHelper.getComponent(qr.k, maxRowsShown));
            } else {
                try {
                    b.add(TableFactory.getTable(qr.rs, maxRowsShown));
                }
                catch (SQLException e) {
                    p = Theme.getErrorBox("Error rendering Table Result Set", new Component[0]);
                }
            }
        } else {
            String txt = qr.getConsoleView();
            if (qr.isKResultTooLarge()) {
                txt = "Data was too large to return, adjust maximum allowed size in settings if desired.\r\nconsole view:\r\n\r\n" + qr.getConsoleView();
            }
            p = new JScrollPane(Theme.getTextArea("consoleView", txt));
        }
        JPanel panel = new JPanel(new BorderLayout());
        if (p != null) {
            panel.add(p);
            p.setName("kdbResultPanel");
        }
        panel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        return panel;
    }

    private static Box getSearchBoxes(String qry, String errMsg, JdbcTypes jdbcType) {
        String db = jdbcType == null ? "" : jdbcType.getNiceName() + " ";
        Box box = Box.createHorizontalBox();
        JButton googButton = new JButton("Google", Theme.CIcon.GOOGLE.get16());
        try {
            String googQry = URLEncoder.encode(db + errMsg, "UTF-8");
            googButton.addActionListener(e -> HtmlUtils.browse("https://www.google.com?q=" + googQry));
        }
        catch (UnsupportedEncodingException e1) {
            googButton.setEnabled(false);
            googButton.setToolTipText("Error translating query.");
        }
        JButton openAiButton = new JButton("AI", Theme.CIcon.AI.get16());
        openAiButton.addActionListener(e -> {
            boolean hasKey = CommonActions.checkForOpenAIkey();
            if (hasKey) {
                openAiButton.setEnabled(false);
                BackgroundExecutor.EXECUTOR.execute(() -> {
                    try {
                        String aiQry = "I ran the SQL query: \n```\n" + qry + "\n```\nwhich causes this SQL database error in " + db + ": " + errMsg + "\nWhat is causing the error and how do I fix it?";
                        AIFacade.AIresult r = AIFacade.queryOpenAIstructured(aiQry);
                        JOptionPane.showMessageDialog(null, r.getFirstContent());
                        openAiButton.setEnabled(true);
                    }
                    catch (IOException e1) {
                        openAiButton.setEnabled(false);
                        openAiButton.setToolTipText("Error translating query.");
                    }
                });
            }
        });
        JButton copyToClipboardButton = new JButton("Copy to Clipboard", Theme.CIcon.EDIT_COPY.get16());
        copyToClipboardButton.addActionListener(e -> {
            Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
            clpbrd.setContents(new StringSelection(errMsg), null);
        });
        box.add(googButton);
        box.add(openAiButton);
        box.add(copyToClipboardButton);
        return box;
    }

    public void clearAndSetContent(final Component comp) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                KDBResultPanel.this.removeAll();
                KDBResultPanel.this.add(comp, "Center");
                KDBResultPanel.this.revalidate();
            }
        });
    }

    public void setMaximumRowsShown(int maxRowsShown) {
        Preconditions.checkArgument(maxRowsShown > 0);
        this.maxRowsShown = maxRowsShown;
    }

    @Override
    public GrabItem grab() {
        if (this.lastQueryResult != null) {
            String title = StringUtils.abbreviate(this.lastQueryResult.query, 50) + " - Result";
            return new GrabItem(KDBResultPanel.getComponent(this.lastQueryResult, this.maxRowsShown, this.queryManager, false), title);
        }
        return null;
    }

    public void togglePivotFormVisible() {
        boolean bl = this.pivotFormVisible = !this.pivotFormVisible;
        if (this.lastQueryResult != null) {
            this.regenerateDisplay(this.lastQueryResult);
        }
    }
}

