/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.timestored.docs.Document;
import com.timestored.docs.OpenDocumentsModel;
import com.timestored.messages.Msg;
import com.timestored.qdoc.HtmlPqfOutputter;
import com.timestored.swingxx.SwingUtils;
import com.timestored.theme.Theme;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class GenerateDocumentationAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(GenerateDocumentationAction.class.getName());
    private final OpenDocumentsModel openDocumentsModel;
    private File lastSelectedDocGenFolder;

    public GenerateDocumentationAction(OpenDocumentsModel openDocumentsModel) {
        super(Msg.get(Msg.Key.GENERATE), Theme.CIcon.TEXT_HTML.get16());
        this.openDocumentsModel = Preconditions.checkNotNull(openDocumentsModel);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.runQDocAction();
    }

    private void runQDocAction() {
        JFileChooser fc = this.lastSelectedDocGenFolder == null ? new JFileChooser() : new JFileChooser(this.lastSelectedDocGenFolder);
        fc.setFileSelectionMode(1);
        fc.setDialogTitle(Msg.get(Msg.Key.SELECT_DOC_DIR));
        fc.setDialogType(1);
        fc.setApproveButtonText(Msg.get(Msg.Key.GENERATE2));
        if (fc.showSaveDialog(null) == 0) {
            this.lastSelectedDocGenFolder = fc.getSelectedFile();
            List<Document> docs = this.openDocumentsModel.getDocuments();
            List<String> errors = HtmlPqfOutputter.output(docs, this.lastSelectedDocGenFolder, null);
            if (errors.size() > 0) {
                String title = Msg.get(Msg.Key.ERROR_GENERATING_DOCS);
                String message = Joiner.on("\r\n").join(errors);
                JOptionPane.showMessageDialog(null, message, title, 0);
            } else {
                File f = new File(this.lastSelectedDocGenFolder.getAbsolutePath() + File.separator + "index.html");
                SwingUtils.offerToOpenFile(Msg.get(Msg.Key.DOCS_GENERATED), f, Msg.get(Msg.Key.OPEN_DOCS_NOW), Msg.get(Msg.Key.CLOSE));
            }
        } else {
            LOG.info("Generate documentation command cancelled by user.");
        }
    }
}

