/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio;

import java.awt.Color;
import javax.swing.UIManager;
import jsyntaxpane.util.Configuration;

public class EditorConfigFactory {
    private static final EditorConfig LIGHT = new LightEditorConfig();
    private static final EditorConfig DARK = new DarkEditorConfig();
    private static final String[] NAMES = new String[]{"Light", "Dark"};

    public static EditorConfig get() {
        return LIGHT;
    }

    public static EditorConfig get(TCOLOR name) {
        if (name != null && name.equals((Object)TCOLOR.DARK)) {
            return DARK;
        }
        return LIGHT;
    }

    public static String[] getNames() {
        return NAMES;
    }

    private static class LightEditorConfig
    implements EditorConfig {
        private LightEditorConfig() {
        }

        @Override
        public void apply(Configuration c2) {
            c2.put("Style.COMMENT", "0x33AA33, 2");
            c2.put("Style.COMMENT2", "0x33AA33, 3");
            c2.put("Style.TYPE", "0x56B6C2, 2");
            c2.put("Style.NUMBER", "0x999933, 0");
            c2.put("Style.REGEX", "0x85502B, 0");
            c2.put("Style.OPERATOR", "0x222244, 0");
            c2.put("Style.STRING", "0xCC6600, 0");
            c2.put("Style.STRING2", "0x663300, 0");
            c2.put("Style.DELIMITER", "0xA658BD, 0");
            c2.put("Style.TYPE3", "0xE5A07B, 0");
            c2.put("Style.ERROR", "0xCC0000, 3");
            c2.put("Style.DEFAULT", "0x000000, 0");
            c2.put("Style.KEYWORD", "0x3333ee, 0");
            c2.put("Style.KEYWORD2", "0x2222CC, 0");
            c2.put("Style.TYPE2", "0xC07F54, 0");
            c2.put("Style.WARNING", "0xCC0000, 0");
            c2.put("Style.IDENTIFIER", "0x000000, 0");
            c2.put("SelectionColor", "0x99ccff");
            c2.put("CaretColor", "0x000000");
            c2.put("PairMarker.Color", "0xFF5555");
            c2.put("TokenMarker.Color", "0xEEAAFF");
            c2.put("LineNumbers.CurrentBack", "0xcccccc");
            c2.put("LineNumbers.Foreground", "0x333333");
            c2.put("LineNumbers.Background", "0xe6e6e6");
            c2.put("SingleColorSelect", "false");
            c2.put("RightMarginColumn", "80");
            c2.put("RightMarginColor", "0xEEEEEE");
        }
    }

    private static class DarkEditorConfig
    implements EditorConfig {
        final String FG = "ABB2BF";

        private DarkEditorConfig() {
        }

        @Override
        public void apply(Configuration c2) {
            c2.put("Style.COMMENT", "0x777777, 2");
            c2.put("Style.COMMENT2", "0x339933, 3");
            c2.put("Style.TYPE", "0x56B6C2, 2");
            c2.put("Style.NUMBER", "0x999933, 0");
            c2.put("Style.REGEX", "0xE5A07B, 0");
            c2.put("Style.OPERATOR", "0xCCCCCC, 0");
            c2.put("Style.STRING", "0x98C379, 0");
            c2.put("Style.STRING2", "0x689349, 0");
            c2.put("Style.DELIMITER", "0xC678DD, 0");
            c2.put("Style.TYPE3", "0xE5A07B, 0");
            c2.put("Style.ERROR", "0xCC0000, 3");
            c2.put("Style.DEFAULT", "0xFFFF00, 0");
            c2.put("Style.KEYWORD", "0x61AFEF, 0");
            c2.put("Style.KEYWORD2", "0x9F73A0, 0");
            c2.put("Style.TYPE2", "0xC07F54, 0");
            c2.put("Style.WARNING", "0xcc0000, 0");
            c2.put("Style.IDENTIFIER", "0xABB2BF, 0");
            c2.put("SelectionColor", "0x99ccff");
            c2.put("CaretColor", DarkEditorConfig.getColor("TextArea.caretForeground", "0xeeffcc"));
            c2.put("PairMarker.Color", "0xAA0000");
            c2.put("TokenMarker.Color", "0x214FAF");
            c2.put("LineNumbers.CurrentBack", "0x222211");
            c2.put("LineNumbers.Foreground", "0xAAAADD");
            c2.put("LineNumbers.Background", "0x333333");
            c2.put("SelectionColor", "0x1659BB");
            c2.put("SingleColorSelect", "false");
            c2.put("RightMarginColumn", "0");
            c2.put("RightMarginColor", "0x222222");
        }

        private static String getColor(String name, String defColor) {
            Color c2 = UIManager.getColor(name);
            return c2 != null ? "0x" + Integer.toHexString(c2.getRGB()).substring(2) : defColor;
        }
    }

    public static enum TCOLOR {
        LIGHT,
        DARK;

    }

    public static interface EditorConfig {
        public void apply(Configuration var1);
    }
}

