/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio;

import com.google.common.base.MoreObjects;
import com.timestored.docs.Document;
import com.timestored.qstudio.MyPreferences;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JEditorPane;
import javax.swing.ToolTipManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

class DocEditorPane
extends JEditorPane {
    private static final long serialVersionUID = 1L;
    private static final String NL = System.getProperty("line.separator");
    private final Document document;
    private TooltipProvider tooltipProvider = null;
    private boolean modifyingSelf;

    public DocEditorPane(final Document document) {
        this.document = document;
        this.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                if (!DocEditorPane.this.modifyingSelf) {
                    DocEditorPane.this.modifyingSelf = true;
                    String t = DocEditorPane.this.getText().replaceAll(NL, "\n");
                    if (!t.equals(document.getContent())) {
                        document.setContent(t);
                    }
                    document.setSelection(DocEditorPane.this.getSelectionStart(), DocEditorPane.this.getSelectionEnd(), e.getDot());
                    DocEditorPane.this.modifyingSelf = false;
                }
            }
        });
        document.addListener(new Document.Listener(){

            @Override
            public void docContentModified() {
                DocEditorPane.this.refreshContent();
            }

            @Override
            public void docCaratModified() {
                int docPos = document.getCaratPosition();
                if (docPos != DocEditorPane.this.getCaretPosition()) {
                    DocEditorPane.this.setCaretPosition(docPos);
                }
            }

            @Override
            public void docSaved() {
            }
        });
        this.refreshContent();
        this.setCaretPosition(document.getCaratPosition());
        this.requestFocus();
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    Point getPopupPoint() {
        Point screen = this.getLocationOnScreen();
        Point carat = this.getCaret().getMagicCaretPosition();
        if (carat != null) {
            return new Point(screen.x + carat.x, screen.y + carat.y + 20);
        }
        return new Point(screen.x, screen.y + 20);
    }

    public Document getDoc() {
        return this.document;
    }

    public void setTooltipProvider(TooltipProvider tooltipProvider) {
        this.tooltipProvider = tooltipProvider;
    }

    private void refreshContent() {
        boolean textDiff;
        String docText = this.document.getContent();
        String editorText = this.getText().replaceAll(System.getProperty("line.separator"), "\n");
        boolean bl = textDiff = docText != null && editorText != null && docText.length() > 0 && !docText.equals(editorText) || !this.document.getContent().equals(editorText);
        if (textDiff) {
            this.modifyingSelf = true;
            this.setText(docText);
            this.setSelectionStart(this.document.getSelectionStart());
            this.setSelectionEnd(this.document.getSelectionEnd());
            this.setCaretPosition(this.document.getCaratPosition());
            this.modifyingSelf = false;
            this.requestFocus();
        }
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        if (this.tooltipProvider != null && MyPreferences.INSTANCE.isShowTooltips()) {
            Point pt = new Point(e.getX(), e.getY());
            return this.tooltipProvider.getToolTipText(e, this.viewToModel(pt));
        }
        return null;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("document", this.document).toString();
    }

    public static interface TooltipProvider {
        public String getToolTipText(MouseEvent var1, int var2);
    }
}

