/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio;

import com.timestored.TimeStored;
import com.timestored.command.Command;
import com.timestored.command.CommandProvider;
import com.timestored.misc.HtmlUtils;
import com.timestored.qdoc.BuiltinDocumentedEntities;
import com.timestored.qdoc.DocumentationDialog;
import com.timestored.qdoc.DocumentedEntity;
import com.timestored.qdoc.DocumentedEntityDocCommand;
import com.timestored.qdoc.DocumentedMatcher;
import com.timestored.qstudio.KDBResultPanel;
import com.timestored.theme.Theme;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

class DisplayQDocCommandProvider
implements CommandProvider {
    private final KDBResultPanel kdbResultPanel;
    private final DocumentedMatcher documentedMatcher;

    DisplayQDocCommandProvider(DocumentedMatcher documentedMatcher, KDBResultPanel kdbResultPanel) {
        this.documentedMatcher = documentedMatcher;
        this.kdbResultPanel = kdbResultPanel;
    }

    @Override
    public Collection<Command> getCommands() {
        List<? extends DocumentedEntity> docs = this.documentedMatcher.getDocs();
        ArrayList<Command> r = new ArrayList<Command>();
        for (final DocumentedEntity documentedEntity : docs) {
            if (documentedEntity.getHtmlDoc(false).trim().isEmpty()) continue;
            DocumentedEntityDocCommand docCommand = new DocumentedEntityDocCommand(documentedEntity, true, "Display qDoc: "){

                @Override
                public void perform() {
                    if (documentedEntity instanceof BuiltinDocumentedEntities && HtmlUtils.isBrowseSupported()) {
                        String url = ((BuiltinDocumentedEntities)documentedEntity).getLink();
                        HtmlUtils.browse(TimeStored.getRedirectPage(url, "qdoc"));
                    } else {
                        JPanel p = DocumentationDialog.getDocPanel(documentedEntity);
                        DisplayQDocCommandProvider.this.kdbResultPanel.clearAndSetContent(p);
                    }
                }

                @Override
                public ImageIcon getIcon() {
                    return Theme.CIcon.TEXT_HTML.get16();
                }
            };
            r.add(docCommand);
        }
        return r;
    }
}

