/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio;

import com.timestored.StringUtils;
import com.timestored.babeldb.DBHelper;
import com.timestored.connections.ServerConfig;
import com.timestored.qstudio.GrabItem;
import com.timestored.qstudio.GrabableContainer;
import com.timestored.qstudio.model.QueryListener;
import com.timestored.qstudio.model.QueryResult;
import com.timestored.swingxx.ScrollingTextArea;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseWheelListener;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JPanel;

class ConsolePanel
extends JPanel
implements QueryListener,
GrabableContainer {
    private static final long serialVersionUID = 1L;
    private static final int FONT_SIZE = 12;
    private static final Color FG_COLOR = new Color(240, 240, 240);
    private final ScrollingTextArea scText;
    private QueryResult latestQR;

    public ConsolePanel() {
        this.setName("consolePanel");
        this.setLayout(new BorderLayout());
        this.scText = new ScrollingTextArea(FG_COLOR, Color.BLACK);
        this.scText.setTextareaFont(new Font("Monospaced", 0, 12));
        this.add((Component)this.scText, "Center");
    }

    @Override
    public void queryResultReturned(ServerConfig sc, QueryResult qr) {
        this.latestQR = qr;
        String txt = "";
        if (sc.isKDB() || qr.getConsoleView().length() > 2) {
            txt = qr.getConsoleView();
        } else if (qr.rs != null) {
            int count = -1;
            try {
                count = DBHelper.getSize(qr.rs);
                txt = count + " rows returned";
                if (count == 1 && qr.rs.getMetaData().getColumnCount() == 1) {
                    qr.rs.beforeFirst();
                    qr.rs.next();
                    txt = "" + qr.rs.getObject(1);
                } else if (count <= 30) {
                    txt = DBHelper.toString(qr.rs, false);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.app(txt);
    }

    @Override
    public void sendingQuery(ServerConfig sc, String query) {
        this.app((sc.isKDB() ? "q)" : ">") + query);
    }

    @Override
    public void selectedServerChanged(String server) {
        this.app("##Server Changed to ->" + server);
    }

    private void app(String msg) {
        this.scText.appendMessage(msg);
    }

    @Override
    public void serverListingChanged(List<String> serverNames) {
    }

    public void setCodeFont(Font f) {
        this.scText.setTextareaFont(f);
    }

    @Override
    public synchronized void addMouseWheelListener(MouseWheelListener l) {
        this.scText.addMouseWheelListener(l);
    }

    public void setMaxLength(int maxConsoleLength) {
        this.scText.setMaxLength(maxConsoleLength);
    }

    @Override
    public GrabItem grab() {
        if (this.latestQR != null) {
            ScrollingTextArea con = new ScrollingTextArea(FG_COLOR, Color.BLACK);
            con.setTextareaFont(this.scText.getTextareaFont());
            con.appendMessage(this.scText.getText());
            return new GrabItem(con, StringUtils.abbreviate(this.latestQR.getQuery(), 50) + " - Console");
        }
        return null;
    }
}

