/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.timestored.command.Command;
import com.timestored.command.CommandDialog;
import com.timestored.command.CommandManager;
import com.timestored.command.CommandProvider;
import com.timestored.connections.ConnectionManager;
import com.timestored.connections.ConnectionManagerDialog;
import com.timestored.connections.ConnectionShortFormat;
import com.timestored.connections.JdbcTypes;
import com.timestored.connections.ServerConfig;
import com.timestored.connections.ServerConfigBuilder;
import com.timestored.docs.Document;
import com.timestored.docs.OpenDocumentsModel;
import com.timestored.jgrowl.Growler;
import com.timestored.messages.Msg;
import com.timestored.misc.AIFacade;
import com.timestored.misc.HtmlUtils;
import com.timestored.qstudio.AddServerListAction;
import com.timestored.qstudio.BackgroundExecutor;
import com.timestored.qstudio.MyPreferences;
import com.timestored.qstudio.Persistance;
import com.timestored.qstudio.PreferencesDialog;
import com.timestored.qstudio.QStudioModel;
import com.timestored.qstudio.UpdateHelper;
import com.timestored.qstudio.kdb.CAtomTypes;
import com.timestored.qstudio.model.QueryAdapter;
import com.timestored.qstudio.model.QueryManager;
import com.timestored.qstudio.model.QueryResult;
import com.timestored.qstudio.model.ServerQEntity;
import com.timestored.qstudio.model.TableSQE;
import com.timestored.swingxx.AAction;
import com.timestored.theme.ShortcutAction;
import com.timestored.theme.Theme;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import lombok.NonNull;

public class CommonActions
implements CommandProvider {
    private static final Logger LOG = Logger.getLogger(CommonActions.class.getName());
    private static ActionPlugin proActionPlugin = null;
    private final Action copyServerHopenToClipboardAction;
    private final Action editCurrentServerAction;
    private final Action qAction;
    private final Action qLineAction;
    private final Action qFileAction;
    private final Action generateAIQueryAction;
    private final Action aIExplainAction;
    private final Action generateAIAction;
    private final Action googleAction;
    private final Action qCurrentStatementAction;
    private final Action disconnectAllAction;
    private final Action qLineAndMoveAction;
    private final Action qCancelQueryAction;
    private final Action sendClipboardQuery;
    private final QueryManager queryManager;
    private final Growler growler;
    private final Action addServerAction = new AddServerAction(null);
    private final Action serverSelectAction;
    private final Action addServerListAction;
    private final Action removeServerAction;
    private final AbstractAction copyServerListAction;
    private final List<Action> serverActions;
    private final List<Action> queryActions;
    private final List<Action> aiActions;
    private final List<Action> proActions;
    private final QStudioModel qStudioModel;
    private final OpenDocumentsModel openDocumentsModel;
    private final ConnectionManager connectionManager;
    private JFrame parent;
    public static final KeyStroke AUTO_COMPLETE_KS = KeyStroke.getKeyStroke(32, 2);

    CommonActions(QStudioModel qStudioModel, final JFrame parent, Persistance persistance, final Growler growler) {
        this.qStudioModel = Preconditions.checkNotNull(qStudioModel);
        this.openDocumentsModel = qStudioModel.getOpenDocumentsModel();
        this.queryManager = qStudioModel.getQueryManager();
        this.connectionManager = qStudioModel.getConnectionManager();
        this.parent = parent;
        this.growler = growler;
        this.proActions = proActionPlugin == null ? Collections.emptyList() : proActionPlugin.getActions(this, growler);
        this.qAction = new ShortcutAction(Msg.get(Msg.Key.QUERY_SELECTION), Theme.CIcon.GREEN_NEXT, "Send highlighted query to current server.", 69, 69){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                String qry = CommonActions.this.openDocumentsModel.getSelectedDocument().getSelectedText();
                if (qry.length() > 0) {
                    CommonActions.this.sendQuery(CommonActions.this.openDocumentsModel.getSelectedDocument().getSelectedText());
                } else {
                    CommonActions.this.sendQuery(CommonActions.this.openDocumentsModel.getSelectedDocument().getContent());
                }
                UpdateHelper.registerEvent("com_queryselection");
            }
        };
        this.editCurrentServerAction = new ShortcutAction("Edit current server", Theme.CIcon.SERVER_EDIT, "Edit the currently selected server."){

            @Override
            public void actionPerformed(ActionEvent e) {
                String serverName = CommonActions.this.queryManager.getSelectedServerName();
                if (serverName != null) {
                    new ConnectionManagerDialog(CommonActions.this.connectionManager, parent, serverName).setVisible(true);
                }
                UpdateHelper.registerEvent("com_editserver");
            }

            @Override
            public boolean isEnabled() {
                return CommonActions.this.queryManager.getSelectedServerName() != null;
            }
        };
        this.copyServerHopenToClipboardAction = new ShortcutAction("Copy hopen `:Server", Theme.CIcon.EDIT_COPY, "Copy an hopen command for the current server to the clipboard"){

            @Override
            public void actionPerformed(ActionEvent e) {
                String serverName = CommonActions.this.queryManager.getSelectedServerName();
                if (serverName != null) {
                    ServerConfig server = CommonActions.this.connectionManager.getServer(serverName);
                    if (server != null) {
                        Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
                        String hopenCommand = "hopen `$\":" + server.getHost() + ":" + server.getPort() + ":" + server.getUsername() + ":\"";
                        clpbrd.setContents(new StringSelection(hopenCommand), null);
                        growler.showInfo("Copied to clipboard:\r\n" + hopenCommand, "Clipboard Set");
                    }
                    UpdateHelper.registerEvent("com_copyhopen");
                }
            }
        };
        this.generateAIQueryAction = new GenerateAIQueryAction("AI Text to SQL");
        this.aIExplainAction = new AIExplainAction("AI Explain SQL");
        this.generateAIAction = new GenerateAIAction("Ask OpenAI");
        this.googleAction = new GoogleAction("Google");
        this.qLineAction = new ShortcutAction(Msg.get(Msg.Key.QUERY_LINE), Theme.CIcon.GREEN_PLAY, "Send current line as query", 10, 10){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonActions.this.sendQuery(CommonActions.this.openDocumentsModel.getSelectedDocument().getCurrentLine());
                UpdateHelper.registerEvent("com_queryline");
            }
        };
        this.qFileAction = new AAction("Query Full File", Theme.CIcon.SCRIPT_GO.get16(), al -> this.sendQuery(this.openDocumentsModel.getSelectedDocument().getContent()));
        KeyStroke shortcut = KeyStroke.getKeyStroke(10, 0x40 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        this.qFileAction.putValue("AcceleratorKey", shortcut);
        this.qFileAction.putValue("ShortDescription", "Run the full file.");
        boolean isMac = System.getProperty("os.name").toLowerCase().indexOf("mac") >= 0;
        KeyStroke ks = KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        if (isMac) {
            ks = KeyStroke.getKeyStroke(69, 0x200 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        }
        this.qCurrentStatementAction = new ShortcutAction("Query Current Statement", Theme.CIcon.BLUE_PLAY, "Send current statement as query", 81, ks){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isKdb;
                ServerConfig sc = CommonActions.this.connectionManager.getServer(CommonActions.this.queryManager.getSelectedServerName());
                boolean bl = isKdb = sc == null || sc.isKDB();
                if (isKdb) {
                    CommonActions.this.sendQuery(CommonActions.this.openDocumentsModel.getSelectedDocument().getCurrentLine());
                } else {
                    CommonActions.this.sendQuery(CommonActions.this.openDocumentsModel.getSelectedDocument().getCurrentStatement());
                }
                UpdateHelper.registerEvent("com_querycurrent");
            }
        };
        this.disconnectAllAction = new ShortcutAction("Disconnect All Databases", Theme.CIcon.DISCONNECT, "Disconnect from all database servers."){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonActions.this.connectionManager.close();
                try {
                    CommonActions.this.queryManager.close();
                }
                catch (Exception e1) {
                    LOG.warning("problem closing QM" + e1.toString());
                    growler.show("problem closing QM");
                }
                growler.show("All connections closed.");
            }
        };
        this.disconnectAllAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(115, 0));
        String qlDesc = "Query Line and Move";
        this.qLineAndMoveAction = new AbstractAction(qlDesc, Theme.CIcon.GREEN_FORWARD.get16()){

            @Override
            public void actionPerformed(ActionEvent e) {
                Document doc = CommonActions.this.openDocumentsModel.getSelectedDocument();
                String qry = doc.getCurrentLine();
                CommonActions.this.sendQuery("{x}" + qry, qry);
                doc.gotoNextLine();
                UpdateHelper.registerEvent("com_querylineandmove");
            }
        };
        this.qLineAndMoveAction.putValue("ShortDescription", qlDesc);
        int modifier = 3;
        KeyStroke kEnter = KeyStroke.getKeyStroke(10, modifier);
        this.qLineAndMoveAction.putValue("AcceleratorKey", kEnter);
        this.qCancelQueryAction = new ShortcutAction(Msg.get(Msg.Key.CANCEL_QUERY), Theme.CIcon.CANCEL, "Cancel the latest query", 67, 75){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonActions.this.queryManager.cancelQuery();
                UpdateHelper.registerEvent("com_querycancel");
            }
        };
        this.sendClipboardQuery = new ShortcutAction("Send clipboard as query", Theme.CIcon.EDIT_PASTE, "Send clipboard as query", 66, 66){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String qry = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
                    if (qry != null && qry.length() > 0) {
                        CommonActions.this.sendQuery(qry);
                    }
                }
                catch (IOException e1) {
                    LOG.log(Level.WARNING, "Send Query Error", e1);
                    growler.showSevere(e1.getMessage(), Msg.get(Msg.Key.ERROR));
                }
                catch (HeadlessException e1) {
                    LOG.log(Level.WARNING, "Send Query Error", e1);
                    growler.showSevere(e1.getMessage(), Msg.get(Msg.Key.ERROR));
                }
                catch (UnsupportedFlavorException e1) {
                    LOG.log(Level.WARNING, "Send Query Error", e1);
                    growler.showSevere(e1.getMessage(), Msg.get(Msg.Key.ERROR));
                }
            }
        };
        this.queryActions = Collections.unmodifiableList(Arrays.asList(this.disconnectAllAction, this.qAction, this.qLineAction, this.qFileAction, this.qCurrentStatementAction, this.qLineAndMoveAction, this.sendClipboardQuery, this.qCancelQueryAction));
        this.aiActions = Collections.unmodifiableList(Arrays.asList(this.generateAIAction, this.aIExplainAction, this.generateAIQueryAction, this.googleAction));
        this.queryManager.addQueryListener(new QueryAdapter(){

            @Override
            public void selectedServerChanged(String server) {
                CommonActions.this.refreshQButtonEnabledFlags();
            }

            @Override
            public void sendingQuery(ServerConfig sc, String query) {
                CommonActions.this.qCancelQueryAction.setEnabled(true);
            }

            @Override
            public void queryResultReturned(ServerConfig sc, QueryResult queryResult) {
                CommonActions.this.qCancelQueryAction.setEnabled(false);
            }
        });
        this.addServerListAction = new AddServerListAction(parent, this.connectionManager);
        this.serverSelectAction = new ShortcutAction(Msg.get(Msg.Key.FIND_SERVER), Theme.CIcon.EDIT_FIND, "Change the selected server by text searching.", 82, 82){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CommandDialog cd = new CommandDialog("Select Server:", CommonActions.this.queryManager.getChangeServerCommands(true), BackgroundExecutor.EXECUTOR);
                cd.setLocationRelativeTo(null);
                cd.setName("ServerNameDialog");
                cd.setVisible(true);
                UpdateHelper.registerEvent("com_addserverlist");
            }
        };
        this.removeServerAction = new AAction(Msg.get(Msg.Key.REMOVE_ALL_SERVERS), Theme.CIcon.DELETE.get16(), e -> {
            int choice = JOptionPane.showConfirmDialog(parent, "Delete all Server Connections?", Msg.get(Msg.Key.WARNING), 2);
            if (choice == 0) {
                this.connectionManager.removeServers();
            }
            UpdateHelper.registerEvent("com_removeallservers");
        });
        this.copyServerListAction = new AAction(Msg.get(Msg.Key.COPY_SERVER_LIST_TO_CLIPBOARD), Theme.CIcon.EDIT_COPY.get16(), e -> {
            String s = ConnectionShortFormat.compose(this.connectionManager.getServerConnections(), JdbcTypes.KDB);
            StringSelection sel = new StringSelection(s);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(sel, sel);
            UpdateHelper.registerEvent("com_copyserverlist");
        });
        this.serverActions = Collections.unmodifiableList(Arrays.asList(this.addServerAction, this.serverSelectAction, this.addServerListAction, this.copyServerListAction, this.removeServerAction, this.copyServerHopenToClipboardAction, this.editCurrentServerAction));
        this.refreshQButtonEnabledFlags();
    }

    public static int showDismissibleWarning(final Persistance persistance, final Persistance.Key warningKey, String msgHtml, String title, String confirmation, int defaultChoice) {
        int choice = defaultChoice;
        if (persistance.getBoolean(warningKey, true)) {
            final JCheckBox showWarningCheckBox = new JCheckBox("Do not show this information again");
            showWarningCheckBox.setName("checky");
            showWarningCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    persistance.putBoolean(warningKey, !showWarningCheckBox.isSelected());
                }
            });
            JPanel msg = new JPanel(new BorderLayout());
            msg.add((Component)Theme.getHtmlText(msgHtml), "Center");
            msg.add((Component)showWarningCheckBox, "South");
            Object[] buttons = new String[]{confirmation == null ? "Yes" : confirmation, "Cancel"};
            choice = JOptionPane.showOptionDialog(null, msg, title, 2, 1, null, buttons, buttons[0]);
        }
        return choice;
    }

    private void refreshQButtonEnabledFlags() {
        boolean serverAvailable = this.queryManager.getSelectedServerName() != null;
        this.qAction.setEnabled(serverAvailable);
        this.qLineAction.setEnabled(serverAvailable);
        this.qCurrentStatementAction.setEnabled(serverAvailable);
        this.qCancelQueryAction.setEnabled(serverAvailable);
        this.copyServerHopenToClipboardAction.setEnabled(serverAvailable);
        this.editCurrentServerAction.setEnabled(serverAvailable);
        if (serverAvailable) {
            ServerConfig sc = this.connectionManager.getServer(this.queryManager.getSelectedServerName());
            boolean enableKdb = sc == null || sc.isKDB();
            for (Action a : this.proActions) {
                a.setEnabled(enableKdb);
            }
            this.copyServerHopenToClipboardAction.setEnabled(enableKdb);
        }
    }

    private void sendQuery(String qry) {
        this.sendQuery(qry, null);
    }

    public synchronized void sendQuery(String qry, String queryTitle) {
        if (this.connectionManager.isEmpty()) {
            JOptionPane.showMessageDialog(this.parent, Msg.get(Msg.Key.NO_CONNECTIONS_DEFINED) + Msg.get(Msg.Key.PLEASE_ADD_SERVER_CONNECTION), Msg.get(Msg.Key.NO_CONNECTIONS), 2);
            return;
        }
        if (this.queryManager.isQuerying()) {
            String msg = "A query is currently in progress. \r\nYou must cancel that query before sending another.\r\n\r\nIf you want to query multiple servers simultaneously, open multiple qStudio instances.";
            String title = "Query in progress";
            JOptionPane.showMessageDialog(this.parent, msg, title, 2);
            return;
        }
        ServerConfig sc = this.connectionManager.getServer(this.queryManager.getSelectedServerName());
        String qryToRun = qry;
        try {
            if (this.openDocumentsModel.getSelectedDocument().getFileEnding().toLowerCase().equals("prql")) {
                qryToRun = CommonActions.compilePRQL(qry, sc.getJdbcType());
            }
            LOG.info("Send Query->" + qryToRun);
            this.queryManager.sendQuery(qryToRun, queryTitle);
        }
        catch (IllegalStateException ia) {
            LOG.log(Level.WARNING, "Send Query Error", ia);
            this.growler.showSevere(ia.getMessage(), Msg.get(Msg.Key.ERROR));
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Send Query Error", ex);
            this.growler.showSevere("Problem sending query to server", Msg.get(Msg.Key.ERROR));
            this.queryManager.sendQRtoListeners(sc, QueryResult.exceptionResult(sc, qryToRun, null, ex));
        }
    }

    public static String compilePRQL(String qry, JdbcTypes jdbcTypes) throws IOException {
        String target = CommonActions.getPrqlTarget(jdbcTypes);
        String[] commands = new String[]{"prqlc", "compile", "--hide-signature-comment", "--color", "never"};
        if (target != null && !qry.contains("prql target:")) {
            commands = new String[]{"prqlc", "compile", "--hide-signature-comment", "--color", "never", "--target", target};
        }
        Process process = new ProcessBuilder(commands).redirectErrorStream(true).start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        BufferedReader bre = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        OutputStream stdin = process.getOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stdin));
        writer.write(qry);
        writer.close();
        StringBuilder sb = new StringBuilder();
        StringBuilder errSb = new StringBuilder();
        String line = null;
        while ((line = reader.readLine()) != null) {
            sb.append(line);
            sb.append(System.getProperty("line.separator"));
        }
        reader.close();
        while ((line = bre.readLine()) != null) {
            System.err.println(line);
            errSb.append(line);
            errSb.append(System.getProperty("line.separator"));
        }
        bre.close();
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        if (process.exitValue() != 0) {
            throw new IOException("Non-zero exit value for runArgs:" + sb + System.getProperty("line.separator") + errSb);
        }
        UpdateHelper.registerEvent("com_compileprql");
        return sb.toString();
    }

    private static String getPrqlTarget(JdbcTypes jdbcTypes) {
        if (jdbcTypes == null) {
            return null;
        }
        String s = jdbcTypes.equals((Object)JdbcTypes.CLICKHOUSE) ? "clickhouse" : (jdbcTypes.equals((Object)JdbcTypes.DUCKDB) ? "duckdb" : (jdbcTypes.equals((Object)JdbcTypes.BABELDB) ? "duckdb" : (jdbcTypes.equals((Object)JdbcTypes.MSSERVER) ? "mssql" : (jdbcTypes.equals((Object)JdbcTypes.MYSQL) ? "mysql" : (jdbcTypes.equals((Object)JdbcTypes.POSTGRES) ? "postgres" : (jdbcTypes.equals((Object)JdbcTypes.SQLITE_JDBC) ? "sqlite" : (jdbcTypes.equals((Object)JdbcTypes.SNOWFLAKE) ? "snowflake" : null)))))));
        return s == null ? null : "sql." + s;
    }

    Action getqAction() {
        return this.qAction;
    }

    public Action getEditServerAction(ServerConfig sc) {
        return new EditServerAction(sc);
    }

    public Action getAddServerAction() {
        return this.addServerAction;
    }

    public Action getServerSelectAction() {
        return this.serverSelectAction;
    }

    public Action getCloseConnServerAction(ServerConfig sc) {
        return new CloseConnServerAction(sc);
    }

    public Action getCloneServerAction(ServerConfig sc) {
        return new CloneServerAction(sc);
    }

    public Action getAddServerAction(String folder) {
        Preconditions.checkNotNull(folder);
        return new AddServerAction(folder);
    }

    public Action getCopyServerHopenToClipboardAction() {
        return this.copyServerHopenToClipboardAction;
    }

    public Action getEditCurrentServerAction() {
        return this.editCurrentServerAction;
    }

    public List<Action> getServerActions() {
        return this.serverActions;
    }

    public Action getRemoveServerAction(final ServerConfig serverConfig) {
        return new AbstractAction(Msg.get(Msg.Key.DELETE_CONNECTION), Theme.CIcon.DELETE.get16()){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonActions.this.connectionManager.removeServer(serverConfig);
            }

            @Override
            public boolean isEnabled() {
                return CommonActions.this.connectionManager.contains(serverConfig);
            }
        };
    }

    @Override
    public Collection<Command> getCommands() {
        ArrayList<Command> a = new ArrayList<Command>();
        a.addAll(CommandManager.toCommands(this.queryActions));
        a.addAll(CommandManager.toCommands(this.proActions));
        a.addAll(CommandManager.toCommands(this.serverActions));
        return a;
    }

    public static boolean checkForOpenAIkey() {
        boolean hasKey;
        String OPENAI_INSTRUCT = "You must first configure an OpenAI key in Settings->Preferences...->Misc";
        boolean bl = hasKey = AIFacade.getOpenAIkey() != null && AIFacade.getOpenAIkey().trim().length() > 1;
        if (!hasKey) {
            JOptionPane.showMessageDialog(null, "You must first configure an OpenAI key in Settings->Preferences...->Misc");
            new PreferencesDialog(MyPreferences.INSTANCE, null);
        }
        return hasKey;
    }

    public void performOpenAIQueryReplace(JTextComponent txtc, Function<String, String> performQuery, boolean atEnd) {
        int end;
        if (!CommonActions.checkForOpenAIkey()) {
            return;
        }
        String selectedTxt = this.openDocumentsModel.getSelectedDocument().getSelectedText();
        String fullTxt = txtc.getText().replace("\r", "");
        int start = txtc.getSelectionStart();
        if (selectedTxt.trim().length() == 0) {
            selectedTxt = this.openDocumentsModel.getSelectedDocument().getCurrentLine();
            for (end = txtc.getSelectionEnd(); end >= 0 && end < fullTxt.length() && fullTxt.charAt(end) != '\n'; ++end) {
            }
            while (start >= 0 && start < fullTxt.length() && fullTxt.charAt(start) != '\n') {
                --start;
            }
        }
        try {
            String queryRes = performQuery.apply(selectedTxt);
            LOG.info("queryOpenAIstructured:" + selectedTxt);
            if (atEnd) {
                String newTxt = "\n" + queryRes;
                txtc.setCaretPosition(end);
                txtc.replaceSelection(newTxt);
                txtc.setSelectionStart(end);
                txtc.setSelectionEnd(end + newTxt.length());
            } else {
                String newTxt = queryRes + "\n";
                txtc.setCaretPosition(start);
                txtc.replaceSelection(newTxt);
                txtc.setSelectionStart(start);
                txtc.setSelectionEnd(start + newTxt.length());
            }
        }
        catch (Exception e1) {
            LOG.warning("Problem queryOpenAIstructured: " + e1);
        }
    }

    private JdbcTypes getJdbcType() {
        String serverName = this.queryManager.getSelectedServerName();
        ServerConfig sc = serverName == null ? null : this.connectionManager.getServer(serverName);
        return sc != null ? sc.getJdbcType() : JdbcTypes.KDB;
    }

    public static void setProActionPlugin(ActionPlugin proActionPlugin) {
        CommonActions.proActionPlugin = proActionPlugin;
    }

    public List<Action> getQueryActions() {
        return this.queryActions;
    }

    public List<Action> getAiActions() {
        return this.aiActions;
    }

    public List<Action> getProActions() {
        return this.proActions;
    }

    private class AIExplainAction
    extends TextAction {
        public AIExplainAction(String name) {
            super(name);
            this.putValue("SmallIcon", Theme.CIcon.ROBOT_COMMENT.get16());
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(117, 0));
            this.putValue("MnemonicKey", 69);
            this.putValue("ShortDescription", "Ask OpenAI to explain the SQL.");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent txtc = this.getTextComponent(e);
            String com = CommonActions.this.getJdbcType().getComment();
            Function<String, String> queryReplace = selectedText -> {
                String aiQry = "For the " + (Object)((Object)CommonActions.this.getJdbcType()) + " database ";
                aiQry = aiQry + "explain this SQL code:\n```\n";
                aiQry = aiQry + selectedText + "\n```\n";
                LOG.info("queryOpenAIstructured:" + aiQry);
                try {
                    AIFacade.AIresult air = AIFacade.queryOpenAIstructured(aiQry);
                    return "\n" + com + air.getFirstContent().trim().replace("\n", "\n" + com);
                }
                catch (IOException | IllegalStateException e1) {
                    LOG.warning("Error AI : " + e1);
                    return "\n" + com + e1.toString().replace("\n", "\n" + com);
                }
            };
            CommonActions.this.performOpenAIQueryReplace(txtc, queryReplace, false);
            UpdateHelper.registerEvent("com_aiexplain");
        }
    }

    private class GenerateAIQueryAction
    extends TextAction {
        public GenerateAIQueryAction(String name) {
            super(name);
            this.putValue("SmallIcon", Theme.CIcon.ROBOT_GO.get16());
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(118, 0));
            this.putValue("MnemonicKey", 65);
            this.putValue("ShortDescription", "Send your question to OpenAI to generate the SQL.");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent txtc = this.getTextComponent(e);
            Function<String, String> queryReplace = selectedText -> {
                String tblInfo = "";
                List<ServerQEntity> st2 = CommonActions.this.qStudioModel.getAdminModel().getServerModel().getServerObjectTree().getAll();
                if (st2 != null && st2.size() > 0) {
                    try {
                        List tables = st2.stream().filter(se -> se.getType().equals((Object)CAtomTypes.TABLE)).map(se -> (TableSQE)se).collect(Collectors.toList());
                        tblInfo = tables.stream().map(se -> {
                            String s = "";
                            if (se.getQQueries().size() > 0) {
                                s = s + se.getQQueries().get(0).getQuery() + "\n";
                            }
                            s = s + se.getFullName() + " Columns: " + Joiner.on(",").join(se.getColNames()) + "\n";
                            return s;
                        }).collect(Collectors.joining());
                    }
                    catch (Exception e2) {
                        LOG.warning("Could not populate tblInfo for AI query:" + e2);
                    }
                }
                LOG.info("queryOpenAIstructured:" + selectedText);
                try {
                    AIFacade.AIresult air = AIFacade.queryOpenAIstructured(CommonActions.this.getJdbcType(), tblInfo, selectedText);
                    return air.getFirstCode().trim();
                }
                catch (IOException e1) {
                    LOG.warning("Error AI : " + e1);
                    return "Error AI : " + e1;
                }
            };
            CommonActions.this.performOpenAIQueryReplace(txtc, queryReplace, true);
            UpdateHelper.registerEvent("com_genaiquery");
        }
    }

    private class GoogleAction
    extends TextAction {
        public GoogleAction(String name) {
            super(name);
            this.putValue("SmallIcon", Theme.CIcon.GOOGLE.get16());
            this.putValue("MnemonicKey", 71);
            this.putValue("ShortDescription", "Google the selected text or line.");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String selectedTxt = CommonActions.this.openDocumentsModel.getSelectedDocument().getSelectedText();
            if (selectedTxt.trim().length() == 0) {
                selectedTxt = CommonActions.this.openDocumentsModel.getSelectedDocument().getCurrentLine();
            }
            try {
                String qry = URLEncoder.encode(selectedTxt, "UTF-8");
                HtmlUtils.browse("https://www.google.com?q=" + qry);
            }
            catch (UnsupportedEncodingException e1) {
                LOG.warning("Problem googling:" + e1);
            }
            UpdateHelper.registerEvent("com_google");
        }
    }

    private class GenerateAIAction
    extends TextAction {
        public GenerateAIAction(String name) {
            super(name);
            this.putValue("SmallIcon", Theme.CIcon.AI.get16());
            this.putValue("MnemonicKey", 79);
            this.putValue("ShortDescription", "Send your question to OpenAI.");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent txtc = this.getTextComponent(e);
            Function<String, String> queryReplace = selectedText -> {
                try {
                    return AIFacade.queryOpenAIstructured(selectedText).getFirstContent();
                }
                catch (IOException e1) {
                    LOG.warning("Error AI : " + e1);
                    return "Error AI : " + e1;
                }
            };
            CommonActions.this.performOpenAIQueryReplace(txtc, queryReplace, true);
            UpdateHelper.registerEvent("com_generateai");
        }
    }

    private class CloneServerAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private final ServerConfig sc;

        public CloneServerAction(ServerConfig sc) {
            super(Msg.get(Msg.Key.CLONE_SERVER), Theme.CIcon.COPY.get());
            this.putValue("ShortDescription", "Create a new connection with the same settings as this one.");
            this.putValue("MnemonicKey", 67);
            this.sc = sc;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            String newName = this.sc.getName() + " " + Msg.get(Msg.Key.COPY);
            ServerConfig sc2 = new ServerConfigBuilder(this.sc).setName(newName).build();
            CommonActions.this.connectionManager.addServer(sc2);
            ConnectionManagerDialog cmd = new ConnectionManagerDialog(CommonActions.this.connectionManager, CommonActions.this.parent, newName);
            cmd.setVisible(true);
            UpdateHelper.registerEvent("com_cloneserver");
        }
    }

    private class CloseConnServerAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private final ServerConfig sc;

        public CloseConnServerAction(ServerConfig sc) {
            super(Msg.get(Msg.Key.CLOSE_CONNECTION), Theme.CIcon.SERVER_CONNECT.get());
            this.putValue("ShortDescription", "Close all connections to this database.");
            this.sc = sc;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            CommonActions.this.connectionManager.closePool(this.sc);
            try {
                CommonActions.this.queryManager.close();
            }
            catch (Exception e) {
                LOG.warning("Problem closing QM");
            }
        }
    }

    private class AddServerAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private final String folder;

        public AddServerAction(String folder) {
            super(Msg.get(Msg.Key.ADD_SERVER), Theme.CIcon.SERVER_ADD.get());
            this.putValue("ShortDescription", "Add a server to the list of possible connections");
            this.putValue("MnemonicKey", 65);
            this.folder = folder;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            ConnectionManagerDialog cmd = new ConnectionManagerDialog(CommonActions.this.connectionManager, CommonActions.this.parent, null);
            if (this.folder != null) {
                cmd.setFolder(this.folder);
            }
            cmd.setVisible(true);
        }
    }

    private class EditServerAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private final ServerConfig sc;

        public EditServerAction(ServerConfig sc) {
            super(Msg.get(Msg.Key.EDIT) + sc.getName() + Msg.get(Msg.Key.CONNECTION));
            if (!CommonActions.this.connectionManager.isConnected(sc)) {
                ImageIcon ii = Theme.CIcon.SERVER_ERROR.get16();
                this.putValue("SmallIcon", ii);
                this.putValue("SwingLargeIconKey", ii);
            }
            this.sc = sc;
            this.putValue("ShortDescription", "Edit the server connection " + sc.getName());
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            new ConnectionManagerDialog(CommonActions.this.connectionManager, CommonActions.this.parent, this.sc.getName()).setVisible(true);
        }
    }

    @FunctionalInterface
    public static interface ActionPlugin {
        public List<Action> getActions(@NonNull CommonActions var1, @NonNull Growler var2);
    }
}

