/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio;

import com.google.common.base.Preconditions;
import com.timestored.StringUtils;
import com.timestored.TimeStored;
import com.timestored.connections.ServerConfig;
import com.timestored.jgrowl.Growler;
import com.timestored.misc.HtmlUtils;
import com.timestored.qstudio.GrabItem;
import com.timestored.qstudio.GrabableContainer;
import com.timestored.qstudio.UpdateHelper;
import com.timestored.qstudio.model.QueryAdapter;
import com.timestored.qstudio.model.QueryManager;
import com.timestored.qstudio.model.QueryResult;
import com.timestored.sqldash.ChartControlPanel;
import com.timestored.sqldash.ChartWidget;
import com.timestored.sqldash.Queryable;
import com.timestored.sqldash.chart.ChartTheme;
import com.timestored.swingxx.SwingUtils;
import com.timestored.theme.Icon;
import com.timestored.theme.Theme;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Random;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

class ChartResultPanel
extends JPanel
implements GrabableContainer {
    private static final long serialVersionUID = 1L;
    private static final int PADDING = 10;
    private ChartWidget app;
    private final Growler growler;
    final Random R = new Random();
    private QueryResult latestQueryResult;
    private ExportPanel exportPanel;

    public ChartResultPanel(final QueryManager adminModel, Growler growler) {
        this.growler = Preconditions.checkNotNull(growler);
        this.app = new ChartWidget();
        adminModel.addQueryListener(new QueryAdapter(){

            @Override
            public void sendingQuery(ServerConfig sc, String query) {
            }

            @Override
            public void queryResultReturned(ServerConfig sc, QueryResult qr) {
                if (ChartResultPanel.this.exportPanel == null) {
                    ChartResultPanel.this.resetContent();
                }
                ChartResultPanel.this.app.setIgnoreConfigChanges(true);
                String qsrv = adminModel.getSelectedServerName();
                Queryable q = new Queryable(qsrv, qr.query);
                ChartResultPanel.this.app.setQueryable(q);
                ChartResultPanel.this.app.setIgnoreConfigChanges(false);
                ChartResultPanel.this.exportPanel.setEnabled(false);
                ChartResultPanel.this.latestQueryResult = qr;
                if (qr.isException()) {
                    ChartResultPanel.this.app.queryError(q, qr.e);
                } else if (qr.isCancelled()) {
                    ChartResultPanel.this.app.queryError(q, new IOException("Query Cancelled"));
                } else {
                    ChartResultPanel.this.app.tabChanged(q, qr.rs);
                    ChartResultPanel.this.exportPanel.setEnabled(qr.rs != null);
                }
            }
        });
        if (adminModel.hasAnyServers()) {
            this.add((Component)UpdateHelper.getNewsPanel(null), "Center");
        }
    }

    public void setChartTheme(ChartTheme chartTheme) {
        if (this.app != null) {
            this.app.setChartTheme(Preconditions.checkNotNull(chartTheme));
        }
    }

    private void resetContent() {
        this.removeAll();
        JPanel configPanel = Theme.getVerticalBoxPanel();
        configPanel.add(new ChartControlPanel(this.app));
        this.exportPanel = new ExportPanel(this.growler);
        this.exportPanel.setEnabled(false);
        configPanel.add(this.exportPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)configPanel, "West");
        JPanel p = new JPanel(new BorderLayout(10, 10));
        p.add((Component)this.app.getPanel(), "Center");
        this.add((Component)p, "Center");
        this.repaint();
    }

    @Override
    public GrabItem grab() {
        if (this.latestQueryResult != null) {
            ChartWidget cw = new ChartWidget(this.app);
            Queryable q = cw.getQ();
            String title = q.getQuery() + " - " + q.getServerName();
            JPanel p = cw.getPanel();
            cw.tabChanged(q, this.latestQueryResult.rs);
            return new GrabItem(p, StringUtils.abbreviate(title, 50), cw.getTSIcon());
        }
        return null;
    }

    private class ExportPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private final JButton popoutButton;
        private final JButton copyMarkdownButton;
        private final JButton configureButton = new JButton("Configure Appearance", Theme.CIcon.LAYOUT_EDIT.get16());

        @Override
        public void setEnabled(boolean enabled) {
            this.popoutButton.setEnabled(enabled);
            this.copyMarkdownButton.setEnabled(enabled);
            this.configureButton.setEnabled(enabled);
            super.setEnabled(enabled);
        }

        public ExportPanel(final Growler growler) {
            this.configureButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HtmlUtils.browse(TimeStored.Page.QSTUDIO_HELP_CHARTCONFIG.url());
                }
            });
            this.copyMarkdownButton = new JButton("Copy Markdown", Theme.CIcon.MARKDOWN_GREEN.get16()){

                @Override
                public boolean isEnabled() {
                    return ChartResultPanel.this.app.getViewStrategy().getPulseName() != null;
                }
            };
            this.copyMarkdownButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        Queryable q = ChartResultPanel.this.app.getQ();
                        String chartVS = ChartResultPanel.this.app.getViewStrategy().getPulseName();
                        if (chartVS != null) {
                            String mdCommand = "```sql type='" + chartVS + "' server='" + q.getServerName() + "' \n" + q.getQuery() + "\n```";
                            Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
                            clpbrd.setContents(new StringSelection(mdCommand), null);
                            growler.showInfo("Copied to clipboard:\r\n" + mdCommand, "Clipboard Set");
                        } else {
                            growler.showWarning("No export possible. Try a different chart type.", "No export possible.");
                        }
                        UpdateHelper.registerEvent("cha_copymd");
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            });
            this.popoutButton = new JButton("Open in New Window", Theme.CIcon.POPUP_WINDOW.get16());
            this.popoutButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ChartResultPanel.this.latestQueryResult != null && ((ChartResultPanel)ChartResultPanel.this).latestQueryResult.rs != null) {
                        ChartWidget cw = new ChartWidget(ChartResultPanel.this.app);
                        Queryable q = cw.getQ();
                        String title = q.getQuery() + " - " + q.getServerName();
                        JPanel p = cw.getPanel();
                        cw.tabChanged(q, ((ChartResultPanel)ChartResultPanel.this).latestQueryResult.rs);
                        Icon ic = cw.getViewStrategy().getIcon();
                        BufferedImage bi = ic == null ? null : ic.getBufferedImage();
                        JFrame f = SwingUtils.getPopupFrame(ChartResultPanel.this, title, p, bi);
                        f.setVisible(true);
                    }
                    UpdateHelper.registerEvent("cha_popout");
                }
            });
            Theme.InputLabeller IL = Theme.getInputLabeller();
            Box b = Box.createVerticalBox();
            this.setLayout(new BorderLayout());
            b.add(IL.get("", this.popoutButton, "popoutButton"));
            b.add(IL.get("", this.configureButton, "configureButton"));
            b.add(IL.get("", this.copyMarkdownButton, "copyMarkdownButton"));
            b.add(Box.createVerticalGlue());
            this.add((Component)b, "Center");
        }
    }
}

