/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio;

import com.formdev.flatlaf.fonts.jetbrains_mono.FlatJetBrainsMonoFont;
import com.timestored.misc.AppLaunchHelper;
import com.timestored.qstudio.MyPreferences;
import com.timestored.qstudio.PreferencesPanel;
import com.timestored.swingxx.ColorChooserPanel;
import com.timestored.theme.Theme;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class AppearancePreferencesPanel
extends PreferencesPanel {
    private static final long serialVersionUID = 1L;
    private final JSpinner maxFractionDigitsSpinner;
    private final JCheckBox showThousandsCommaCheckBox;
    private final JFormattedTextField rowLimitField;
    private final JFormattedTextField consoleLimitField;
    private final JCheckBox showTooltipsCheckbox;
    private final JCheckBox overrideUIScaleCheckbox;
    private final JSlider uIScaleSlider;
    private final JSpinner codeFontSpinner;
    private final JComboBox<String> codeFontComboBox;
    private final JComboBox<String> editorConfigComboBox;
    private final JTextField criticalColorField;
    private final ColorChooserPanel colorChooserPanel;
    private boolean themeChanged;
    private static final String FONT_SPACER = " ----- ";

    public AppearancePreferencesPanel(final MyPreferences myPreferences, final Component container) {
        super(myPreferences, container);
        Box panel = Box.createVerticalBox();
        panel.setBorder(Theme.getCentreBorder());
        List<String> editorConfigs = AppLaunchHelper.getLafNamesWithSpacerStrings();
        this.editorConfigComboBox = new JComboBox<String>(editorConfigs.toArray(new String[0]));
        JLabel ecb = new JLabel(Theme.CIcon.WARNING.get16());
        String tooltipText = "<html>You must restart qStudio for this to take full effect.</html>";
        ecb.setToolTipText(tooltipText);
        panel.add(Theme.getFormRow(this.editorConfigComboBox, "Color Theme:", tooltipText, ecb));
        FlatJetBrainsMonoFont.install();
        this.codeFontComboBox = new JComboBox<String>(this.getFontList().toArray(new String[0]));
        tooltipText = "<html>Font used in Code Editor. <br/>Recommended default is Monospaced";
        JLabel b = new JLabel(Theme.CIcon.INFO.get());
        b.setToolTipText(tooltipText);
        panel.add(Theme.getFormRow(this.codeFontComboBox, "Code Font:", tooltipText, b));
        this.codeFontSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 50, 1));
        panel.add(Theme.getFormRow(this.codeFontSpinner, "Font Size:", "Font Size of Code Editor"));
        Box tipp = Box.createHorizontalBox();
        tipp.add(new JLabel("When theme=Light, Font Size ONLY sets code size."));
        panel.add(tipp);
        Box bx = Box.createHorizontalBox();
        this.overrideUIScaleCheckbox = new JCheckBox("Enabled");
        this.uIScaleSlider = new JSlider(0, 50, 400, 100);
        this.uIScaleSlider.setMinorTickSpacing(5);
        this.uIScaleSlider.setMajorTickSpacing(25);
        this.uIScaleSlider.setSnapToTicks(true);
        this.uIScaleSlider.setPaintTicks(true);
        this.uIScaleSlider.setPaintLabels(true);
        this.uIScaleSlider.addChangeListener(ce -> {
            int uiScale = this.uIScaleSlider.getValue();
            if (this.overrideUIScaleCheckbox.isEnabled() && uiScale > 0) {
                myPreferences.setUIScale(uiScale);
                this.notifyAndUpdate();
            }
        });
        this.overrideUIScaleCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean enabled = e.getStateChange() == 1;
                AppearancePreferencesPanel.this.uIScaleSlider.setEnabled(enabled);
                if (!enabled) {
                    AppearancePreferencesPanel.this.uIScaleSlider.setValue(100);
                }
            }
        });
        String uitooltip = "Set the percentage that the UI will be scaled by.\ne.g. 200 = double scaled.";
        bx.add(this.overrideUIScaleCheckbox);
        bx.add(Theme.getFormRow(this.uIScaleSlider, "UIScale:", uitooltip));
        panel.add(bx);
        panel.add(Box.createVerticalStrut(20));
        this.showTooltipsCheckbox = new JCheckBox();
        panel.add(Theme.getFormRow(this.showTooltipsCheckbox, "Show Code Editor Tooltips:", null));
        this.maxFractionDigitsSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 20, 1));
        panel.add(Theme.getFormRow(this.maxFractionDigitsSpinner, "Maximum Decimal Places Displayed:", "In results tables and lists, floating point values will have their trailing decimal places trimmed to this precision."));
        this.showThousandsCommaCheckBox = new JCheckBox();
        panel.add(Theme.getFormRow(this.showThousandsCommaCheckBox, "Show Thousands Separator:", "Whether to show comma between large numbers, for example \"9,123,456.78\"."));
        this.rowLimitField = new JFormattedTextField((Object)0);
        panel.add(Theme.getFormRow(this.rowLimitField, "Maximum Table Rows Displayed:", "The IDE will only show this many rows at most. 0=unlimited"));
        this.consoleLimitField = new JFormattedTextField((Object)0);
        panel.add(Theme.getFormRow(this.consoleLimitField, "Maximum console characters:", "The console will only show up to this many characters."));
        JPanel ccPanel = new JPanel(new BorderLayout());
        ccPanel.setBorder(BorderFactory.createTitledBorder("Critical Instance Color:"));
        String ccTooltip = "Any servers containing one of these keywords will display this color.";
        this.colorChooserPanel = new ColorChooserPanel(container);
        this.criticalColorField = new JTextField(40);
        ccPanel.add((Component)Theme.getFormRow(this.criticalColorField, "Keywords (Comma Separated):", ccTooltip), "North");
        ccPanel.add((Component)Theme.getFormRow(this.colorChooserPanel, "Color:", ccTooltip), "South");
        panel.add(ccPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "North");
        this.refresh();
        this.codeFontComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String font = (String)AppearancePreferencesPanel.this.codeFontComboBox.getSelectedItem();
                if (!font.startsWith(AppearancePreferencesPanel.FONT_SPACER)) {
                    myPreferences.setCodeFont(font);
                    AppearancePreferencesPanel.this.notifyAndUpdate();
                }
            }
        });
        this.editorConfigComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String lfname = (String)AppearancePreferencesPanel.this.editorConfigComboBox.getSelectedItem();
                if (!lfname.startsWith(" ------ ")) {
                    myPreferences.setCodeTheme(lfname);
                    AppearancePreferencesPanel.this.notifyAndUpdate();
                    if (!AppearancePreferencesPanel.this.themeChanged) {
                        String message = "Theme changes require a restart to work fully.";
                        JOptionPane.showMessageDialog(container, message);
                        AppearancePreferencesPanel.this.themeChanged = true;
                    }
                }
            }
        });
        this.codeFontSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int sz = (Integer)AppearancePreferencesPanel.this.codeFontSpinner.getValue();
                myPreferences.setCodeFontSize(sz);
                AppearancePreferencesPanel.this.notifyAndUpdate();
            }
        });
    }

    private void notifyAndUpdate() {
        this.myPreferences.notifyListeners();
        SwingUtilities.updateComponentTreeUI(this.container);
    }

    private List<String> getFontList() {
        Font[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        TreeSet<String> monoFonts = new TreeSet<String>();
        TreeSet<String> otherFonts = new TreeSet<String>();
        ArrayList<String> r = new ArrayList<String>();
        if (System.getProperty("os.name").toLowerCase().indexOf("mac") < 0) {
            FontRenderContext frc = new FontRenderContext(null, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT, RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT);
            for (Font font : fonts) {
                Rectangle2D iBounds = font.getStringBounds("i", frc);
                Rectangle2D mBounds = font.getStringBounds("m", frc);
                if (iBounds.getWidth() == mBounds.getWidth()) {
                    monoFonts.add(font.getFamily());
                    continue;
                }
                otherFonts.add(font.getFamily());
            }
            r.add(" -----  Mono Fonts  ----- ");
            if (!monoFonts.contains("JetBrains Mono")) {
                r.add("JetBrains Mono");
            }
            r.addAll(monoFonts);
            r.add(" -----  Non-Mono Fonts  ----- ");
            r.addAll(otherFonts);
        } else {
            for (Font font : fonts) {
                otherFonts.add(font.getFamily());
            }
            r.addAll(otherFonts);
        }
        return r;
    }

    @Override
    void refresh() {
        int rows = this.myPreferences.getMaxRowsShown();
        this.rowLimitField.setValue(rows);
        int maxDigits = this.myPreferences.getMaximumFractionDigits();
        this.maxFractionDigitsSpinner.setValue(maxDigits);
        int groupingSize = this.myPreferences.getNumberGroupingSize();
        this.showThousandsCommaCheckBox.setSelected(groupingSize > 0);
        this.codeFontComboBox.setSelectedItem(this.myPreferences.getCodeFont());
        this.editorConfigComboBox.setSelectedItem(this.myPreferences.getCodeTheme());
        this.codeFontSpinner.setValue(this.myPreferences.getCodeFontSize());
        int consoleLength = this.myPreferences.getMaxConsoleLength();
        this.consoleLimitField.setValue(consoleLength);
        this.criticalColorField.setText(this.myPreferences.getCriticalServerKeywords());
        this.colorChooserPanel.setColor(this.myPreferences.getCriticalServerColor());
        this.showTooltipsCheckbox.setSelected(this.myPreferences.isShowTooltips());
        boolean uisEnabled = this.myPreferences.getUIScale() > 0;
        this.overrideUIScaleCheckbox.setSelected(uisEnabled);
        this.uIScaleSlider.setEnabled(uisEnabled);
        this.uIScaleSlider.setValue(Math.abs(this.myPreferences.getUIScale()));
    }

    @Override
    void cancel() {
        this.myPreferences.setCodeFont((String)this.codeFontComboBox.getSelectedItem());
        this.myPreferences.setMaxConsoleLength((Integer)this.consoleLimitField.getValue());
    }

    @Override
    void saveSettings() {
        this.myPreferences.setMaxRowsShown((Integer)this.rowLimitField.getValue());
        this.myPreferences.setMaximumFractionDigits((Integer)this.maxFractionDigitsSpinner.getValue());
        this.myPreferences.setNumberGroupingSize(this.showThousandsCommaCheckBox.isSelected() ? 3 : 0);
        this.myPreferences.setCodeFontSize((Integer)this.codeFontSpinner.getValue());
        this.myPreferences.setCodeFont((String)this.codeFontComboBox.getSelectedItem());
        this.myPreferences.setCodeTheme((String)this.editorConfigComboBox.getSelectedItem());
        this.myPreferences.setMaxConsoleLength((Integer)this.consoleLimitField.getValue());
        this.myPreferences.setCriticalServerKeywords(this.criticalColorField.getText());
        this.myPreferences.setCriticalServerColor(this.colorChooserPanel.getColor());
        this.myPreferences.setShowTooltips(this.showTooltipsCheckbox.isSelected());
        int uis = (this.overrideUIScaleCheckbox.isSelected() ? 1 : -1) * this.uIScaleSlider.getValue();
        this.myPreferences.setUIScale(uis);
    }
}

