/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qstudio;

import com.timestored.connections.ConnectionManager;
import com.timestored.connections.ConnectionShortFormat;
import com.timestored.connections.JdbcTypes;
import com.timestored.connections.ServerConfig;
import com.timestored.qstudio.BackgroundExecutor;
import com.timestored.swingxx.SwingUtils;
import com.timestored.theme.Theme;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JFrame;

class AddServerListAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private final JFrame parent;
    private final ConnectionManager connectionManager;

    public AddServerListAction(JFrame parent, ConnectionManager connectionManager) {
        super("Add Server List...", Theme.CIcon.SERVER_ADD.get());
        this.putValue("ShortDescription", "Add multiple servers to the list of possible connections");
        this.parent = parent;
        this.connectionManager = connectionManager;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        String DEFAULT_SERVER = "folder/subf/my-server-name@localhost:5000\r\nfolder/subf/pro-server@localhost:5002:username:password\r\n127.0.0.1:5001";
        String title = "Add Server List";
        String helpMsg = "Enter your server list below, one per row.\r\nTwo examples of the format expected are given.\r\n";
        String txt = Theme.getTextFromDialog(this.parent, title, "folder/subf/my-server-name@localhost:5000\r\nfolder/subf/pro-server@localhost:5002:username:password\r\n127.0.0.1:5001", helpMsg);
        final String textEntered = txt;
        if (textEntered != null) {
            BackgroundExecutor.EXECUTOR.execute(new Runnable(){

                @Override
                public void run() {
                    List<ConnectionShortFormat.ParseResult> r = ConnectionShortFormat.parse(textEntered, JdbcTypes.KDB, new JdbcTypes[]{JdbcTypes.KDB});
                    StringBuilder errorSb = new StringBuilder();
                    String SEP = "\r\n\r\n";
                    ArrayList<ServerConfig> connections = new ArrayList<ServerConfig>();
                    for (ConnectionShortFormat.ParseResult pr : r) {
                        if (pr.serverConfig != null) {
                            connections.add(pr.serverConfig);
                            continue;
                        }
                        errorSb.append("Failed Line: ").append(pr.originalLine).append(" - ").append(pr.report).append("\r\n\r\n");
                    }
                    List<ServerConfig> failedConns = AddServerListAction.this.connectionManager.addServer(connections);
                    for (ConnectionShortFormat.ParseResult pr : r) {
                        ServerConfig sc = pr.serverConfig;
                        if (sc == null || !failedConns.contains(sc)) continue;
                        errorSb.append("Could not add sc: " + sc.getName() + "\r\n\r\n");
                    }
                    if (errorSb.length() > 0) {
                        SwingUtils.showMessageDialog(AddServerListAction.this.parent, errorSb.toString(), "Error Parsing Servers", 2);
                    }
                }
            });
        }
    }
}

