/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qdoc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.timestored.misc.IOUtils;
import com.timestored.qdoc.ParsedComments;
import com.timestored.qdoc.ParsedQEntity;
import com.timestored.qdoc.ParsedQFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class QFileParser {
    private static final Logger LOG = Logger.getLogger(QFileParser.class.getName());
    private static final String DEFAULT_NS = ".";
    private final char[] s;
    private final String srcFilePath;
    private final String srcFileTitle;
    private final List<String> commentsBuffer = new ArrayList<String>();
    private final List<ParsedQEntity> qEntities = new ArrayList<ParsedQEntity>();
    private int pos = 0;
    private String curNamespace = ".";
    private ParsedQFile pqf;

    private QFileParser(String fullFileContents, String srcFilePath, String srcFileTitle) {
        this.s = fullFileContents.replace("\r\n", "\n").toCharArray();
        this.srcFilePath = srcFilePath;
        this.srcFileTitle = srcFileTitle;
        this.curNamespace = DEFAULT_NS;
    }

    private ParsedQFile parse() {
        while (this.pos < this.s.length && this.s[this.pos] == '/') {
            this.parseCommentsToBuffer();
        }
        ParsedComments headerDoc = ParsedComments.parse(this.commentsBuffer);
        this.commentsBuffer.clear();
        LOG.fine("headerDoc = " + headerDoc);
        this.pqf = new ParsedQFile(headerDoc, "", this.srcFilePath, this.srcFileTitle);
        while (this.pos < this.s.length) {
            if (QFileParser.isWhiteSpace(this.s[this.pos])) {
                ++this.pos;
                continue;
            }
            if (QFileParser.isNewLine(this.s[this.pos])) {
                ++this.pos;
                this.commentsBuffer.clear();
                continue;
            }
            boolean found = this.parseCommentsToBuffer() | this.parseNamespace() | this.parseAssignment() | QFileParser.parseCode();
            if (found) continue;
            LOG.fine("nothing found:" + this.s[this.pos]);
            ++this.pos;
        }
        this.combineByFullName(this.qEntities);
        this.pqf.setqEntities(this.qEntities);
        return this.pqf;
    }

    private void combineByFullName(List<ParsedQEntity> qEntities) {
        ArrayListMultimap<String, ParsedQEntity> namespaceToEntities = ArrayListMultimap.create();
        for (ParsedQEntity parsedQEntity : qEntities) {
            namespaceToEntities.put(parsedQEntity.getFullName(), parsedQEntity);
        }
        for (Collection collection : namespaceToEntities.asMap().values()) {
            if (collection.size() <= 1) continue;
            qEntities.removeAll(collection);
            qEntities.add(this.combine(collection));
        }
    }

    private ParsedQEntity combine(Collection<ParsedQEntity> nsEntries) {
        Preconditions.checkArgument(nsEntries.size() > 0);
        if (nsEntries.size() == 1) {
            return nsEntries.iterator().next();
        }
        ParsedQEntity re = nsEntries.iterator().next();
        String doc = "";
        String ret = "";
        int offset = Integer.MIN_VALUE;
        HashMap<String, String> paramDescriptions = Maps.newHashMap();
        HashMap<String, String> exceptionDescriptions = Maps.newHashMap();
        String BR = "<br/>";
        for (ParsedQEntity pqe : nsEntries) {
            Preconditions.checkArgument(re.getFullName().equals(pqe.getFullName()) && re.getSource().equals(pqe.getSource()));
            if (!pqe.getReturnDescription().isEmpty()) {
                ret = pqe.getReturnDescription();
            }
            String d = pqe.getDocDescription().trim();
            doc = doc + (d.isEmpty() ? d : d + "<br/>");
            offset = Math.min(offset, pqe.getOffset());
            paramDescriptions.putAll(pqe.getParamTags());
            exceptionDescriptions.putAll(pqe.getExceptionTags());
        }
        return ParsedQEntity.get(re.getParentFile(), re.getDocName(), re.getNamespace(), doc, paramDescriptions, exceptionDescriptions, ret, offset);
    }

    public static ParsedQFile parse(File file) {
        String s = "";
        try {
            s = IOUtils.toString(file);
        }
        catch (IOException e) {
            LOG.log(Level.INFO, "Could not read q file", e);
        }
        return new QFileParser(s, file.getAbsolutePath(), file.getName()).parse();
    }

    public static ParsedQFile parse(String fullFileContents, String srcFilePath, String srcFileTitle) {
        return new QFileParser(fullFileContents, srcFilePath, srcFileTitle).parse();
    }

    private static boolean parseCode() {
        return false;
    }

    private boolean parseAssignment() {
        int p = this.pos;
        int startPos = this.pos;
        String varName = QFileParser.getLegalName(this.s, p);
        if (varName.length() > 0 && (p += varName.length()) < this.s.length && this.s[p] == ':') {
            int secondPos;
            this.pos += varName.length() + 1;
            this.jumpToEndOFStatement();
            String ns = this.curNamespace;
            int n = secondPos = varName.length() > 3 ? varName.substring(2).indexOf(46) : -1;
            if (varName.charAt(0) == '.' && secondPos > -1) {
                ns = varName.substring(0, 2 + secondPos);
                varName = varName.substring(3 + secondPos);
            }
            ParsedQEntity pqe = ParsedQEntity.get(this.pqf, varName, ns, ParsedComments.parse(this.commentsBuffer), startPos);
            this.commentsBuffer.clear();
            this.qEntities.add(pqe);
            LOG.fine("assignment: " + pqe.toString());
            return true;
        }
        return false;
    }

    private static boolean isLegalNameStarter(char c2) {
        return Character.isLetter(c2) || c2 == '.';
    }

    private static String getLegalName(char[] s, int pos) {
        int p = pos;
        if (p >= 0 && p < s.length && QFileParser.isLegalNameStarter(s[p])) {
            ++p;
            while (p < s.length && (QFileParser.isLegalNameStarter(s[p]) || s[p] == '_' || Character.isDigit(s[p]))) {
                ++p;
            }
            return new String(s, pos, p - pos).intern();
        }
        return "";
    }

    private boolean isPosEqual(String txt) {
        if (this.pos < this.s.length - txt.length()) {
            return new String(this.s, this.pos, txt.length()).equals(txt);
        }
        return false;
    }

    private void acceptWhitespace() {
        while (this.pos < this.s.length && QFileParser.isWhiteSpace(this.s[this.pos])) {
            ++this.pos;
        }
    }

    private void acceptNewline() {
        while (this.pos < this.s.length && QFileParser.isNewLine(this.s[this.pos])) {
            ++this.pos;
        }
    }

    private void acceptOneNewline() {
        if (this.pos < this.s.length && this.s[this.pos] == '\r') {
            ++this.pos;
        }
        if (this.pos < this.s.length && this.s[this.pos] == '\n') {
            ++this.pos;
        }
    }

    private boolean parseNamespace() {
        int startPos = this.pos;
        String newNS = null;
        if (this.isPosEqual("\\d ")) {
            this.pos += 3;
            String ns = QFileParser.getLegalName(this.s, this.pos);
            this.pos += ns.length();
            this.acceptWhitespace();
            if (this.pos < this.s.length && QFileParser.isNewLine(this.s[this.pos])) {
                this.acceptNewline();
                newNS = ns;
            }
        } else if (this.isPosEqual("system")) {
            boolean sqBracket;
            LOG.fine("parseNamespace - system command found");
            this.pos += "system".length();
            this.acceptWhitespace();
            boolean bl = sqBracket = this.pos < this.s.length && this.s[this.pos] == '[';
            if (sqBracket) {
                ++this.pos;
            }
            if (this.isPosEqual("\"d ")) {
                this.pos += 3;
                String ns = QFileParser.getLegalName(this.s, this.pos);
                this.pos += ns.length();
                this.acceptWhitespace();
                if (this.s[this.pos] == '\"') {
                    ++this.pos;
                    this.acceptWhitespace();
                    if (sqBracket && this.s[this.pos] == ']') {
                        ++this.pos;
                    } else {
                        LOG.warning("no end sqBracket found. File: " + this.srcFilePath + " pos = " + this.pos);
                    }
                    newNS = ns;
                }
            }
        }
        if (newNS != null) {
            this.curNamespace = newNS;
            this.commentsBuffer.clear();
            LOG.fine("curNamespace = " + this.curNamespace);
            return true;
        }
        this.pos = startPos;
        return false;
    }

    private void jumpToEndOFStatement() {
        Stack<Bracket> stack = new Stack<Bracket>();
        while (this.pos < this.s.length) {
            boolean isEnd;
            boolean bl = isEnd = (QFileParser.isNewLine(this.s[this.pos]) || this.s[this.pos] == ';' || this.isPosEqual(" /")) && stack.size() == 0;
            if (isEnd) break;
            Bracket b = Bracket.lookupOpen(this.s[this.pos]);
            if (b != null) {
                stack.push(b);
            } else if (stack.size() > 0 && (b = Bracket.lookupClose(this.s[this.pos])) != null && b != stack.pop()) {
                LOG.warning("mismatch in bracket parsing:" + b.toString() + "File: " + this.srcFilePath + " pos = " + this.pos);
            }
            ++this.pos;
        }
    }

    private static boolean isWhiteSpace(char c2) {
        return c2 == ' ' || c2 == '\t';
    }

    private static boolean isNewLine(char c2) {
        return c2 == '\r' || c2 == '\n';
    }

    private boolean parseCommentsToBuffer() {
        if (this.s[this.pos] != '/') {
            return false;
        }
        ++this.pos;
        this.acceptWhitespace();
        if (this.pos < this.s.length && QFileParser.isNewLine(this.s[this.pos])) {
            this.acceptNewline();
            int startOffset = this.pos;
            while (!(this.pos >= this.s.length || this.s[this.pos] == '\\' && QFileParser.isNewLine(this.s[this.pos - 1]))) {
                if (QFileParser.isNewLine(this.s[this.pos])) {
                    this.addToCBuffer(startOffset, this.pos);
                    this.acceptNewline();
                    startOffset = this.pos;
                    continue;
                }
                ++this.pos;
            }
            if (this.pos < this.s.length && this.s[this.pos] == '\\') {
                ++this.pos;
                this.acceptOneNewline();
            } else if (this.pos == this.s.length) {
                this.addToCBuffer(startOffset, this.pos);
            }
        } else {
            while (this.pos < this.s.length && (QFileParser.isWhiteSpace(this.s[this.pos]) || this.s[this.pos] == '/' || this.s[this.pos] == '#')) {
                ++this.pos;
            }
            int startOffset = this.pos;
            while (this.pos < this.s.length && !QFileParser.isNewLine(this.s[this.pos++])) {
            }
            this.addToCBuffer(startOffset, this.pos);
        }
        return true;
    }

    private void addToCBuffer(int start, int end) {
        String t;
        if (end > start && (t = new String(this.s, start, end - start).trim()).length() > 0) {
            LOG.fine("adding comment to buffer: " + t);
            this.commentsBuffer.add(t);
        }
    }

    private static enum Bracket {
        PARENTHESE('(', ')'),
        CURLIES('{', '}'),
        SQUARE('{', '}'),
        SPEECH('{', '}');

        private final char open;
        private final char close;

        private Bracket(char open, char close) {
            this.open = open;
            this.close = close;
        }

        public static Bracket lookupOpen(char opener) {
            for (Bracket b : Bracket.values()) {
                if (b.open != opener) continue;
                return b;
            }
            return null;
        }

        public static Bracket lookupClose(char closer) {
            for (Bracket b : Bracket.values()) {
                if (b.close != closer) continue;
                return b;
            }
            return null;
        }

        public String toString() {
            return this.name();
        }
    }
}

