/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qdoc;

import com.google.common.collect.Lists;
import com.timestored.docs.Document;
import com.timestored.qdoc.HtmlPqfOutputter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class QDocMain {
    public static void main(String ... args) {
        File qSrc;
        String baseWeblink = null;
        if (args.length < 2) {
            QDocMain.printErr("", 1);
        }
        if (args.length >= 3) {
            baseWeblink = args[2];
        }
        File target = new File(args[0]);
        boolean suc = target.mkdirs();
        if (!target.isDirectory()) {
            QDocMain.printErr("target folder must be writeable directory: " + args[0], 1);
        }
        if (!(qSrc = new File(args[1])).isDirectory()) {
            QDocMain.printErr("source folder must be directory:" + args[1], 2);
        }
        Collection<File> qs = QDocMain.listFileTree(qSrc, ".q");
        ArrayList<Document> docs = Lists.newArrayList();
        for (File qFile : qs) {
            try {
                docs.add(new Document(qFile));
            }
            catch (IOException e) {
                System.err.println("Problem with file:" + qFile);
            }
        }
        List<String> errors = HtmlPqfOutputter.output(docs, target, baseWeblink);
        for (String e : errors) {
            System.err.println("Error: " + e);
        }
    }

    private static void printErr(String msg, int num) {
        System.err.println("Must specify 2 args. 1-targetFolder, 2-qSrcFolder searched recursively");
        if (msg.length() > 0) {
            System.err.println(msg);
        }
        System.exit(num);
    }

    private static Collection<File> listFileTree(File dir, String suffix) {
        if (dir.isDirectory()) {
            HashSet<File> fileTree = new HashSet<File>();
            for (File entry : dir.listFiles()) {
                if (entry == null) continue;
                if (entry.isFile() && (suffix == null || entry.getName().endsWith(suffix))) {
                    fileTree.add(entry);
                    continue;
                }
                fileTree.addAll(QDocMain.listFileTree(entry, suffix));
            }
            return fileTree;
        }
        return Collections.emptySet();
    }
}

