/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qdoc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.timestored.qdoc.ParsedComments;
import com.timestored.qdoc.ParsedQEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ParsedQFile {
    private final ParsedComments headerDoc;
    private final String author;
    private List<ParsedQEntity> qEntities;
    private final String srcFileAbsolutePath;
    private final String fileTitle;

    ParsedQFile(ParsedComments headerDoc, String author, String srcFileAbsolutePath, String fileTitle) {
        this.headerDoc = headerDoc;
        this.author = author == null ? "" : author;
        this.qEntities = Collections.emptyList();
        this.srcFileAbsolutePath = srcFileAbsolutePath;
        this.fileTitle = Preconditions.checkNotNull(fileTitle);
    }

    void setqEntities(List<ParsedQEntity> qEntities) {
        ArrayList l = new ArrayList(Preconditions.checkNotNull(qEntities));
        Collections.sort(l);
        this.qEntities = Collections.unmodifiableList(l);
    }

    String getHeaderDoc() {
        return this.headerDoc == null ? "" : this.headerDoc.docDescription;
    }

    String getAuthor() {
        return this.author;
    }

    List<ParsedQEntity> getQEntities() {
        return this.qEntities;
    }

    public Collection<String> getNamespaces() {
        if (this.qEntities.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> r = Sets.newHashSet();
        for (ParsedQEntity p : this.qEntities) {
            r.add(p.getNamespace());
        }
        return r;
    }

    String getSrcFileAbsolutePath() {
        return this.srcFileAbsolutePath;
    }

    String getFileTitle() {
        return this.fileTitle;
    }

    List<ParsedQEntity> getQEntities(String fullName) {
        ArrayList<ParsedQEntity> r = null;
        for (ParsedQEntity pqe : this.qEntities) {
            if (!pqe.getDocName().equals(fullName)) continue;
            if (r == null) {
                r = new ArrayList<ParsedQEntity>();
            }
            r.add(pqe);
        }
        if (r == null) {
            return Collections.emptyList();
        }
        return r;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("srcFileAbsolutePath", this.srcFileAbsolutePath).add("qEntities", this.qEntities).toString();
    }

    Map<String, String> getHeaderTags() {
        Map<String, String> e = Collections.emptyMap();
        return this.headerDoc == null ? e : this.headerDoc.tags;
    }
}

