/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qdoc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.timestored.docs.Document;
import com.timestored.docs.OpenDocumentsModel;
import com.timestored.misc.HtmlUtils;
import com.timestored.qdoc.DocumentedEntity;
import com.timestored.qdoc.ParsedComments;
import com.timestored.qdoc.ParsedQFile;
import com.timestored.qstudio.model.QEntity;
import com.timestored.theme.Theme;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;

public class ParsedQEntity
implements QEntity,
Comparable<ParsedQEntity> {
    public static final String PARAM_TAG = "param";
    public static final String EXCEPTION_TAG = "exception";
    public static final String COLUMN_TAG = "col";
    public static final String EXAMPLE_TAG = "example";
    public static final String RETURN_TAG = "return";
    private static final Map<String, String> EMPTY_MAP = Collections.emptyMap();
    private final String name;
    private final String namespace;
    private final String docDescription;
    private final String returnDescription;
    private final Map<String, Map<String, String>> namedTags;
    private final Map<String, String> tags;
    private final ParsedQFile parentFile;
    private final int offset;

    static ParsedQEntity get(ParsedQFile parentFile, String name, String namespace, ParsedComments pec, int offset) {
        return new ParsedQEntity(parentFile, name, namespace, pec.docDescription, pec.namedTags, pec.tags, pec.returnDescription, offset);
    }

    private ParsedQEntity(ParsedQFile parentFile, String name, String namespace, String docDescription, Map<String, Map<String, String>> namedTags, Map<String, String> tags, String returnDescription, int offset) {
        this.name = Preconditions.checkNotNull(name);
        this.namespace = Preconditions.checkNotNull(namespace);
        this.docDescription = docDescription == null ? "" : docDescription;
        this.returnDescription = returnDescription == null ? "" : returnDescription;
        this.namedTags = Preconditions.checkNotNull(namedTags);
        this.tags = Preconditions.checkNotNull(tags);
        this.parentFile = Preconditions.checkNotNull(parentFile);
        this.offset = offset;
    }

    public static ParsedQEntity get(ParsedQFile parentFile, String name, String namespace, String docDescription, Map<String, String> paramDescriptions, Map<String, String> exceptionDescriptions, String returnDescription, int offset) {
        HashMap<String, Map<String, String>> namedTags = new HashMap<String, Map<String, String>>();
        if (paramDescriptions != null) {
            namedTags.put(PARAM_TAG, Collections.unmodifiableMap(paramDescriptions));
        }
        if (exceptionDescriptions != null) {
            namedTags.put(EXCEPTION_TAG, Collections.unmodifiableMap(exceptionDescriptions));
        }
        return new ParsedQEntity(parentFile, name, namespace, docDescription, namedTags, EMPTY_MAP, returnDescription, offset);
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getHtmlDoc(boolean shortFormat) {
        return this.getHtmlDoc(shortFormat, null);
    }

    public String getHtmlDoc(boolean shortFormat, String baseWeblink) {
        boolean hasDocs = !this.docDescription.trim().isEmpty() || !this.tags.isEmpty() || !this.namedTags.isEmpty();
        String s = "";
        if (hasDocs) {
            String k;
            StringBuilder sb = new StringBuilder();
            sb.append("<html><body>");
            sb.append("<p>" + this.docDescription + "</p>");
            HashMap<String, String> namesToDescs = Maps.newHashMap();
            for (Map.Entry<String, String> entry : this.tags.entrySet()) {
                k = entry.getKey();
                if (k.equals(RETURN_TAG)) {
                    k = "Return";
                }
                namesToDescs.put(k + ": ", entry.getValue());
            }
            for (Map.Entry<String, Object> entry : this.namedTags.entrySet()) {
                k = entry.getKey();
                if (k.equals(PARAM_TAG)) {
                    k = "Parameters";
                } else if (k.equals(EXCEPTION_TAG)) {
                    k = "Exceptions";
                } else if (k.equals(COLUMN_TAG)) {
                    k = "Columns";
                }
                if (k.equals(EXAMPLE_TAG)) {
                    k = "Examples";
                    HashMap<String, String> codeMap = Maps.newHashMap();
                    ((Map)entry.getValue()).forEach((u, vv) -> {
                        if (baseWeblink != null && baseWeblink.length() > 0) {
                            u = "<a href='" + baseWeblink + "?" + vv + "'>" + u + "</a>";
                        }
                        codeMap.put((String)u, "<code>" + vv + "</code>");
                    });
                    namesToDescs.put(k + ": ", HtmlUtils.toList(codeMap, true));
                    continue;
                }
                namesToDescs.put(k + ": ", HtmlUtils.toList((Map)entry.getValue(), true));
            }
            sb.append(HtmlUtils.toTable(namesToDescs, true));
            sb.append("</body></html>");
            s = sb.toString();
        }
        return s;
    }

    @Override
    public String getDocName() {
        return this.getFullName();
    }

    @Override
    public String getFullName() {
        return (this.namespace.equals(".") ? "" : this.namespace + ".") + this.name;
    }

    String getDocDescription() {
        return this.docDescription;
    }

    Map<String, Map<String, String>> getNamedTags() {
        return Collections.unmodifiableMap(this.namedTags);
    }

    Map<String, String> getNamedTags(String tagName) {
        Map<String, String> r = this.namedTags.get(tagName);
        return r == null ? EMPTY_MAP : r;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public String getTag(String tag) {
        return this.tags.get(tag);
    }

    Map<String, String> getParamTags() {
        return this.getNamedTags(PARAM_TAG);
    }

    Map<String, String> getExceptionTags() {
        return this.getNamedTags(EXCEPTION_TAG);
    }

    String getReturnDescription() {
        return this.returnDescription;
    }

    private String getSrcFileAbsolutePath() {
        return this.parentFile == null ? null : this.parentFile.getSrcFileAbsolutePath();
    }

    public int getOffset() {
        return this.offset;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("namespace", this.namespace).add("srcFilePath", this.getSrcFileAbsolutePath()).add("offset", this.offset).toString();
    }

    public int hashCode() {
        return Objects.hashCode(super.hashCode(), this.name, this.namespace, this.docDescription, this.namedTags, this.getSrcFileAbsolutePath(), this.offset);
    }

    public String toFullString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("namespace", this.namespace).add("docDescription", this.docDescription).add("returnDescription", this.returnDescription).add("paramDescriptions", this.namedTags.get(PARAM_TAG)).add("exceptionDescriptions", this.namedTags.get(EXCEPTION_TAG)).add("srcFilePath", this.getSrcFileAbsolutePath()).add("offset", this.offset).toString();
    }

    public boolean equals(Object object) {
        if (object instanceof ParsedQEntity) {
            ParsedQEntity that = (ParsedQEntity)object;
            return Objects.equal(this.name, that.name) && Objects.equal(this.namespace, that.namespace) && Objects.equal(this.docDescription, that.docDescription) && Objects.equal(this.namedTags, that.namedTags) && Objects.equal(this.returnDescription, that.returnDescription);
        }
        return false;
    }

    public String getShortDescription() {
        String s = this.getDocDescription();
        int p = s.indexOf(46);
        return p == -1 ? s : s.substring(0, p + 1);
    }

    public void gotoDefinition(OpenDocumentsModel openDocumentsModel) throws IOException {
        String pth = this.getSrcFileAbsolutePath();
        if (pth != null) {
            Document d = openDocumentsModel.openDocument(pth);
            d.setCaratPosition(this.getOffset());
        }
    }

    @Override
    public ImageIcon getIcon() {
        return Theme.CIcon.PAGE_CODE.get16();
    }

    @Override
    public DocumentedEntity.SourceType getSourceType() {
        return DocumentedEntity.SourceType.SOURCE;
    }

    @Override
    public String getSource() {
        return this.parentFile.getFileTitle();
    }

    ParsedQFile getParentFile() {
        return this.parentFile;
    }

    String getName() {
        return this.name;
    }

    @Override
    public int compareTo(ParsedQEntity o) {
        return this.getFullName().compareTo(o.getFullName());
    }
}

