/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qdoc;

import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ParsedComments {
    public final String docDescription;
    public final String returnDescription;
    public final Map<String, Map<String, String>> namedTags;
    public final Map<String, String> tags = new HashMap<String, String>();

    private ParsedComments(List<String> comments) {
        this.namedTags = new HashMap<String, Map<String, String>>();
        ArrayListMultimap<String, String> t = ArrayListMultimap.create();
        String doc = "";
        String ret = "";
        String prevTag = "";
        for (String string : comments) {
            if (string.startsWith("@")) {
                int p = string.indexOf(32);
                if (p <= -1) continue;
                String tag = string.substring(1, p).trim();
                String value = string.substring(p).trim();
                if (tag.isEmpty() || value.isEmpty()) continue;
                t.put(tag, value);
                prevTag = tag;
                continue;
            }
            if (prevTag.isEmpty()) {
                if (doc.length() == 0) {
                    doc = doc + string;
                    continue;
                }
                doc = doc + " " + string;
                continue;
            }
            assert (!prevTag.isEmpty());
            ArrayList curVal = new ArrayList(t.get(prevTag));
            int li = curVal.size() - 1;
            curVal.set(li, (String)curVal.get(li) + " " + string);
            t.replaceValues(prevTag, curVal);
        }
        this.addIfExists(t, "param");
        this.addIfExists(t, "exception");
        ret = this.toDescription(t.get("return"));
        if (!ret.isEmpty()) {
            this.tags.put("return", ret);
        }
        t.removeAll("param");
        t.removeAll("exception");
        t.removeAll("return");
        for (Map.Entry entry : t.asMap().entrySet()) {
            if (((Collection)entry.getValue()).size() > 1) {
                this.namedTags.put((String)entry.getKey(), this.toMap((Collection)entry.getValue()));
                continue;
            }
            this.tags.put((String)entry.getKey(), this.toDescription((Collection)entry.getValue()));
        }
        this.docDescription = doc;
        this.returnDescription = ret;
    }

    private void addIfExists(Multimap<String, String> t, String tag) {
        Map<String, String> m = this.toMap(t.get(tag));
        if (m.size() > 0) {
            this.namedTags.put(tag, m);
        }
    }

    private String toDescription(Collection<String> lines) {
        return Joiner.on(" ").join(lines);
    }

    private Map<String, String> toMap(Collection<String> lines) {
        HashMap<String, String> r = Maps.newHashMap();
        for (String s : lines) {
            if (s.isEmpty()) continue;
            int p = s.indexOf(32);
            String k = p > -1 ? s.substring(0, p) : s;
            String v = p > -1 ? s.substring(p).trim() : "";
            r.put(k, v);
        }
        return r;
    }

    public static ParsedComments parse(List<String> comments) {
        return new ParsedComments(comments);
    }
}

