/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qdoc;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.timestored.docs.Document;
import com.timestored.docs.OpenDocumentsModel;
import com.timestored.qdoc.DocSource;
import com.timestored.qdoc.DocumentedEntity;
import com.timestored.qdoc.ParsedQEntity;
import com.timestored.qdoc.ParsedQFile;
import com.timestored.qdoc.QFileParser;
import com.timestored.qstudio.BackgroundExecutor;
import com.timestored.qstudio.Language;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class OpenDocumentsDocSource
implements DocSource,
OpenDocumentsModel.Listener {
    private static final Logger LOG = Logger.getLogger(OpenDocumentsDocSource.class.getName());
    private final OpenDocumentsModel openDocumentsModel;
    private Map<Document, ParsedQFile> docParseCache = Maps.newHashMap();
    private Map<String, ParsedQFile> folderParseCache = new ConcurrentHashMap<String, ParsedQFile>();
    private Future<Void> future;
    private Pattern ignoredFoldersRegex = Pattern.compile("");
    private File selectedFolder = null;
    private static final int MAX_FOLDER_SEARCH_DEPTH = 8;
    private static final int MAX_FILE_PARSE = 200;
    protected static final String FILE_SUFFIX = ".q";

    public OpenDocumentsDocSource(OpenDocumentsModel openDocumentsModel) {
        this.openDocumentsModel = openDocumentsModel;
        openDocumentsModel.addListener(this);
        this.startFolderParse(openDocumentsModel.getSelectedFolder());
    }

    private ParsedQFile parseAndCache(Document document) {
        Language lang = Language.getLanguage(document.getFileEnding());
        if (Language.Q.equals((Object)lang) || document.getFileEnding().length() == 0) {
            String fp = document.getFilePath();
            String fileId = document.getTitle();
            ParsedQFile pqf = QFileParser.parse(document.getContent(), fp, fileId);
            this.docParseCache.put(document, pqf);
            if (fp != null && this.folderParseCache.containsKey(fp)) {
                this.folderParseCache.put(document.getFilePath(), pqf);
            }
            return pqf;
        }
        return null;
    }

    @Override
    public void docClosed(Document document) {
        this.docParseCache.remove(document);
    }

    @Override
    public void docSaved() {
        Document d = this.openDocumentsModel.getSelectedDocument();
        if (d != null) {
            this.parseAndCache(d);
        }
    }

    @Override
    public void docAdded(Document document) {
    }

    @Override
    public void docContentModified() {
    }

    @Override
    public void docCaratModified() {
    }

    @Override
    public void docSelected(Document document) {
    }

    @Override
    public void folderSelected(File selectedFolder) {
        this.startFolderParse(selectedFolder);
    }

    @Override
    public void ignoredFolderPatternSelected(Pattern ignoredFolderPattern) {
        this.setIgnoredFoldersRegex(ignoredFolderPattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startFolderParse(final File folder) {
        OpenDocumentsDocSource openDocumentsDocSource = this;
        synchronized (openDocumentsDocSource) {
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
            }
            final ConcurrentHashMap<String, ParsedQFile> fParseCache = new ConcurrentHashMap<String, ParsedQFile>();
            this.folderParseCache = fParseCache;
            if (folder != null && folder.isDirectory()) {
                this.future = BackgroundExecutor.EXECUTOR.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        List<File> qFiles = OpenDocumentsDocSource.findFiles(folder, OpenDocumentsDocSource.FILE_SUFFIX, OpenDocumentsDocSource.this.ignoredFoldersRegex);
                        int i = 0;
                        for (File f : qFiles) {
                            if (Thread.currentThread().isInterrupted()) {
                                throw new RuntimeException();
                            }
                            if (i++ > 200) {
                                LOG.log(Level.WARNING, "stopping file parsing as hit MAX_FILE_PARSE");
                                break;
                            }
                            fParseCache.put(f.getAbsolutePath(), QFileParser.parse(f));
                        }
                        return null;
                    }
                });
            }
        }
    }

    public List<DocumentedEntity> getDocs() {
        ArrayList<DocumentedEntity> documentedEntities = Lists.newArrayList();
        HashSet<String> openDocFilePaths = Sets.newHashSet();
        for (Document document : this.openDocumentsModel.getDocuments()) {
            ParsedQFile pqf = this.docParseCache.get(document);
            if (pqf == null) {
                pqf = this.parseAndCache(document);
            }
            if (pqf == null) continue;
            openDocFilePaths.add(document.getFilePath());
            documentedEntities.addAll(pqf.getQEntities());
            documentedEntities.addAll(this.createNamespaceDocumentedEntity(pqf));
        }
        for (Map.Entry entry : this.folderParseCache.entrySet()) {
            if (openDocFilePaths.contains(entry.getKey())) continue;
            documentedEntities.addAll(((ParsedQFile)entry.getValue()).getQEntities());
            documentedEntities.addAll(this.createNamespaceDocumentedEntity((ParsedQFile)entry.getValue()));
        }
        return documentedEntities;
    }

    private Collection<? extends DocumentedEntity> createNamespaceDocumentedEntity(ParsedQFile parsedQFile) {
        ArrayList<ParsedQEntity> nsDocs = Lists.newArrayList();
        HashSet<String> namespaces = Sets.newHashSet();
        for (ParsedQEntity pq : parsedQFile.getQEntities()) {
            String ns = pq.getNamespace();
            if (ns.length() <= 1 || namespaces.contains(ns)) continue;
            ParsedQEntity nsPQE = ParsedQEntity.get(parsedQFile, "", ns, parsedQFile.getHeaderDoc(), null, null, "", pq.getOffset());
            nsDocs.add(nsPQE);
            namespaces.add(ns);
        }
        return nsDocs;
    }

    static List<File> findFiles(File directory, String suffix, Pattern ignoredFoldersRegex) {
        List<File> result = Collections.synchronizedList(new ArrayList());
        return OpenDocumentsDocSource.findFiles(result, directory, suffix, ignoredFoldersRegex);
    }

    private static List<File> findFiles(List<File> result, File directory, final String suffix, final Pattern ignoredFoldersRegex) {
        Preconditions.checkArgument(directory.isDirectory());
        ArrayList<File> directoriesToProcess = new ArrayList<File>();
        directoriesToProcess.add(directory);
        int i = 0;
        int depth = 0;
        while (i < directoriesToProcess.size() && depth < 8) {
            int dirSize = directoriesToProcess.size();
            while (i < dirSize) {
                File[] directories;
                File f = (File)directoriesToProcess.get(i);
                LOG.finer("searching " + f.getAbsolutePath());
                File[] filesFound = f.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(suffix);
                    }
                });
                if (filesFound != null) {
                    result.addAll(Arrays.asList(filesFound));
                }
                if ((directories = f.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        if (pathname.isDirectory()) {
                            return !ignoredFoldersRegex.matcher(pathname.getName()).matches();
                        }
                        return false;
                    }
                })) != null) {
                    directoriesToProcess.addAll(Arrays.asList(directories));
                }
                ++i;
            }
            LOG.fine(++depth + " levels deep in seach");
        }
        LOG.info("Searched " + directoriesToProcess.size() + " directories and found " + result.size() + " matches for " + suffix);
        return result;
    }

    private void setIgnoredFoldersRegex(Pattern ignoredFoldersRegex) {
        Preconditions.checkNotNull(ignoredFoldersRegex);
        if (!ignoredFoldersRegex.pattern().equals(this.ignoredFoldersRegex.pattern())) {
            this.ignoredFoldersRegex = ignoredFoldersRegex;
            this.startFolderParse(this.selectedFolder);
        }
    }
}

