/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qdoc;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.timestored.TimeStored;
import com.timestored.docs.Document;
import com.timestored.misc.HtmlUtils;
import com.timestored.misc.IOUtils;
import com.timestored.qdoc.ParsedQEntity;
import com.timestored.qdoc.ParsedQFile;
import com.timestored.qdoc.QFileParser;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class HtmlPqfOutputter {
    public static final String CSS_LINK = "<link rel=\"stylesheet\" href=\"qdoc.css\" type=\"text/css\" media=\"screen\" />";
    private static final String QDOC_LINK = "<a class='qlogo' href='" + TimeStored.Page.QDOC.url() + "' target='a'>q<span>Doc</span></a>";
    private static final String FILE_SUFFIX = ".html";
    private static final Logger LOG = Logger.getLogger(HtmlPqfOutputter.class.getName());
    private static final String C = ";";
    private static final int SD_LENGTH = 60;
    private static final String TAIL = "</body></html>";

    private HtmlPqfOutputter() {
    }

    public static List<String> output(List<Document> documents, File outdir, String baseWeblink) {
        ArrayList<String> errors = Lists.newArrayList();
        String destdir = outdir.getPath() + File.separator;
        if (!outdir.isDirectory()) {
            HtmlPqfOutputter.addLogError(errors, "Could not output documentation to " + destdir + "\r\nIt is not a valid directory.");
            return errors;
        }
        if (outdir.list().length > 0) {
            LOG.warning("directory is not empty!");
        }
        ArrayList<ParsedQFile> writtenDocs = Lists.newArrayList();
        for (Document d : documents) {
            try {
                String filename = destdir + d.getTitle() + FILE_SUFFIX;
                ParsedQFile pqf = QFileParser.parse(d.getContent(), d.getFilePath(), d.getTitle());
                String html = HtmlPqfOutputter.generateHTML(pqf, baseWeblink);
                IOUtils.writeStringToFile(html, new File(filename));
                writtenDocs.add(pqf);
            }
            catch (IOException e) {
                HtmlPqfOutputter.addLogError(errors, "Could not output documentation for " + d.getFilePath());
            }
        }
        try {
            String frameSetHtml = HtmlPqfOutputter.generateIndexListing(writtenDocs);
            File framesetFile = new File(destdir + "allclasses-frame.html");
            IOUtils.writeStringToFile(frameSetHtml, framesetFile);
        }
        catch (IOException e) {
            HtmlPqfOutputter.addLogError(errors, "Could not output allclasses-frame.html");
        }
        try {
            FileWriter fw = new FileWriter(new File(destdir, "manlisting.q"));
            HtmlPqfOutputter.generateQhelpTable(writtenDocs, fw);
            fw.close();
        }
        catch (IOException e) {
            HtmlPqfOutputter.addLogError(errors, "manlisting.q");
        }
        try {
            String fileSummaryHTML = HtmlPqfOutputter.generateFileSummaryHtml(writtenDocs);
            File dfile = new File(destdir + "package-summary.html");
            IOUtils.writeStringToFile(fileSummaryHTML, dfile);
        }
        catch (IOException e) {
            HtmlPqfOutputter.addLogError(errors, "Could not output package-summary.html");
        }
        try {
            String index = IOUtils.toString(HtmlPqfOutputter.class, "index.html");
            IOUtils.writeStringToFile(index, new File(destdir + "index.html"));
            HtmlPqfOutputter.saveQdocCssTo(destdir);
        }
        catch (IOException e) {
            HtmlPqfOutputter.addLogError(errors, "Could not output index.html");
        }
        return errors;
    }

    public static void saveQdocCssTo(String destdir) throws IOException {
        String d = destdir.endsWith(File.separator) ? destdir : destdir + File.separator;
        String css = IOUtils.toString(HtmlPqfOutputter.class, "qdoc.css");
        IOUtils.writeStringToFile(css, new File(d + "qdoc.css"));
    }

    private static String generateFileSummaryHtml(List<ParsedQFile> pqfiles) {
        StringBuilder sb = new StringBuilder();
        sb.append(HtmlUtils.getTSPageHead("Index Listing", QDOC_LINK, CSS_LINK, true));
        sb.append("<h1>Files</h1>");
        Collections.sort(pqfiles, new Comparator<ParsedQFile>(){

            @Override
            public int compare(ParsedQFile o1, ParsedQFile o2) {
                return o1.getFileTitle().compareTo(o2.getFileTitle());
            }
        });
        sb.append("<table  class='overviewSummary'>");
        sb.append("<tr><th>File</th><th>Description</th>");
        for (ParsedQFile pqf : pqfiles) {
            String fn = pqf.getFileTitle() + FILE_SUFFIX;
            sb.append("<tr><td>");
            HtmlPqfOutputter.makeLink(fn, pqf.getFileTitle());
            sb.append(HtmlPqfOutputter.makeLink(fn, pqf.getFileTitle()));
            sb.append("</td><td>");
            sb.append(pqf.getHeaderDoc());
            sb.append("</td></tr>");
        }
        sb.append("</table>");
        sb.append(HtmlUtils.getTSPageTail(QDOC_LINK));
        return sb.toString();
    }

    private static String makeLink(String href, String txt) {
        return "<a href='" + href + "' target='classFrame' >" + txt + "</a>";
    }

    private static String esc(String s) {
        if (s == null) {
            return "";
        }
        return "\"" + s.replace("\"", "\\\"") + "\"";
    }

    private static void generateQhelpTable(List<ParsedQFile> pqfiles, FileWriter w) throws IOException {
        for (ParsedQFile pqFile : pqfiles) {
            for (ParsedQEntity parsedQentity : pqFile.getQEntities()) {
                w.write(".man.registerFunc (");
                w.write(HtmlPqfOutputter.esc(parsedQentity.getFullName()));
                w.write(C);
                w.write(HtmlPqfOutputter.esc(parsedQentity.getNamespace()));
                w.write(C);
                w.write(HtmlPqfOutputter.esc(parsedQentity.getDocDescription()));
                w.write(C);
                w.write(HtmlPqfOutputter.esc(parsedQentity.getDocName()));
                w.write(C);
                String eg = parsedQentity.getTag("eg");
                if (eg == null) {
                    eg = parsedQentity.getTag("example");
                }
                w.write(HtmlPqfOutputter.esc(eg == null ? "" : eg));
                w.write(");\r\n");
                for (Map.Entry<String, Map<String, String>> entry : parsedQentity.getNamedTags().entrySet()) {
                    for (Map.Entry<String, String> paramDescriptionPair : entry.getValue().entrySet()) {
                        HtmlPqfOutputter.writeArg(w, parsedQentity.getFullName(), entry.getKey(), paramDescriptionPair.getKey(), paramDescriptionPair.getValue());
                    }
                }
                for (Map.Entry<String, Object> entry : parsedQentity.getTags().entrySet()) {
                    HtmlPqfOutputter.writeArg(w, parsedQentity.getFullName(), entry.getKey(), "", (String)entry.getValue());
                }
            }
        }
    }

    private static void writeArg(FileWriter w, String name, String tag, String subTag, String description) throws IOException {
        w.write(".man.registerArg (");
        w.write(HtmlPqfOutputter.esc(name));
        w.write(C);
        w.write(HtmlPqfOutputter.esc(tag));
        w.write(C);
        w.write(HtmlPqfOutputter.esc(subTag));
        w.write(C);
        w.write(HtmlPqfOutputter.esc(description));
        w.write(");\r\n");
    }

    private static String generateIndexListing(List<ParsedQFile> pqfiles) {
        Collection files;
        ArrayList<String> fileLinks = Lists.newArrayList();
        for (ParsedQFile parsedQFile : pqfiles) {
            String fn = parsedQFile.getFileTitle() + FILE_SUFFIX;
            fileLinks.add(HtmlPqfOutputter.makeLink(fn, parsedQFile.getFileTitle()));
            Collections.sort(fileLinks);
        }
        ArrayListMultimap<String, String> namespaceToFiles = ArrayListMultimap.create();
        for (ParsedQFile pqf : pqfiles) {
            for (ParsedQEntity pqe : pqf.getQEntities()) {
                files = namespaceToFiles.get(pqe.getNamespace());
                if (files != null && files.contains(pqf.getFileTitle())) continue;
                namespaceToFiles.put(pqe.getNamespace(), pqf.getFileTitle());
            }
        }
        ArrayList<String> arrayList = Lists.newArrayList();
        ArrayList<String> nsListing = Lists.newArrayList(namespaceToFiles.asMap().keySet());
        Collections.sort(nsListing);
        for (String ns : nsListing) {
            files = new ArrayList(namespaceToFiles.get(ns));
            if (files.size() > 1) {
                ArrayList<String> fileListing = Lists.newArrayList();
                for (String fileTitle : files) {
                    fileListing.add(HtmlPqfOutputter.makeLink(fileTitle + FILE_SUFFIX, fileTitle));
                }
                arrayList.add(ns + ": " + HtmlUtils.toList(fileListing));
                continue;
            }
            String fn = (String)files.get(0) + FILE_SUFFIX;
            arrayList.add(HtmlPqfOutputter.makeLink(fn, ns));
        }
        StringBuilder sb = new StringBuilder();
        String subTitleLink = "<a href='package-summary.html' target='classFrame' >Home</a> - " + QDOC_LINK;
        sb.append(HtmlUtils.getTSPageHead("Index Listing", subTitleLink, CSS_LINK, true));
        sb.append("<h1>Namespaces</h1>");
        sb.append(HtmlUtils.toList(arrayList));
        sb.append("<h1>Files</h1>");
        sb.append(HtmlUtils.toList(fileLinks));
        sb.append(HtmlUtils.getTSPageTail(QDOC_LINK));
        return sb.toString();
    }

    private static void addLogError(List<String> errors, String msg) {
        LOG.severe(msg);
        errors.add(msg);
    }

    static String generateHTML(ParsedQFile pqf) {
        return HtmlPqfOutputter.generateHTML(pqf, null);
    }

    static String generateHTML(ParsedQFile pqf, String baseWeblink) {
        StringBuilder s = new StringBuilder();
        String title = pqf.getFileTitle();
        s.append(HtmlUtils.getTSPageHead(title, QDOC_LINK, CSS_LINK, true));
        s.append("\r\n\t<div id='headerDoc'>");
        s.append(pqf.getHeaderDoc());
        s.append(HtmlUtils.toList(pqf.getHeaderTags(), true));
        s.append("</div>");
        s.append("\r\n\t<div id='summary'>");
        s.append("<h2>Entity Summary</h2>");
        HtmlPqfOutputter.appendTableOverview(s, pqf);
        s.append("</div>");
        s.append("\r\n\t<div class='details'>");
        s.append("\r\n\t<h2>Entity Details</h2>");
        HtmlPqfOutputter.appendEntityDetails(s, pqf, baseWeblink);
        s.append("</div>");
        s.append(HtmlUtils.getTSPageTail(QDOC_LINK));
        return s.toString();
    }

    private static boolean isInternal(ParsedQEntity e) {
        return e.getDocName().contains(".i.");
    }

    private static boolean hasDetails(ParsedQEntity e) {
        return !e.getDocDescription().equals(e.getShortDescription()) || e.getTags().size() > 0 || e.getNamedTags().size() > 0;
    }

    private static String getHtmlId(ParsedQEntity e) {
        return e.getDocName().replace('.', '-');
    }

    private static void appendEntityDetails(StringBuilder s, ParsedQFile pqf, String baseWeblink) {
        for (ParsedQEntity e : pqf.getQEntities()) {
            if (!HtmlPqfOutputter.hasDetails(e) || HtmlPqfOutputter.isInternal(e)) continue;
            s.append("\r\n\t\t<div class='entity' id='" + HtmlPqfOutputter.getHtmlId(e) + "'>");
            s.append("<h2>");
            if (baseWeblink != null && baseWeblink.length() > 0) {
                String args = "/" + e.getDocDescription() + "\r\n" + e.getDocName();
                try {
                    args = URLEncoder.encode(args, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                String anchor = "<a href='" + baseWeblink + "?" + args + "' target='a'>";
                s.append(anchor + e.getDocName()).append("</a>");
            } else {
                s.append(e.getDocName());
            }
            s.append("</h2>");
            s.append(HtmlUtils.extractBody(e.getHtmlDoc(false, baseWeblink)));
            s.append("</div>");
        }
    }

    private static void appendTableOverview(StringBuilder s, ParsedQFile pqf) {
        s.append("<table class='overviewSummary'><tbody>");
        s.append("<tr><th>Entities</th><th>Short Description</th></tr>");
        for (ParsedQEntity e : pqf.getQEntities()) {
            if (HtmlPqfOutputter.isInternal(e)) continue;
            s.append("\r\n\t\t<tr><td>");
            if (HtmlPqfOutputter.hasDetails(e)) {
                s.append("<a href='#" + HtmlPqfOutputter.getHtmlId(e) + "'>");
                s.append(e.getDocName());
                s.append("</a>");
            } else {
                s.append(e.getDocName());
            }
            s.append("</td><td>");
            String sd = e.getShortDescription();
            s.append(sd.length() <= 60 ? sd : sd.substring(0, 60));
            s.append("</td></tr>");
        }
        s.append("\r\n</tbody></table>");
    }
}

