/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qdoc;

import com.google.common.base.Preconditions;
import com.timestored.command.Command;
import com.timestored.command.CommandProvider;
import com.timestored.docs.OpenDocumentsModel;
import com.timestored.qdoc.DocumentedEntityDocCommand;
import com.timestored.qdoc.DocumentedMatcher;
import com.timestored.qdoc.ParsedQEntity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JOptionPane;

public class GotoDefinitionCommandProvider
implements CommandProvider {
    private final DocumentedMatcher documentedMatcher;
    private final OpenDocumentsModel openDocumentsModel;
    private final boolean showSource;
    private final String commandPrefix;

    public GotoDefinitionCommandProvider(DocumentedMatcher documentedMatcher, OpenDocumentsModel openDocumentsModel, boolean showSource, String commandPrefix) {
        this.documentedMatcher = Preconditions.checkNotNull(documentedMatcher);
        this.openDocumentsModel = Preconditions.checkNotNull(openDocumentsModel);
        this.showSource = showSource;
        this.commandPrefix = commandPrefix == null ? "" : commandPrefix;
    }

    @Override
    public Collection<Command> getCommands() {
        return GotoDefinitionCommandProvider.convert(this.documentedMatcher.findSourceDocs(), this.openDocumentsModel, this.showSource, this.commandPrefix);
    }

    public static List<Command> convert(List<ParsedQEntity> docs, final OpenDocumentsModel openDocumentsModel, boolean showSource, String commandPrefix) {
        Collections.sort(docs, new Comparator<ParsedQEntity>(){

            @Override
            public int compare(ParsedQEntity pq1, ParsedQEntity pq2) {
                int diff = pq1.getSource().compareTo(pq2.getSource());
                return diff != 0 ? diff : pq1.getOffset() - pq2.getOffset();
            }
        });
        ArrayList<Command> commands = new ArrayList<Command>();
        for (final ParsedQEntity parsedQEntity : docs) {
            DocumentedEntityDocCommand docCommand = new DocumentedEntityDocCommand(parsedQEntity, showSource, commandPrefix){

                @Override
                public void perform() {
                    try {
                        parsedQEntity.gotoDefinition(openDocumentsModel);
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(null, "Error Opening Source File:\r\n" + e.toString(), "Error Opening File", 0);
                    }
                }
            };
            commands.add(docCommand);
        }
        return commands;
    }
}

