/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qdoc;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.timestored.qdoc.CombinedDocumentedEntity;
import com.timestored.qdoc.DocCompleter;
import com.timestored.qdoc.DocSource;
import com.timestored.qdoc.DocumentedEntity;
import com.timestored.qdoc.ParsedQEntity;
import com.timestored.qdoc.Suggestion;
import com.timestored.qstudio.Language;
import com.timestored.qstudio.qdoc.ContextualDocCompleter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DocumentedMatcher
implements DocCompleter {
    private static final Logger LOG = Logger.getLogger(DocumentedMatcher.class.getName());
    private final Language language;
    private final DocSource docSource;
    private final String funcStart;
    private final String funcEnd;
    private final String argDivider;
    private final boolean ignoreCasing;
    private static final long STALE_TIME = 1000L;
    private List<DocumentedEntity> prevPrefixDocs;
    private Calendar calendar = Calendar.getInstance();
    private String prevPrefix;
    private long prevMillis = this.calendar.getTimeInMillis();
    private ContextualDocCompleter contextualDocCompleter;

    public DocumentedMatcher(Language language, DocSource docSource) {
        this(language, docSource, "[", "]", ";", false);
    }

    public DocumentedMatcher(Language language, DocSource docSource, String funcStart, String funcEnd, String argDivider, boolean ignoreCasing) {
        this.language = language;
        this.docSource = docSource;
        this.funcStart = funcStart;
        this.funcEnd = funcEnd;
        this.argDivider = argDivider;
        this.ignoreCasing = ignoreCasing;
    }

    public List<DocumentedEntity> findDocs(String txt, int caratPos) {
        Preconditions.checkNotNull(txt);
        Preconditions.checkArgument(caratPos >= 0 && caratPos <= txt.length());
        return this.findByFullname(DocumentedMatcher.getLatestFullname(txt, caratPos));
    }

    public DocumentedEntity findDoc(String txt, int caratPos) {
        List<DocumentedEntity> docs = this.findByFullname(DocumentedMatcher.getLatestFullname(txt, caratPos));
        if (docs.size() > 1) {
            try {
                List<DocumentedEntity> fullnameDocMatches = CombinedDocumentedEntity.filterToShortestFullNameMatch(docs);
                return fullnameDocMatches.size() == 1 ? fullnameDocMatches.get(0) : new CombinedDocumentedEntity(fullnameDocMatches);
            }
            catch (IllegalArgumentException iae) {
                LOG.log(Level.WARNING, iae.getMessage(), iae);
            }
        } else if (docs.size() == 1) {
            return docs.get(0);
        }
        return null;
    }

    public List<ParsedQEntity> findSourceDocs() {
        Predicate fileFilter = de -> de.getSourceType().equals((Object)DocumentedEntity.SourceType.SOURCE);
        ArrayList<ParsedQEntity> p = Lists.newArrayList();
        Iterables.filter(this.docSource.getDocs(), fileFilter).forEach(de -> p.add((ParsedQEntity)de));
        return p;
    }

    public List<ParsedQEntity> findSourceDocs(String sourceFilename) {
        Predicate fileFilter = de -> de instanceof ParsedQEntity && de.getSourceType().equals((Object)DocumentedEntity.SourceType.SOURCE) && de.getSource().equals(sourceFilename);
        ArrayList<ParsedQEntity> p = Lists.newArrayList();
        Iterables.filter(this.docSource.getDocs(), fileFilter).forEach(de -> p.add((ParsedQEntity)de));
        return p;
    }

    public Suggestion getSuggestion(DocumentedEntity de, String txt, int caratPos) {
        return this.getSuggestion(de, DocumentedMatcher.getLatestPrefix(txt, caratPos));
    }

    List<Suggestion> findSuggestions(String txt, int caratPos) {
        List<DocumentedEntity> r = this.findByPrefix(DocumentedMatcher.getLatestPrefix(txt, caratPos));
        Iterable i = Iterables.transform(r, de -> this.getSuggestion((DocumentedEntity)de, DocumentedMatcher.getLatestPrefix(txt, caratPos)));
        return Lists.newArrayList(i);
    }

    private Suggestion getSuggestion(DocumentedEntity de, String latestPrefix) {
        String textInsert = de.getDocName().substring(latestPrefix.length());
        int start = textInsert.length();
        int end = textInsert.length();
        boolean emptyCall = textInsert.contains(this.funcStart + this.funcEnd);
        if (textInsert.contains(this.funcStart) && !emptyCall) {
            start = textInsert.indexOf(this.funcStart) + 1;
            String ending = textInsert.substring(start);
            if (ending.contains(this.argDivider)) {
                end = start + ending.indexOf(this.argDivider);
            } else if (ending.contains(this.funcEnd)) {
                end = start + ending.indexOf(this.funcEnd);
            }
        }
        return new Suggestion(de, textInsert, start, end);
    }

    private List<DocumentedEntity> findByFullname(String fullname) {
        String cleanName = this.removeArgs(fullname);
        Predicate fullMatchFilter = de -> cleanName.equals(this.removeArgs(de.getDocName()));
        return this.sortByName(Lists.newArrayList(Iterables.filter(this.docSource.getDocs(), fullMatchFilter)));
    }

    private String removeArgs(String docName) {
        int p = docName.indexOf(this.funcStart);
        return p != -1 ? docName.trim().substring(0, p) : docName;
    }

    public List<? extends DocumentedEntity> getDocs() {
        return this.docSource.getDocs();
    }

    @Override
    public List<DocumentedEntity> findByPrefix(String txt, int caratPos) {
        List<DocumentedEntity> docsToComplete;
        if (this.contextualDocCompleter != null && (docsToComplete = this.contextualDocCompleter.findByPrefix(txt, caratPos)) != null && docsToComplete.size() > 0) {
            return docsToComplete;
        }
        return this.findByPrefix(DocumentedMatcher.getLatestPrefix(txt, caratPos));
    }

    private List<DocumentedEntity> findByPrefix(final String latestPrefix) {
        List<DocumentedEntity> docs = null;
        Predicate<DocumentedEntity> prefixFilter = new Predicate<DocumentedEntity>(){

            @Override
            public boolean apply(DocumentedEntity de) {
                if (DocumentedMatcher.this.ignoreCasing) {
                    return de.getDocName().toLowerCase().startsWith(latestPrefix.toLowerCase());
                }
                return de.getDocName().startsWith(latestPrefix);
            }
        };
        long ticksNow = Calendar.getInstance().getTimeInMillis();
        boolean longTimeBetweenSearch = ticksNow - this.prevMillis > 1000L;
        boolean extensionToLastSearch = this.prevPrefix != null && latestPrefix.startsWith(this.prevPrefix);
        docs = extensionToLastSearch && !longTimeBetweenSearch ? ImmutableList.copyOf(Iterables.filter(this.prevPrefixDocs, prefixFilter)) : this.sortByName(Lists.newArrayList(Iterables.filter(this.docSource.getDocs(), prefixFilter)));
        this.prevPrefixDocs = docs;
        this.prevPrefix = latestPrefix;
        LOG.info("Found " + docs.size() + " docs for prefix: " + latestPrefix);
        return docs;
    }

    private List<DocumentedEntity> sortByName(List<DocumentedEntity> docs) {
        Collections.sort(docs, (de1, de2) -> de1.getDocName().compareTo(de2.getDocName()));
        return docs;
    }

    static String getLatestPrefix(String txt, int caratPos) {
        int startPos;
        Preconditions.checkNotNull(txt);
        Preconditions.checkArgument(caratPos >= 0 && caratPos <= txt.length());
        String doc = txt.substring(0, caratPos);
        for (startPos = caratPos - 1; startPos >= 0; --startPos) {
            char ch = txt.charAt(startPos);
            if (Character.isLetter(ch) || ch == '.' || Character.isDigit(ch) || ch == '_') continue;
            ++startPos;
            break;
        }
        if (startPos <= 0) {
            return doc;
        }
        return doc.substring(startPos);
    }

    static String getLatestFullname(String txt, int caratPos) {
        char ch;
        int endPos;
        for (endPos = caratPos; endPos < txt.length() && (Character.isLetter(ch = txt.charAt(endPos)) || ch == '_' || ch == '.'); ++endPos) {
        }
        String before = DocumentedMatcher.getLatestPrefix(txt, caratPos);
        if (endPos >= txt.length()) {
            return before + txt.substring(caratPos);
        }
        return before + txt.substring(caratPos, endPos);
    }

    public void setContextDocCompleter(ContextualDocCompleter contextualDocCompleter) {
        this.contextualDocCompleter = contextualDocCompleter;
    }

    public Language getLanguage() {
        return this.language;
    }
}

