/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qdoc;

import com.timestored.misc.HtmlUtils;
import com.timestored.qdoc.DocumentedEntity;
import com.timestored.swingxx.SwingUtils;
import com.timestored.theme.Theme;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.ScrollableSizeHint;

public class DocumentationDialog
extends JDialog {
    public static final Dimension PREF_DIMENSION = new Dimension(600, 350);

    public DocumentationDialog(DocumentedEntity documentedEntity) {
        this.setLayout(new BorderLayout());
        JPanel docPanel = DocumentationDialog.getDocPanel(documentedEntity);
        docPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.add(docPanel);
        docPanel.getActionMap().put("closeAll", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DocumentationDialog.this.dispose();
            }
        });
        docPanel.getInputMap().put(SwingUtils.ESC_KEYSTROKE, "closeAll");
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowLostFocus(WindowEvent e) {
                DocumentationDialog.this.dispose();
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }
        });
        this.setPreferredSize(PREF_DIMENSION);
        this.setSize(PREF_DIMENSION);
        this.setName("documentationDialog");
    }

    public static JPanel getDocPanel(DocumentedEntity documentedEntity) {
        JXPanel p = new JXPanel(new BorderLayout());
        JTextPane txtPane = new JTextPane();
        txtPane.setContentType("text/html");
        txtPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    HtmlUtils.browse(e.getURL().toString());
                }
            }
        });
        if (documentedEntity != null) {
            p.add((Component)Theme.getSubHeader(documentedEntity.getDocName()), "North");
            txtPane.setText(documentedEntity.getHtmlDoc(false));
        } else {
            p.add((Component)Theme.getSubHeader("No Docs Found"), "North");
            txtPane.setText("<html><body><h3>Could not find any documentation</h3></body></html>");
        }
        txtPane.setEditable(false);
        p.setBorder(BorderFactory.createRaisedBevelBorder());
        p.setScrollableTracksViewportWidth(true);
        p.setScrollableWidthHint(ScrollableSizeHint.FIT);
        JScrollPane scrollPane = new JScrollPane(txtPane, 22, 31);
        txtPane.setCaretPosition(0);
        p.add((Component)scrollPane, "Center");
        return p;
    }

    public static String getTooltip(DocumentedEntity documentedEntity) {
        String s = HtmlUtils.extractBody(documentedEntity.getHtmlDoc(true).trim()).trim();
        if (s.length() > 0) {
            return "<html><body><div width='300px'><h2>" + documentedEntity.getDocName() + "</h2>" + s + "<br/></div>" + "</body></html>";
        }
        return null;
    }
}

