/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qdoc;

import com.google.common.base.Preconditions;
import com.timestored.misc.HtmlUtils;
import com.timestored.qdoc.DocumentedEntity;
import com.timestored.theme.Theme;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;

class CombinedDocumentedEntity
implements DocumentedEntity {
    private static final Logger LOG = Logger.getLogger(CombinedDocumentedEntity.class.getName());
    private List<DocumentedEntity> docs;
    private String source = "";

    public CombinedDocumentedEntity(List<DocumentedEntity> docs) {
        Preconditions.checkArgument(docs.size() > 1);
        for (DocumentedEntity de : docs) {
            boolean namesEqual = de.getFullName().equals(docs.get(0).getFullName());
            Preconditions.checkArgument(namesEqual);
            this.source = this.source + de.getSource() + " ";
        }
        this.docs = docs;
    }

    @Override
    public String getDocName() {
        String longestDocName = "";
        for (DocumentedEntity docE : this.docs) {
            if (docE.getDocName().length() <= longestDocName.length()) continue;
            longestDocName = docE.getDocName();
        }
        return longestDocName;
    }

    @Override
    public String getHtmlDoc(boolean shortFormat) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body>");
        for (int i = 0; i < this.docs.size(); ++i) {
            DocumentedEntity docE = this.docs.get(i);
            sb.append(this.docs.size() > 6 ? "<br /><br /><b>" : (this.docs.size() > 3 ? "<h3>" : "<h2>"));
            sb.append((Object)docE.getSourceType()).append(" ").append(docE.getSource());
            sb.append(this.docs.size() > 6 ? "</b>: " : (this.docs.size() > 3 ? "</h3>" : "</h2>"));
            sb.append(HtmlUtils.extractBody(docE.getHtmlDoc(this.docs.size() > 1)));
            if (!shortFormat || i <= 6) continue;
            sb.append("...");
            break;
        }
        sb.append("</body></html>");
        String s = sb.toString();
        if (shortFormat) {
            s = s.replace("<br />", "<br/>");
            int lastIndex = 0;
            int count = 0;
            while ((lastIndex = s.indexOf("<br/>", lastIndex)) != -1) {
                lastIndex += "<br/>".length() - 1;
                if (++count <= 10) continue;
                return s.substring(0, lastIndex + 1) + "..." + "</body></html>";
            }
        }
        return s;
    }

    @Override
    public ImageIcon getIcon() {
        return Theme.CIcon.TEXT_HTML.get16();
    }

    @Override
    public DocumentedEntity.SourceType getSourceType() {
        return DocumentedEntity.SourceType.MIXED;
    }

    @Override
    public String getFullName() {
        return this.docs.get(0).getFullName();
    }

    @Override
    public String getSource() {
        return this.source;
    }

    public static List<DocumentedEntity> filterToShortestFullNameMatch(List<DocumentedEntity> docs) {
        int shortestDocLength = docs.stream().map(de -> de.getFullName().length()).min(Integer::compare).get();
        List shortestMatches = docs.stream().filter(de -> de.getFullName().length() == shortestDocLength).collect(Collectors.toList());
        return shortestMatches.stream().filter(de -> de.getFullName().equals(((DocumentedEntity)shortestMatches.get(0)).getFullName())).collect(Collectors.toList());
    }
}

